/*
 * Decompiled with CFR 0.152.
 */
package ru.netherdon.netheragriculture.compat.clothconfig;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import ru.netherdon.netheragriculture.compat.clothconfig.ConfigPermission;
import ru.netherdon.netheragriculture.compat.clothconfig.ConfigScreenHelper;
import ru.netherdon.netheragriculture.config.NACommonConfig;
import ru.netherdon.netheragriculture.config.NAServerConfig;
import ru.netherdon.netheragriculture.config.settings.common.ConfiguredFeatureSettings;
import ru.netherdon.netheragriculture.config.settings.common.FabricLootModifierSettings;
import ru.netherdon.netheragriculture.config.settings.common.FarmersDelightSettings;
import ru.netherdon.netheragriculture.config.settings.common.LootModifierSettings;
import ru.netherdon.netheragriculture.config.settings.common.ModCompatibilitySettings;
import ru.netherdon.netheragriculture.config.settings.common.NethersDelightSettings;
import ru.netherdon.netheragriculture.config.settings.common.OverrideSettings;
import ru.netherdon.netheragriculture.config.settings.server.EntitySettings;
import ru.netherdon.netheragriculture.misc.TranslationHelper;

@Environment(value=EnvType.CLIENT)
public class ConfigScreenBuilder {
    private static final String CATEGORY_NAMESPACE = "config.category";
    private static final class_2561 OVERRIDES_CATEGORY = TranslationHelper.text("config.category", "overrides");
    private static final class_2561 ENTITY_CATEGORY = TranslationHelper.text("config.category", "entity");
    private static final class_2561 MOD_COMPATIBILITY_CATEGORY = TranslationHelper.text("config.category", "mod_compatibility");
    private static final class_2561 TITLE = class_2561.method_43470((String)"Nether Agriculture");

    public static class_437 build(class_437 lastScreen) {
        NAServerConfig server = NAServerConfig.get();
        NACommonConfig common = NACommonConfig.get();
        class_310 minecraft = class_310.method_1551();
        ConfigBuilder builder = ConfigBuilder.create();
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        builder.setParentScreen(lastScreen);
        builder.setTitle(TITLE);
        builder.alwaysShowTabs();
        ConfigPermission serverPermission = ConfigPermission.server(minecraft);
        ConfigScreenBuilder.buildEntityCategory(server.entity, builder, entryBuilder, serverPermission);
        ConfigScreenBuilder.buildOverridesCategory(common.overrides, builder, entryBuilder, ConfigPermission.ALL);
        ConfigScreenBuilder.buildModCompatibilityCategory(common.modCompatibility, builder, entryBuilder, ConfigPermission.ALL);
        return builder.build();
    }

    private static void buildOverridesCategory(OverrideSettings overrides, ConfigBuilder builder, ConfigEntryBuilder entryBuilder, ConfigPermission permission) {
        ConfigCategory category = builder.getOrCreateCategory(OVERRIDES_CATEGORY);
        LootModifierSettings lootModifier = overrides.lootModifier();
        ArrayList subEntries = Lists.newArrayList();
        subEntries.add(ConfigScreenHelper.booleanToggle(lootModifier.piglinBarteringEnabled(), entryBuilder, permission).build());
        if (lootModifier.fabric() != null) {
            FabricLootModifierSettings fabricModifiers = lootModifier.fabric();
            subEntries.add(ConfigScreenHelper.booleanToggle(fabricModifiers.hoglinEnabled(), entryBuilder, permission).build());
            subEntries.add(ConfigScreenHelper.booleanToggle(fabricModifiers.striderEnabled(), entryBuilder, permission).build());
            subEntries.add(ConfigScreenHelper.booleanToggle(fabricModifiers.netherBridgeEnabled(), entryBuilder, permission).build());
            subEntries.add(ConfigScreenHelper.booleanToggle(fabricModifiers.bastionHoglinStableEnabled(), entryBuilder, permission).build());
        }
        category.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory((class_2561)TranslationHelper.text(CATEGORY_NAMESPACE, "overrides", "loot"), (List)subEntries).build());
        ConfiguredFeatureSettings configuredFeature = overrides.configuredFeature();
        ArrayList cfEntries = Lists.newArrayList();
        cfEntries.add(ConfigScreenHelper.booleanToggle(configuredFeature.crimsonForestVegetationEnabled(), entryBuilder, permission).build());
        cfEntries.add(ConfigScreenHelper.booleanToggle(configuredFeature.crimsonNyliumBonemealEnabled(), entryBuilder, permission).build());
        cfEntries.add(ConfigScreenHelper.booleanToggle(configuredFeature.warpedForestVegetationEnabled(), entryBuilder, permission).build());
        cfEntries.add(ConfigScreenHelper.booleanToggle(configuredFeature.warpedNyliumBonemealEnabled(), entryBuilder, permission).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory((class_2561)TranslationHelper.text(CATEGORY_NAMESPACE, "overrides", "configured_feature"), (List)cfEntries).build());
    }

    private static void buildEntityCategory(EntitySettings worldSettings, ConfigBuilder builder, ConfigEntryBuilder entryBuilder, ConfigPermission permission) {
        ConfigCategory category = builder.getOrCreateCategory(ENTITY_CATEGORY);
        category.addEntry((AbstractConfigListEntry)ConfigScreenHelper.booleanToggle(worldSettings.burningFromItemEnabled(), entryBuilder, permission).build());
        category.addEntry((AbstractConfigListEntry)ConfigScreenHelper.booleanToggle(worldSettings.burningFromBlazeFlightEnabled(), entryBuilder, permission).build());
    }

    private static void buildModCompatibilityCategory(ModCompatibilitySettings settings, ConfigBuilder builder, ConfigEntryBuilder entryBuilder, ConfigPermission permission) {
        ConfigCategory category = builder.getOrCreateCategory(MOD_COMPATIBILITY_CATEGORY);
        FarmersDelightSettings farmersDelight = settings.farmersDelight();
        category.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory((class_2561)TranslationHelper.text(CATEGORY_NAMESPACE, "mod_compatibility", "farmers_delight"), List.of(ConfigScreenHelper.booleanToggle(farmersDelight.fullRecipeIntegrationEnabled(), entryBuilder, permission).build())).setExpanded(true).build());
        NethersDelightSettings nethersDelightSettings = settings.nethersDelight();
        category.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory((class_2561)TranslationHelper.text(CATEGORY_NAMESPACE, "mod_compatibility", "nethers_delight"), List.of(ConfigScreenHelper.booleanToggle(nethersDelightSettings.useOnlyBlackFurnace(), entryBuilder, permission).build())).setExpanded(true).build());
    }
}

