/*
 * Decompiled with CFR 0.152.
 */
package ru.netherdon.netheragriculture.compat.clothconfig;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.neoforged.neoforge.common.ModConfigSpec;
import ru.netherdon.netheragriculture.compat.clothconfig.ConfigPermission;
import ru.netherdon.netheragriculture.misc.TranslationHelper;

public final class ConfigScreenHelper {
    private static final class_2561 INWORLD_CATEGORY_DESCRIPTION = TranslationHelper.text("config", "inworld_category_description").method_27692(class_124.field_1061);
    private static final class_2561 ONLINE_MODE_CATEGORY_DESCRIPTION = TranslationHelper.text("config", "online_mode_category_description").method_27692(class_124.field_1061);
    private static final class_2561 CHANGE_ALERT = TranslationHelper.text("config", "server_properties_change_alert").method_27692(class_124.field_1054);

    public static <T extends Enum<T>> EnumSelectorBuilder<T> enumSelector(ModConfigSpec.EnumValue<T> configValue, ConfigEntryBuilder builder, Class<T> enumClass, ConfigPermission permission) {
        return ConfigScreenHelper.init(builder.startEnumSelector(ConfigScreenHelper.name(configValue), enumClass, (Enum)ConfigScreenHelper.value(configValue, permission)).setEnumNameProvider(val -> {
            String string;
            if (val instanceof class_3542) {
                class_3542 str = (class_3542)val;
                string = str.method_15434();
            } else {
                string = val.name();
            }
            return class_2561.method_43470((String)string);
        }), configValue, permission);
    }

    public static BooleanToggleBuilder booleanToggle(ModConfigSpec.BooleanValue configValue, ConfigEntryBuilder builder, ConfigPermission permission) {
        return ConfigScreenHelper.init(builder.startBooleanToggle(ConfigScreenHelper.name(configValue), ((Boolean)ConfigScreenHelper.value(configValue, permission)).booleanValue()), configValue, permission);
    }

    public static IntFieldBuilder intField(ModConfigSpec.ConfigValue<Integer> configValue, ConfigEntryBuilder builder, ConfigPermission permission) {
        IntFieldBuilder result = ConfigScreenHelper.init(builder.startIntField(ConfigScreenHelper.name(configValue), ConfigScreenHelper.value(configValue, permission).intValue()), configValue, permission);
        ModConfigSpec.Range range = configValue.getSpec().getRange();
        if (range != null) {
            result.setMin((Object)((Integer)range.getMin()));
            result.setMax((Object)((Integer)range.getMax()));
        }
        return result;
    }

    public static IntSliderBuilder percentageSlider(ModConfigSpec.ConfigValue<Integer> configValue, ConfigEntryBuilder builder, ConfigPermission permission) {
        ModConfigSpec.Range range = configValue.getSpec().getRange();
        return ConfigScreenHelper.init(builder.startIntSlider(ConfigScreenHelper.name(configValue), ConfigScreenHelper.value(configValue, permission).intValue(), ((Integer)range.getMin()).intValue(), ((Integer)range.getMax()).intValue()), configValue, permission).setTextGetter(value -> class_2561.method_43470((String)(value + "%")));
    }

    public static <V, T extends AbstractFieldBuilder<V, ?, ?>> T init(T t, ModConfigSpec.ConfigValue<V> configValue, ConfigPermission permission) {
        t.setDefaultValue(configValue.getDefault());
        t.setSaveConsumer(permission.levelLoaded() ? value -> {
            configValue.set(value);
            configValue.save();
        } : null);
        t.setRequirement(permission::entryAvailable);
        t.setTooltip(ConfigScreenHelper.tooltip(configValue, permission));
        t.requireRestart(configValue.getSpec().restartType() == ModConfigSpec.RestartType.GAME);
        return t;
    }

    public static <T> T value(ModConfigSpec.ConfigValue<T> configValue, ConfigPermission permission) {
        return (T)(permission.levelLoaded() ? configValue.getRaw() : configValue.getDefault());
    }

    public static class_2561 name(ModConfigSpec.ConfigValue<?> value) {
        String key = value.getSpec().getTranslationKey();
        if (key == null) {
            key = String.join((CharSequence)".", value.getPath());
        }
        return class_2561.method_43471((String)key);
    }

    public static Optional<class_2561[]> tooltip(ModConfigSpec.ConfigValue<?> value, ConfigPermission permission) {
        ArrayList list = Lists.newArrayList();
        String key = value.getSpec().getTranslationKey();
        if (key == null) {
            return Optional.empty();
        }
        class_5250 text = class_2561.method_48321((String)(key + ".tooltip"), (String)"");
        if (!text.getString().isEmpty()) {
            list.add(text);
        }
        if (!permission.levelLoaded()) {
            list.add(INWORLD_CATEGORY_DESCRIPTION);
        } else if (!permission.isSingleplayer()) {
            list.add(ONLINE_MODE_CATEGORY_DESCRIPTION);
        }
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.toArray(new class_2561[0]));
    }
}

