/*
 * Decompiled with CFR 0.152.
 */
package ru.netherdon.netheragriculture.fabric.registries;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_117;
import net.minecraft.class_165;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_83;
import net.minecraft.class_85;
import ru.netherdon.netheragriculture.NetherAgriculture;
import ru.netherdon.netheragriculture.config.NACommonConfig;
import ru.netherdon.netheragriculture.config.settings.common.LootModifierSettings;
import ru.netherdon.netheragriculture.misc.LootTableHelper;
import ru.netherdon.netheragriculture.registries.LootTableNames;
import ru.netherdon.netheragriculture.registries.NAItems;
import ru.netherdon.netheragriculture.registries.NAPiglinBartering;

public final class NALootTableModifiers {
    public static void initialize() {
        LootTableEvents.MODIFY.register(NALootTableModifiers::modify);
    }

    private static void modify(class_5321<class_52> key, class_52.class_53 builder, LootTableSource source, class_7225.class_7874 registries) {
        if (!source.isBuiltin()) {
            return;
        }
        class_2960 tableId = key.method_29177();
        if (tableId.equals((Object)LootTableNames.NETHER_BRIDGE)) {
            if (NALootTableModifiers.config().fabric().isNetherBridgeEnabled()) {
                builder.method_336(class_55.method_347().method_351(NALootTableModifiers.reference("modifiers/chests/nether_bridge")));
            }
        } else if (tableId.equals((Object)LootTableNames.STRIDER)) {
            if (NALootTableModifiers.config().fabric().isStriderEnabled()) {
                builder.method_336(class_55.method_347().method_351(NALootTableModifiers.reference("modifiers/strider_leg")));
            }
        } else if (tableId.equals((Object)LootTableNames.PIGLIN_BARTERING)) {
            if (NALootTableModifiers.config().isPiglinBarteringEnabled()) {
                LootTableHelper.extendLootPool((class_55)builder.field_949.build().getFirst(), NAPiglinBartering.getAdditionalEntries());
            }
        } else if (!FabricLoader.getInstance().isModLoaded("mynethersdelight")) {
            if (tableId.equals((Object)LootTableNames.BASTION_HOGLIN_STABLE)) {
                if (NALootTableModifiers.config().fabric().isBastionHoglinStableEnabled()) {
                    NALootTableModifiers.replaceItem(builder, Map.of(class_1802.field_8389, NALootTableModifiers.toItem(NAItems.HOGLIN_MEAT), class_1802.field_8261, NALootTableModifiers.toItem(NAItems.COOKED_HOGLIN_MEAT)));
                }
            } else if (tableId.equals((Object)LootTableNames.HOGLIN) && NALootTableModifiers.config().fabric().isHoglinEnabled()) {
                NALootTableModifiers.replaceItem(builder, Map.of(class_1802.field_8389, NALootTableModifiers.all(NALootTableModifiers.toItem(NAItems.HOGLIN_MEAT), NALootTableModifiers.removeSmelting())));
            }
        }
    }

    private static Modifier all(Modifier ... modifiers) {
        return loot -> {
            for (Modifier modifier : modifiers) {
                loot = modifier.modify(loot);
            }
            return loot;
        };
    }

    private static Modifier toItem(class_6880<class_1792> item) {
        return loot -> {
            loot.field_987 = item;
            return loot;
        };
    }

    private static Modifier removeSmelting() {
        return loot -> {
            ImmutableList.Builder newFunctions = ImmutableList.builder();
            for (class_117 function : loot.field_996) {
                if (function instanceof class_165) continue;
                newFunctions.add((Object)function);
            }
            loot.field_996 = newFunctions.build();
            return loot;
        };
    }

    private static void replaceItem(class_52.class_53 tableBuilder, Map<class_1792, Modifier> modifiers) {
        tableBuilder.modifyPools(poolBuilder -> {
            ImmutableList oldEntries = poolBuilder.field_960.build();
            poolBuilder.field_960 = ImmutableList.builder();
            for (class_79 container : oldEntries) {
                poolBuilder.with(container);
                if (container instanceof class_77) {
                    class_77 lootItem = (class_77)container;
                    if (modifiers.containsKey(lootItem.field_987.comp_349())) {
                        poolBuilder.with((class_79)((Modifier)modifiers.get(lootItem.field_987.comp_349())).modify(lootItem));
                        continue;
                    }
                }
                poolBuilder.with(container);
            }
        });
    }

    private static class_5321<class_52> key(String name) {
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)NetherAgriculture.location(name));
    }

    private static LootModifierSettings config() {
        return NACommonConfig.get().overrides.lootModifier();
    }

    private static class_85.class_86<?> reference(String name) {
        return class_83.method_428(NALootTableModifiers.key(name));
    }

    private static interface Modifier {
        public class_77 modify(class_77 var1);
    }
}

