/*
 * Decompiled with CFR 0.152.
 */
package ru.netherdon.netheragriculture.services;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import ru.netherdon.netheragriculture.misc.ModLoaderTypes;
import ru.netherdon.netheragriculture.services.fabric.ModLoaderServiceImpl;

public final class ModLoaderService {
    @ExpectPlatform
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return ModLoaderServiceImpl.isModLoaded(modId);
    }

    public static boolean anyModLoaded(String ... modIds) {
        return Arrays.stream(modIds).anyMatch(ModLoaderService::isModLoaded);
    }

    @ExpectPlatform
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static ModLoaderTypes getModLoaderType() {
        return ModLoaderServiceImpl.getModLoaderType();
    }
}

