/*
 * Decompiled with CFR 0.152.
 */
package com.vision.restartannouncer;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.vision.restartannouncer.ConfigManager;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class CommandHandler {
    private static final SuggestionProvider<class_2168> timeSuggestions = (ctx, builder) -> {
        for (String t : ConfigManager.getFormattedRestartTimes()) {
            builder.suggest(t.replace(":", "-"));
        }
        return builder.buildFuture();
    };

    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rsa").then(class_2170.method_9247((String)"help").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_5250 discordBtn = class_2561.method_43470((String)"[Discord]").method_10862(class_2583.field_24360.method_36139(7506394).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://vision-projects.eu/discord")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Klicke, um zum Discord-Server zu gelangen"))));
            class_5250 webBtn = class_2561.method_43470((String)"[Webseite]").method_10862(class_2583.field_24360.method_36139(45044).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://vision-projects.eu")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Klicke, um die Webseite zu \u00f6ffnen"))));
            src.method_9226(() -> CommandHandler.lambda$registerCommands$1((class_2561)discordBtn, (class_2561)webBtn), false);
            return 1;
        }))).then(class_2170.method_9247((String)"clock").executes(ctx -> {
            String timeStr = LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Server-Uhr: " + timeStr)), false);
            return 1;
        }))).then(class_2170.method_9247((String)"send").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> CommandHandler.executeAnnounce((CommandContext<class_2168>)ctx, false))).then(class_2170.method_9247((String)"sound").executes(ctx -> CommandHandler.executeAnnounce((CommandContext<class_2168>)ctx, true)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            ConfigManager.loadConfig();
            src.method_9226(() -> class_2561.method_43470((String)"\u00a7aKonfiguration neu geladen."), false);
            List<String> times = ConfigManager.getFormattedRestartTimes();
            if (times.isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)"Keine Zeiten festgelegt"), false);
            } else {
                src.method_9226(() -> class_2561.method_43470((String)"Das ist der neue Zeitplan:"), false);
                for (String t : times) {
                    src.method_9226(() -> class_2561.method_43470((String)("T\u00e4glich: " + t)), false);
                }
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"plan").then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            List<String> times = ConfigManager.getFormattedRestartTimes();
            if (times.isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)"Keine Zeiten festgelegt"), false);
            } else {
                src.method_9226(() -> class_2561.method_43470((String)"Aktueller Restartplan:"), false);
                for (String t : times) {
                    src.method_9226(() -> class_2561.method_43470((String)("T\u00e4glich: " + t)), false);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"time");
            String replaced = raw.replace("-", ":");
            try {
                LocalTime t = LocalTime.parse(replaced, DateTimeFormatter.ofPattern("HH:mm"));
                boolean added = ConfigManager.addRestartTime(replaced);
                if (added) {
                    src.method_9226(() -> class_2561.method_43470((String)("\u00a7aZeit hinzugef\u00fcgt: " + String.valueOf(t))), false);
                } else {
                    src.method_9226(() -> class_2561.method_43470((String)("\u00a7eZeit bereits vorhanden: " + String.valueOf(t))), false);
                }
            }
            catch (DateTimeParseException e) {
                src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cUng\u00fcltiges Format. Bitte nutze HH-mm, z.\u202fB. 14-30"));
            }
            catch (IOException e) {
                src.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFehler beim Schreiben in die Config: " + e.getMessage())));
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.word()).suggests(timeSuggestions).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"time");
            String replaced = raw.replace("-", ":");
            try {
                LocalTime t = LocalTime.parse(replaced, DateTimeFormatter.ofPattern("HH:mm"));
                boolean removed = ConfigManager.removeRestartTime(replaced);
                if (removed) {
                    src.method_9226(() -> class_2561.method_43470((String)("\u00a7aZeit entfernt: " + String.valueOf(t))), false);
                } else {
                    src.method_9226(() -> class_2561.method_43470((String)("\u00a7eZeit nicht gefunden: " + String.valueOf(t))), false);
                }
            }
            catch (DateTimeParseException e) {
                src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cUng\u00fcltiges Format. Bitte nutze HH-mm, z.\u202fB. 14-30"));
            }
            catch (IOException e) {
                src.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFehler beim Schreiben in die Config: " + e.getMessage())));
            }
            return 1;
        }))))));
    }

    private static int executeAnnounce(CommandContext<class_2168> ctx, boolean playSound) throws CommandSyntaxException {
        int minutes = IntegerArgumentType.getInteger(ctx, (String)"minutes");
        class_2168 source = (class_2168)ctx.getSource();
        String message = "\u00a7c[ACHTUNG!] Neustart in " + minutes + " Minute(n)!";
        source.method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)message), false);
        if (playSound) {
            for (class_3222 player : source.method_9211().method_3760().method_14571()) {
                player.method_17356(class_3417.field_17265, class_3419.field_15250, 1.0f, 1.0f);
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)"Ank\u00fcndigung gesendet."), false);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$registerCommands$1(class_2561 discordBtn, class_2561 webBtn) {
        return class_2561.method_43473().method_10852(discordBtn).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(webBtn);
    }
}

