/*
 * Decompiled with CFR 0.152.
 */
package com.vision.restartannouncer;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.vision.restartannouncer.Restartannouncer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class ConfigManager {
    private static final Path CONFIG_DIR = Paths.get("config", new String[0]);
    private static final Path TIMES_PATH = CONFIG_DIR.resolve("restartannouncer.json");
    private static final Path NOTIFIED_PATH = CONFIG_DIR.resolve("restartannouncer-notified.txt");
    private static final List<LocalTime> restartTimes = new ArrayList<LocalTime>();
    private static final List<ConfigMessage> messages = new ArrayList<ConfigMessage>();
    private static final int[] OFFSETS = new int[]{5, 3, 1};
    private static boolean schedulerStarted = false;
    private static final Set<UUID> notifiedOps = new HashSet<UUID>();

    public static void loadConfig() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConfigManager.loadNotifiedOps();
        ConfigManager.loadRestartTimes();
        if (!schedulerStarted) {
            ConfigManager.startScheduler();
            schedulerStarted = true;
        }
    }

    private static void loadNotifiedOps() {
        notifiedOps.clear();
        if (!Files.exists(NOTIFIED_PATH, new LinkOption[0])) {
            return;
        }
        try {
            for (String line : Files.readAllLines(NOTIFIED_PATH)) {
                if ((line = line.trim()).isEmpty()) continue;
                try {
                    notifiedOps.add(UUID.fromString(line));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean markOpNotified(UUID uuid) throws IOException {
        if (notifiedOps.add(uuid)) {
            Files.writeString(NOTIFIED_PATH, (CharSequence)(uuid.toString() + System.lineSeparator()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            return true;
        }
        return false;
    }

    private static void loadRestartTimes() {
        restartTimes.clear();
        messages.clear();
        if (!Files.exists(TIMES_PATH, new LinkOption[0])) {
            ConfigManager.createDefaultTimesConfig();
        }
        try (BufferedReader reader = Files.newBufferedReader(TIMES_PATH);){
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray arr = obj.getAsJsonArray("restartTimes");
            if (arr != null) {
                for (JsonElement el : arr) {
                    String s = el.getAsString();
                    try {
                        LocalTime rt = LocalTime.parse(s, DateTimeFormatter.ofPattern("HH:mm"));
                        restartTimes.add(rt);
                        for (int offset : OFFSETS) {
                            messages.add(new ConfigMessage(rt.minusMinutes(offset), offset));
                        }
                    }
                    catch (DateTimeParseException ex) {
                        System.err.println("[RestartAnnouncer] Ung\u00fcltiges Zeitformat: " + s);
                    }
                }
            }
        }
        catch (JsonParseException | IOException e) {
            e.printStackTrace();
            ConfigManager.createDefaultTimesConfig();
            ConfigManager.loadRestartTimes();
        }
    }

    private static void createDefaultTimesConfig() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        arr.add("00:00");
        obj.add("restartTimes", (JsonElement)arr);
        try {
            Files.writeString(TIMES_PATH, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void startScheduler() {
        new Thread(() -> {
            while (true) {
                LocalTime now = LocalTime.now().withSecond(0).withNano(0);
                MinecraftServer server = Restartannouncer.SERVER;
                if (server != null) {
                    for (ConfigMessage cm : messages) {
                        if (!cm.time.equals(now)) continue;
                        String text = "\u00a7c[ACHTUNG!] Neustart in " + cm.offset + " Minute(n)!";
                        server.method_3760().method_43514((class_2561)class_2561.method_43470((String)text), false);
                        if (cm.offset != 5) continue;
                        for (class_3222 p : server.method_3760().method_14571()) {
                            p.method_17356(class_3417.field_17265, class_3419.field_15250, 1.0f, 1.0f);
                        }
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }, "RestartAnnouncer-Scheduler").start();
    }

    public static boolean addRestartTime(String timeStr) throws IOException {
        LocalTime rt = LocalTime.parse(timeStr, DateTimeFormatter.ofPattern("HH:mm"));
        if (!restartTimes.contains(rt)) {
            restartTimes.add(rt);
            ConfigManager.saveTimesConfig();
            ConfigManager.loadRestartTimes();
            return true;
        }
        return false;
    }

    public static boolean removeRestartTime(String timeStr) throws IOException {
        LocalTime rt = LocalTime.parse(timeStr, DateTimeFormatter.ofPattern("HH:mm"));
        if (restartTimes.remove(rt)) {
            ConfigManager.saveTimesConfig();
            ConfigManager.loadRestartTimes();
            return true;
        }
        return false;
    }

    private static void saveTimesConfig() throws IOException {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        restartTimes.stream().sorted().forEach(rt -> arr.add(rt.format(DateTimeFormatter.ofPattern("HH:mm"))));
        obj.add("restartTimes", (JsonElement)arr);
        Files.writeString(TIMES_PATH, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static List<String> getFormattedRestartTimes() {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("HH:mm");
        ArrayList<String> out = new ArrayList<String>();
        restartTimes.stream().sorted().forEach(rt -> out.add(rt.format(fmt)));
        return out;
    }

    private record ConfigMessage(LocalTime time, int offset) {
    }
}

