/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import pl.kuba6000.ae2webintegration.core.Config;
import pl.kuba6000.ae2webintegration.core.PasswordHelper;
import pl.kuba6000.ae2webintegration.core.WebData;
import pl.kuba6000.ae2webintegration.core.ae2request.async.GetTracking;
import pl.kuba6000.ae2webintegration.core.ae2request.async.GetTrackingHistory;
import pl.kuba6000.ae2webintegration.core.ae2request.async.GridSettings;
import pl.kuba6000.ae2webintegration.core.ae2request.async.IAsyncRequest;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.CancelCPU;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.GetCPU;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.GetCPUList;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.GetGridList;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.GetItems;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.Job;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.Order;
import pl.kuba6000.ae2webintegration.core.interfaces.IAE;
import pl.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import pl.kuba6000.ae2webintegration.core.utils.HTTPUtils;
import pl.kuba6000.ae2webintegration.core.utils.RateLimiter;
import pl.kuba6000.ae2webintegration.core.utils.VersionChecker;

public class AE2Controller {
    public static IAE AE2Interface;
    public static long timer;
    private static HttpServer server;
    public static GameProfile AEControllerProfile;
    static ThreadLocal<RequestContext> requestContext;
    public static HashMap<UUID, Pair<String, String>> awaitingRegistration;
    public static ConcurrentLinkedQueue<ISyncedRequest> requests;
    private static final RateLimiter rateLimiter;
    private static final ExecutorService serverThread;
    public static ConcurrentHashMap<Integer, IItemStack> hashcodeToAEItemStack;
    private static final HashMap<String, Pair<Long, Integer>> validTokens;

    public static void startHTTPServer() {
        try {
            server = HttpServer.create(new InetSocketAddress(Config.AE_PORT), 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        server.createContext("/grids", new SyncedRequestHandler(GetGridList.class));
        server.createContext("/list", new SyncedRequestHandler(GetCPUList.class));
        server.createContext("/get", new SyncedRequestHandler(GetCPU.class));
        server.createContext("/cancelcpu", new SyncedRequestHandler(CancelCPU.class));
        server.createContext("/items", new SyncedRequestHandler(GetItems.class));
        server.createContext("/order", new SyncedRequestHandler(Order.class));
        server.createContext("/job", new SyncedRequestHandler(Job.class));
        server.createContext("/trackinghistory", new ASyncRequestHandler(GetTrackingHistory.class));
        server.createContext("/gettracking", new ASyncRequestHandler(GetTracking.class));
        server.createContext("/gridsettings", new ASyncRequestHandler(GridSettings.class));
        server.createContext("/auth", new AuthHandler());
        server.createContext("/", new WebHandler());
        server.setExecutor(serverThread);
        server.start();
    }

    public static void stopHTTPServer() {
        server.stop(0);
    }

    private static String generateToken() {
        return AE2Controller.generateToken(200);
    }

    private static String generateToken(int limit) {
        return new SecureRandom().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(limit).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static boolean checkAuth(HttpExchange t) throws IOException {
        InetAddress remoteAddress = t.getRemoteAddress().getAddress();
        if (Config.ALLOW_NO_PASSWORD_ON_LOCALHOST && remoteAddress.isLoopbackAddress()) {
            requestContext.set(new RequestContext(t, -2));
            rateLimiter.ensureWhitelisted(remoteAddress);
            return true;
        }
        Object auth = t.getRequestHeaders().get("Authorization");
        if (auth != null && !auth.isEmpty()) {
            String token = (String)auth.get(0);
            Pair<Long, Integer> tokenData = validTokens.get(token = token.replace("Bearer ", ""));
            if (tokenData != null) {
                long validity = (Long)tokenData.getLeft();
                if (System.currentTimeMillis() < validity) {
                    requestContext.set(new RequestContext(t, (Integer)tokenData.getRight()));
                    rateLimiter.ensureWhitelisted(remoteAddress);
                    return true;
                }
                validTokens.remove(token);
                return false;
            }
            return false;
        }
        Object cookies = t.getRequestHeaders().get("Cookie");
        if (cookies != null && !cookies.isEmpty()) {
            String cookiesString = (String)cookies.get(0);
            for (String cookie : cookiesString.split("; ")) {
                if (!cookie.startsWith("authenticationToken=")) continue;
                String token = cookie.substring("authenticationToken=".length());
                Pair<Long, Integer> tokenData = validTokens.get(token);
                if (tokenData != null) {
                    long validity = (Long)tokenData.getLeft();
                    if (System.currentTimeMillis() < validity) {
                        Map<String, String> GET_PARAMS = HTTPUtils.parseQueryString(t.getRequestURI().getQuery());
                        if (GET_PARAMS.containsKey("logout")) {
                            validTokens.remove(token);
                            t.getResponseHeaders().add("Set-Cookie", "authenticationToken=" + token + "; Max-Age=-1; HttpOnly");
                            t.getResponseHeaders().add("Location", ".");
                            t.sendResponseHeaders(302, -1L);
                            return false;
                        }
                        requestContext.set(new RequestContext(t, (Integer)tokenData.getRight()));
                        rateLimiter.ensureWhitelisted(remoteAddress);
                        return true;
                    }
                    validTokens.remove(token);
                    t.getResponseHeaders().add("Set-Cookie", "authenticationToken=" + token + "; Max-Age=-1; HttpOnly");
                    return false;
                }
                t.getResponseHeaders().add("Set-Cookie", "authenticationToken=" + token + "; Max-Age=-1; HttpOnly");
                return false;
            }
        }
        if (t.getRequestMethod().equals("POST")) {
            String password;
            String postRaw = new Scanner(t.getRequestBody()).nextLine();
            Map<String, String> postData = HTTPUtils.parseQueryString(postRaw);
            if (postData.containsKey("register") && postData.containsKey("password")) {
                String username = postData.get("register");
                UUID uuid = null;
                for (EntityPlayerMP entityPlayerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
                    if (!entityPlayerMP.func_70005_c_().equalsIgnoreCase(username)) continue;
                    username = entityPlayerMP.func_70005_c_();
                    uuid = entityPlayerMP.func_110124_au();
                    break;
                }
                if (uuid == null) {
                    t.getResponseHeaders().add("Location", "?notonline");
                    t.sendResponseHeaders(302, -1L);
                    return false;
                }
                password = postData.get("password");
                try {
                    password = PasswordHelper.generateStrongPasswordHash(password);
                }
                catch (Exception e) {
                    t.getResponseHeaders().add("Location", "?invalidpassword");
                    t.sendResponseHeaders(302, -1L);
                    return false;
                }
                String confirmationToken = AE2Controller.generateToken(50);
                awaitingRegistration.put(uuid, (Pair<String, String>)Pair.of((Object)confirmationToken, (Object)password));
                t.getResponseHeaders().add("Location", "?confirmregistration&token=" + confirmationToken);
                t.sendResponseHeaders(302, -1L);
                return false;
            }
            if (postData.containsKey("password") && postData.containsKey("username")) {
                int playerID;
                String username = postData.get("username");
                if (username.equalsIgnoreCase("admin") || !Config.AE_PUBLIC_MODE) {
                    username = "Admin";
                    playerID = -1;
                    password = postData.get("password");
                    if (!password.equals(Config.AE_PASSWORD) && !Config.AE_PASSWORD.isEmpty()) {
                        t.getResponseHeaders().add("Location", "?invalidpassword");
                        t.sendResponseHeaders(302, -1L);
                        return false;
                    }
                } else {
                    playerID = WebData.getPlayerId(username);
                    if (playerID == -1) {
                        t.getResponseHeaders().add("Location", "?invaliduser");
                        t.sendResponseHeaders(302, -1L);
                        return false;
                    }
                    password = postData.get("password");
                    if (!WebData.verifyPassword(playerID, password)) {
                        t.getResponseHeaders().add("Location", "?invalidpassword");
                        t.sendResponseHeaders(302, -1L);
                        return false;
                    }
                }
                boolean rememberMe = postData.containsKey("remember");
                String token = AE2Controller.generateToken();
                long validFor = rememberMe ? 604800L : 3600L;
                validTokens.put(token, (Pair<Long, Integer>)Pair.of((Object)(System.currentTimeMillis() + validFor * 1000L), (Object)playerID));
                t.getResponseHeaders().add("Set-Cookie", "authenticationToken=" + token + "; Max-Age=" + validFor + "; HttpOnly");
                t.getResponseHeaders().add("Location", ".");
                t.sendResponseHeaders(302, -1L);
                rateLimiter.ensureWhitelisted(remoteAddress);
                return true;
            }
        }
        return false;
    }

    private static boolean preHTTPHandler(HttpExchange t) throws IOException {
        if (!rateLimiter.isAllowed(t.getRemoteAddress().getAddress())) {
            byte[] raw_response = "Too Many Requests".getBytes();
            t.getResponseHeaders().add("Content-Type", "text/plain");
            t.sendResponseHeaders(429, raw_response.length);
            OutputStream os = t.getResponseBody();
            os.write(raw_response);
            os.close();
            return true;
        }
        t.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        if (t.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
            t.getResponseHeaders().add("Access-Control-Allow-Methods", "GET, OPTIONS");
            t.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type,Authorization");
            t.sendResponseHeaders(204, -1L);
            return true;
        }
        if (!AE2Controller.checkAuth(t)) {
            t.sendResponseHeaders(401, -1L);
            return true;
        }
        return false;
    }

    private static boolean sendRequest(ISyncedRequest request) {
        int timeout;
        requests.offer(request);
        for (timeout = 0; !request.isDone.get() && timeout < 50; ++timeout) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                return requests.remove(request);
            }
        }
        if (timeout == 50) {
            return requests.remove(request);
        }
        return true;
    }

    public static void init() {
        try {
            AE2Controller.startHTTPServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            AEControllerProfile = new GameProfile(UUID.nameUUIDFromBytes("AE2-WEB-INTEGRATION-AE2CONTROLLER".getBytes("UTF-8")), "AE2CONTROLLER");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        requestContext = new ThreadLocal();
        awaitingRegistration = new HashMap();
        requests = new ConcurrentLinkedQueue();
        rateLimiter = new RateLimiter(Config.AE_MAX_REQUESTS_BEFORE_LOGGED_IN_PER_MINUTE, 60000, 3600000);
        serverThread = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                requestContext.remove();
            }
        };
        hashcodeToAEItemStack = new ConcurrentHashMap();
        validTokens = new HashMap();
    }

    static class SyncedRequestHandler
    implements HttpHandler {
        private final Constructor<? extends ISyncedRequest> factory;

        public SyncedRequestHandler(Class<? extends ISyncedRequest> syncedRequestClass) {
            try {
                this.factory = syncedRequestClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            ISyncedRequest syncedRequest;
            if (AE2Controller.preHTTPHandler(t)) {
                return;
            }
            try {
                syncedRequest = this.factory.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (syncedRequest.init(requestContext.get())) {
                AE2Controller.sendRequest(syncedRequest);
            }
            byte[] raw_response = syncedRequest.getJSON().getBytes();
            t.sendResponseHeaders(200, raw_response.length);
            OutputStream os = t.getResponseBody();
            os.write(raw_response);
            os.close();
        }
    }

    static class ASyncRequestHandler
    implements HttpHandler {
        private final Constructor<? extends IAsyncRequest> factory;

        public ASyncRequestHandler(Class<? extends IAsyncRequest> syncedRequestClass) {
            try {
                this.factory = syncedRequestClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            IAsyncRequest asyncRequest;
            if (AE2Controller.preHTTPHandler(t)) {
                return;
            }
            try {
                asyncRequest = this.factory.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            asyncRequest.handle(requestContext.get());
            byte[] raw_response = asyncRequest.getJSON().getBytes();
            t.sendResponseHeaders(200, raw_response.length);
            OutputStream os = t.getResponseBody();
            os.write(raw_response);
            os.close();
        }
    }

    static class AuthHandler
    implements HttpHandler {
        AuthHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            Object auth;
            Map<String, String> GET_PARAMS;
            if (!rateLimiter.isAllowed(t.getRemoteAddress().getAddress())) {
                byte[] raw_response = "Too Many Requests".getBytes();
                t.getResponseHeaders().add("Content-Type", "text/plain");
                t.sendResponseHeaders(429, raw_response.length);
                OutputStream os = t.getResponseBody();
                os.write(raw_response);
                os.close();
                return;
            }
            if (t.getRequestMethod().equals("POST")) {
                String postRaw = new Scanner(t.getRequestBody()).nextLine();
                Map<String, String> postData = HTTPUtils.parseQueryString(postRaw);
                if (postData.containsKey("register") && postData.containsKey("password")) {
                    String username = postData.get("register");
                    UUID uuid = null;
                    for (EntityPlayerMP entityPlayerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
                        if (!entityPlayerMP.func_70005_c_().equalsIgnoreCase(username)) continue;
                        username = entityPlayerMP.func_70005_c_();
                        uuid = entityPlayerMP.func_110124_au();
                        break;
                    }
                    if (uuid == null) {
                        byte[] raw_response = "notonline".getBytes();
                        t.sendResponseHeaders(400, raw_response.length);
                        OutputStream os = t.getResponseBody();
                        os.write(raw_response);
                        os.close();
                        return;
                    }
                    String password = postData.get("password");
                    try {
                        password = PasswordHelper.generateStrongPasswordHash(password);
                    }
                    catch (Exception e) {
                        byte[] raw_response = "invalidpassword".getBytes();
                        t.sendResponseHeaders(400, raw_response.length);
                        OutputStream os = t.getResponseBody();
                        os.write(raw_response);
                        os.close();
                        return;
                    }
                    String confirmationToken = AE2Controller.generateToken(50);
                    awaitingRegistration.put(uuid, (Pair<String, String>)Pair.of((Object)confirmationToken, (Object)password));
                    byte[] raw_response = confirmationToken.getBytes();
                    t.sendResponseHeaders(200, raw_response.length);
                    OutputStream os = t.getResponseBody();
                    os.write(raw_response);
                    os.close();
                    return;
                }
                if (postData.containsKey("password") && postData.containsKey("username")) {
                    String password;
                    int playerID;
                    String username = postData.get("username");
                    if (username.equalsIgnoreCase("admin") || !Config.AE_PUBLIC_MODE) {
                        username = "Admin";
                        playerID = -1;
                        password = postData.get("password");
                        if (!password.equals(Config.AE_PASSWORD) && !Config.AE_PASSWORD.isEmpty()) {
                            byte[] raw_response = "invalidpassword".getBytes();
                            t.sendResponseHeaders(400, raw_response.length);
                            OutputStream os = t.getResponseBody();
                            os.write(raw_response);
                            os.close();
                            return;
                        }
                    } else {
                        playerID = WebData.getPlayerId(username);
                        if (playerID == -1) {
                            byte[] raw_response = "invaliduser".getBytes();
                            t.sendResponseHeaders(400, raw_response.length);
                            OutputStream os = t.getResponseBody();
                            os.write(raw_response);
                            os.close();
                            return;
                        }
                        password = postData.get("password");
                        if (!WebData.verifyPassword(playerID, password)) {
                            byte[] raw_response = "invalidpassword".getBytes();
                            t.sendResponseHeaders(400, raw_response.length);
                            OutputStream os = t.getResponseBody();
                            os.write(raw_response);
                            os.close();
                            return;
                        }
                    }
                    boolean rememberMe = postData.containsKey("remember");
                    String token = AE2Controller.generateToken();
                    long validFor = rememberMe ? 604800L : 3600L;
                    validTokens.put(token, Pair.of((Object)(System.currentTimeMillis() + validFor * 1000L), (Object)playerID));
                    JsonObject json = new JsonObject();
                    json.addProperty("token", token);
                    json.addProperty("username", username);
                    json.addProperty("isAdmin", Boolean.valueOf(playerID == -1));
                    json.addProperty("isOutdated", Boolean.valueOf(VersionChecker.isOutdated()));
                    byte[] raw_response = json.toString().getBytes();
                    t.sendResponseHeaders(200, raw_response.length);
                    OutputStream os = t.getResponseBody();
                    os.write(raw_response);
                    os.close();
                    rateLimiter.ensureWhitelisted(t.getRemoteAddress().getAddress());
                    return;
                }
            }
            if ((GET_PARAMS = HTTPUtils.parseQueryString(t.getRequestURI().getQuery())).containsKey("revoke") && (auth = t.getRequestHeaders().get("Authorization")) != null && !auth.isEmpty()) {
                String token = (String)auth.get(0);
                token = token.replace("Bearer ", "");
                validTokens.remove(token);
                t.sendResponseHeaders(200, -1L);
                return;
            }
            t.sendResponseHeaders(400, -1L);
        }
    }

    static class WebHandler
    implements HttpHandler {
        WebHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String response;
            if (!rateLimiter.isAllowed(t.getRemoteAddress().getAddress())) {
                byte[] raw_response = "Too Many Requests".getBytes();
                t.getResponseHeaders().add("Content-Type", "text/plain");
                t.sendResponseHeaders(429, raw_response.length);
                OutputStream os = t.getResponseBody();
                os.write(raw_response);
                os.close();
                return;
            }
            String path = t.getRequestURI().getPath();
            if (path.equals("/favicon.ico")) {
                t.getResponseHeaders().set("Content-Type", "image/x-icon");
                try (InputStream is = AE2Controller.class.getResourceAsStream("/assets/favicon.ico");){
                    if (is == null) {
                        return;
                    }
                    byte[] raw_response = IOUtils.toByteArray((InputStream)is);
                    is.read(raw_response);
                    t.sendResponseHeaders(200, raw_response.length);
                    OutputStream os = t.getResponseBody();
                    os.write(raw_response);
                    os.close();
                }
                return;
            }
            if (!(path.equals("/") || path.isEmpty() || path.equals("/index.php") || path.equals("/index.html") || path.equals("/index.htm") || path.equals("/index.asp") || path.equals("/index.aspx") || path.equals("/index.jsp"))) {
                String response2 = "<h1>Invalid url! (ERROR 404)</h1>";
                byte[] raw_response = response2.getBytes();
                t.sendResponseHeaders(404, raw_response.length);
                OutputStream os = t.getResponseBody();
                os.write(raw_response);
                os.close();
                return;
            }
            String site = "/assets/webpage.html";
            if (!AE2Controller.checkAuth(t)) {
                site = "/assets/login.html";
            }
            try (InputStream is = AE2Controller.class.getResourceAsStream(site);){
                if (is == null) {
                    return;
                }
                try (InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader reader = new BufferedReader(isr);){
                    response = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                }
            }
            response = response.replace("_REPLACE_ME_IS_PUBLIC_MODE", Config.AE_PUBLIC_MODE ? "true" : "false");
            response = response.replace("_REPLACE_ME_VERSION_OUTDATED", VersionChecker.isOutdated() ? "true" : "false");
            RequestContext context = requestContext.get();
            if (context != null) {
                response = response.replace("_REPLACE_ME_USERNAME", context.username);
                response = response.replace("_REPLACE_ME_IS_ADMIN", context.isAdmin() ? "true" : "false");
            }
            byte[] raw_response = response.getBytes();
            t.sendResponseHeaders(200, raw_response.length);
            OutputStream os = t.getResponseBody();
            os.write(raw_response);
            os.close();
        }
    }

    public static class RequestContext {
        private final HttpExchange exchange;
        private final Map<String, String> getParams;
        private final int userID;
        private final String username;

        public RequestContext(HttpExchange exchange, int userID) {
            GameProfile profile;
            this.exchange = exchange;
            this.getParams = HTTPUtils.parseQueryString(exchange.getRequestURI().getQuery());
            this.userID = userID;
            this.username = userID == -1 ? "admin" : (userID == -2 ? "localhost" : ((profile = AE2Interface.web$getPlayerData().web$getPlayerProfile(userID)) != null ? profile.getName() : "unknown"));
        }

        public HttpExchange getExchange() {
            return this.exchange;
        }

        public Map<String, String> getGetParams() {
            return this.getParams;
        }

        public int getUserID() {
            return this.userID;
        }

        public boolean isAdmin() {
            return this.userID == -1 || this.userID == -2;
        }
    }
}

