/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core.ae2request.sync;

import com.kuba6000.ae2webintegration.core.AE2Controller;
import com.kuba6000.ae2webintegration.core.ae2request.sync.GetCPUList;
import com.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import com.kuba6000.ae2webintegration.core.api.AEApi.AEActionable;
import com.kuba6000.ae2webintegration.core.interfaces.IAECraftingJob;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.IAEMeInventoryItem;
import com.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;
import com.kuba6000.ae2webintegration.core.interfaces.IItemList;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAEStorageGrid;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.util.text.ITextComponent;

public class Job
extends ISyncedRequest {
    private ERequestType type = null;
    private int jobID;
    private String cpuName;

    @Override
    boolean init(Map<String, String> getParams) {
        if (!getParams.containsKey("id")) {
            this.noParam("id");
            return false;
        }
        this.jobID = Integer.parseInt(getParams.get("id"));
        if (getParams.containsKey("cancel")) {
            this.type = ERequestType.CANCEL;
        } else if (getParams.containsKey("submit")) {
            this.type = ERequestType.SUBMIT;
            if (getParams.containsKey("cpu")) {
                this.cpuName = getParams.get("cpu");
            }
        } else {
            this.type = ERequestType.CHECK;
        }
        return true;
    }

    @Override
    void handle(IAEGrid grid) {
        block23: {
            if (grid == null) {
                this.deny("GRID_NOT_FOUND");
                return;
            }
            Future<IAECraftingJob> job = this.gridData.jobs.get(this.jobID);
            if (job == null) {
                this.deny("INVALID_ID");
                return;
            }
            if (this.type == ERequestType.CHECK) {
                JSON_JobData jobData = new JSON_JobData();
                jobData.isDone = job.isDone();
                if (jobData.isDone) {
                    try {
                        IAECraftingJob craftingJob = job.get();
                        IAEStorageGrid storageGrid = grid.web$getStorageGrid();
                        IAEMeInventoryItem items = storageGrid.web$getItemInventory();
                        jobData.isSimulating = craftingJob.web$isSimulation();
                        jobData.bytesTotal = craftingJob.web$getByteTotal();
                        IItemList plan = AE2Controller.AE2Interface.web$createItemList();
                        craftingJob.web$populatePlan(plan);
                        jobData.plan = new ArrayList();
                        for (IItemStack stack : plan) {
                            JSON_JobData.JobItem jobItem = new JSON_JobData.JobItem();
                            jobItem.itemid = stack.web$getItemID();
                            jobItem.itemname = stack.web$getDisplayName();
                            jobItem.requested = stack.web$getCountRequestable();
                            jobItem.steps = stack.web$getCountRequestableCrafts();
                            if (jobData.isSimulating) {
                                IItemStack toExtract = stack.web$copy();
                                toExtract.web$reset();
                                toExtract.web$setStackSize(stack.web$getStackSize());
                                IItemStack missing = toExtract.web$copy();
                                toExtract = items.web$extractItems(toExtract, AEActionable.SIMULATE, grid);
                                if (toExtract == null) {
                                    toExtract = missing.web$copy();
                                    toExtract.web$setStackSize(0L);
                                }
                                jobItem.stored = toExtract.web$getStackSize();
                                jobItem.missing = missing.web$getStackSize() - toExtract.web$getStackSize();
                            } else {
                                jobItem.stored = stack.web$getStackSize();
                                jobItem.missing = 0L;
                            }
                            if (jobItem.missing == 0L && jobItem.requested == 0L && jobItem.stored > 0L) {
                                IItemStack realStack = items.web$getAvailableItem(stack, grid);
                                long available = 0L;
                                if (realStack != null) {
                                    available = realStack.web$getStackSize();
                                }
                                if (available > 0L) {
                                    jobItem.usedPercent = (double)jobItem.stored / (double)available;
                                }
                            }
                            jobData.plan.add(jobItem);
                        }
                        jobData.plan.sort((i1, i2) -> {
                            if (i1.missing > 0L && i2.missing > 0L) {
                                return Long.compare(i2.missing, i1.missing);
                            }
                            if (i1.missing > 0L && i2.missing == 0L) {
                                return -1;
                            }
                            if (i1.missing == 0L && i2.missing > 0L) {
                                return 1;
                            }
                            if (i1.requested > 0L && i2.requested > 0L) {
                                return Long.compare(i2.steps, i1.steps);
                            }
                            if (i1.requested > 0L && i2.requested == 0L) {
                                return -1;
                            }
                            if (i1.requested == 0L && i2.requested > 0L) {
                                return 1;
                            }
                            return Long.compare(i2.stored, i1.stored);
                        });
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                        this.deny("INTERNAL_ERROR");
                        return;
                    }
                }
                this.setData(jobData);
                this.done();
            } else if (this.type == ERequestType.CANCEL) {
                job.cancel(true);
                this.gridData.jobs.remove(this.jobID);
                this.done();
            } else if (this.type == ERequestType.SUBMIT) {
                IAECraftingGrid craftingGrid = grid.web$getCraftingGrid();
                if (job.isDone()) {
                    try {
                        IAECraftingJob craftingJob = job.get();
                        ICraftingCPUCluster target = null;
                        if (this.cpuName != null && (target = GetCPUList.getCPUList(craftingGrid).get(this.cpuName)) == null) {
                            this.deny("CPU_NOT_FOUND");
                            return;
                        }
                        ITextComponent error = craftingGrid.web$submitJob(craftingJob, target, true, grid);
                        if (error != null) {
                            this.deny("FAIL");
                            this.setData(error.getUnformattedText());
                            break block23;
                        }
                        this.done();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                        this.deny("INTERNAL_ERROR");
                    }
                } else {
                    this.deny("JOB_NOT_DONE");
                }
            }
        }
    }

    private static enum ERequestType {
        CHECK,
        CANCEL,
        SUBMIT;

    }

    private static class JSON_JobData {
        boolean isDone;
        public boolean isSimulating;
        public long bytesTotal;
        public ArrayList<JobItem> plan;

        private JSON_JobData() {
        }

        public static class JobItem {
            public String itemid;
            public String itemname;
            public long stored;
            public long requested;
            public long missing;
            public long steps;
            public double usedPercent;
        }
    }
}

