/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class GSONUtils {
    private static final ExclusionStrategy GSONStrategy = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(SkipGSON.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };
    private static final JsonSerializer<IItemStack> IItemStackSerializer = (src, typeOfSrc, context) -> {
        JsonObject json = new JsonObject();
        json.addProperty("itemid", src.web$getItemID());
        json.addProperty("itemname", src.web$getDisplayName());
        json.addProperty("hashcode", (Number)src.hashCode());
        json.addProperty("quantity", (Number)src.web$getStackSize());
        return json;
    };
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder().addSerializationExclusionStrategy(GSONStrategy).addDeserializationExclusionStrategy(GSONStrategy).registerTypeHierarchyAdapter(IItemStack.class, IItemStackSerializer).serializeNulls();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SkipGSON {
    }
}

