package com.kuba6000.ae2webintegration.ae2interface.mixins.AE2.implementations;

import net.minecraft.item.Item;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;

import appeng.api.storage.data.IAEItemStack;

@Mixin(value = IAEItemStack.class, remap = false)
public interface AEItemStackMixin extends IAEItemStack, IItemStack {

    @Shadow
    Item getItem();

    @Shadow
    int getItemDamage();

    @Override
    public default String web$getItemID() {
        return getItem().getRegistryName() + ":" + getItemDamage();
    }

    @Override
    public default String web$getDisplayName() {
        return asItemStackRepresentation().getDisplayName();
    }

    @Override
    public default long web$getStackSize() {
        return getStackSize();
    }

    @Override
    public default boolean web$isCraftable() {
        return isCraftable();
    }

    @Override
    public default long web$getCountRequestable() {
        return getCountRequestable();
    }

    @Override
    public default long web$getCountRequestableCrafts() {
        return 0L;
    }

    @Override
    public default void web$reset() {
        reset();
    }

    @Override
    public default boolean web$isSameType(IItemStack other) {
        return isSameType((IAEItemStack) other);
    }

    @Override
    public default IItemStack web$copy() {
        return (IItemStack) copy();
    }

    @Override
    public default void web$setStackSize(long size) {
        setStackSize(size);
    }
}
