/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core;

import com.kuba6000.ae2webintegration.core.AE2Controller;
import com.kuba6000.ae2webintegration.core.AE2WebIntegration;
import com.kuba6000.ae2webintegration.core.Config;
import com.kuba6000.ae2webintegration.core.FMLEventHandler;
import com.kuba6000.ae2webintegration.core.GridData;
import com.kuba6000.ae2webintegration.core.WebData;
import com.kuba6000.ae2webintegration.core.commands.BaseCommandHandler;
import com.kuba6000.ae2webintegration.core.discord.DiscordManager;
import com.kuba6000.ae2webintegration.core.utils.VersionChecker;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        Config.init(event.getModConfigurationDirectory());
        Config.synchronizeConfiguration();
        WebData.loadData();
        GridData.loadData();
        AE2WebIntegration.LOG.info("AE2WebIntegration loading at version 0.2.1-alpha-forge-1.12.2");
        if (VersionChecker.isOutdated()) {
            AE2WebIntegration.LOG.warn("You are not on latest version ! Consider updating to {} at https://github.com/kuba6000/AE2-Web-Integration/releases/latest", (Object)VersionChecker.getLatestTag());
        }
        MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler());
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BaseCommandHandler());
    }

    public void serverStarted(FMLServerStartedEvent event) {
        AE2Controller.init();
        DiscordManager.init();
        if (!Config.AE_PUBLIC_MODE && !Config.DISCORD_WEBHOOK.isEmpty()) {
            DiscordManager.postMessageNonBlocking(new DiscordManager.DiscordEmbed("AE2 Web Integration", "Discord integration started!"));
        } else if (Config.AE_PUBLIC_MODE && !Config.DISCORD_WEBHOOK.isEmpty()) {
            DiscordManager.postMessageNonBlocking(new DiscordManager.DiscordEmbed("AE2 Web Integration", "Warning!\nDiscord integration webhook is set in the config, but the public mode is enabled!\nDiscord integration will be disabled!", 15548997));
        }
    }

    public void serverStopping(FMLServerStoppingEvent event) {
        AE2Controller.stopHTTPServer();
    }
}

