/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kuba6000.ae2webintegration.core.AE2JobTracker;
import com.kuba6000.ae2webintegration.core.AE2WebIntegration;
import com.kuba6000.ae2webintegration.core.Config;
import com.kuba6000.ae2webintegration.core.api.AEApi.AEControllerState;
import com.kuba6000.ae2webintegration.core.interfaces.IAECraftingJob;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAEPathingGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAESecurityGrid;
import com.kuba6000.ae2webintegration.core.utils.GSONUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class GridData {
    @GSONUtils.SkipGSON
    private static final File dataFile = Config.getConfigFile("griddata.json");
    @GSONUtils.SkipGSON
    private static ConcurrentHashMap<Long, GridData> gridDataMap = new ConcurrentHashMap();
    public boolean isTracked = false;
    @GSONUtils.SkipGSON
    public AE2JobTracker trackingInfo = new AE2JobTracker();
    @GSONUtils.SkipGSON
    private int nextJobID = 1;
    @GSONUtils.SkipGSON
    public HashMap<Integer, Future<IAECraftingJob>> jobs = new HashMap();

    private int getNextJobID() {
        return this.nextJobID++;
    }

    public int addJob(Future<IAECraftingJob> job) {
        int jobID = this.getNextJobID();
        this.jobs.put(jobID, job);
        return jobID;
    }

    public static GridData get(long gridKey) {
        return gridDataMap.computeIfAbsent(gridKey, k -> new GridData());
    }

    public static GridData get(IAEGrid grid) {
        IAEPathingGrid pathing = grid.web$getPathingGrid();
        if (pathing == null || pathing.web$isNetworkBooting() || pathing.web$getControllerState() != AEControllerState.CONTROLLER_ONLINE) {
            return null;
        }
        IAESecurityGrid security = grid.web$getSecurityGrid();
        if (security == null || !security.web$isAvailable()) {
            return null;
        }
        long gridKey = security.web$getSecurityKey();
        if (gridKey == -1L) {
            return null;
        }
        return gridDataMap.computeIfAbsent(gridKey, k -> new GridData());
    }

    public static void saveChanges() {
        Gson gson = GSONUtils.GSON_BUILDER.create();
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)dataFile, (Charset)StandardCharsets.UTF_8);
            gson.toJson(gridDataMap, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void loadData() {
        Gson gson = GSONUtils.GSON_BUILDER.create();
        if (!dataFile.exists()) {
            AE2WebIntegration.LOG.info("Grid data file not found, creating a new one.");
            GridData.saveChanges();
            return;
        }
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)dataFile, (Charset)StandardCharsets.UTF_8);
            Type type = new TypeToken<ConcurrentHashMap<Long, GridData>>(){}.getType();
            gridDataMap = (ConcurrentHashMap)gson.fromJson((Reader)reader, type);
        }
        catch (Exception e) {
            AE2WebIntegration.LOG.error("Failed to load web data from file: {}", (Object)dataFile.getAbsolutePath(), (Object)e);
            gridDataMap.clear();
            GridData.saveChanges();
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

