/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.kuba6000.ae2webintegration.core.AE2Controller;
import com.kuba6000.ae2webintegration.core.AE2WebIntegration;
import com.kuba6000.ae2webintegration.core.Config;
import com.kuba6000.ae2webintegration.core.PasswordHelper;
import com.kuba6000.ae2webintegration.core.utils.GSONUtils;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class WebData {
    static WebData instance = new WebData();
    private static final File dataFile = Config.getConfigFile("webdata.json");
    private HashMap<UUID, Integer> UUIDToId = new HashMap();
    private HashMap<Integer, UUID> IdToUUID = new HashMap();
    private HashMap<UUID, String> passwords = new HashMap();

    public static int getPlayerId(String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        GameProfile profile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(name);
        if (profile == null) {
            return -1;
        }
        Integer id = WebData.instance.UUIDToId.get(profile.getId());
        if (id != null) {
            return id;
        }
        return -1;
    }

    public static boolean verifyPassword(int playerId, String password) {
        UUID id = WebData.instance.IdToUUID.get(playerId);
        if (id == null) {
            AE2WebIntegration.LOG.warn("Player ID {} not found in IdToUUID map.", (Object)playerId);
            return false;
        }
        if (WebData.instance.passwords.containsKey(id)) {
            try {
                return PasswordHelper.validatePassword(password, WebData.instance.passwords.get(id));
            }
            catch (Exception e) {
                AE2WebIntegration.LOG.error("Password verification failed for player ID: {}", (Object)playerId, (Object)e);
                return false;
            }
        }
        return false;
    }

    public static void setPassword(GameProfile playerId, String passwordHash) {
        if (passwordHash == null || passwordHash.isEmpty()) {
            WebData.instance.passwords.remove(playerId.getId());
        } else {
            try {
                WebData.instance.passwords.put(playerId.getId(), passwordHash);
                int pID = AE2Controller.AE2Interface.web$getPlayerData().web$getPlayerId(playerId);
                WebData.instance.UUIDToId.put(playerId.getId(), pID);
                WebData.instance.IdToUUID.put(pID, playerId.getId());
            }
            catch (Exception e) {
                AE2WebIntegration.LOG.error("Failed to set password for player ID: {}", (Object)playerId, (Object)e);
            }
        }
        WebData.saveChanges();
    }

    private static void saveChanges() {
        Gson gson = GSONUtils.GSON_BUILDER.create();
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)dataFile, (Charset)StandardCharsets.UTF_8);
            gson.toJson((Object)instance, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void loadData() {
        Gson gson = GSONUtils.GSON_BUILDER.create();
        if (!dataFile.exists()) {
            AE2WebIntegration.LOG.info("Web data file not found, creating a new one.");
            WebData.saveChanges();
            return;
        }
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)dataFile, (Charset)StandardCharsets.UTF_8);
            instance = (WebData)gson.fromJson((Reader)reader, WebData.class);
        }
        catch (Exception e) {
            AE2WebIntegration.LOG.error("Failed to load web data from file: {}", (Object)dataFile.getAbsolutePath(), (Object)e);
            WebData.instance.UUIDToId.clear();
            WebData.instance.IdToUUID.clear();
            WebData.instance.passwords.clear();
            WebData.saveChanges();
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

