/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    public static final Config INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public static ModConfig CONFIG;
    private static Path configDirectory;
    public final ForgeConfigSpec.ConfigValue<String> AE_PASSWORD;
    public final ForgeConfigSpec.ConfigValue<Integer> AE_PORT;
    public final ForgeConfigSpec.ConfigValue<Boolean> ALLOW_NO_PASSWORD_ON_LOCALHOST;
    public final ForgeConfigSpec.ConfigValue<Boolean> AE_PUBLIC_MODE;
    public final ForgeConfigSpec.ConfigValue<Integer> AE_MAX_REQUESTS_BEFORE_LOGGED_IN_PER_MINUTE;
    public final ForgeConfigSpec.ConfigValue<String> DISCORD_WEBHOOK;
    public final ForgeConfigSpec.ConfigValue<String> DISCORD_ROLE_ID;
    public final ForgeConfigSpec.ConfigValue<Boolean> TRACKING_TRACK_MACHINE_CRAFTING;

    private Config(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        this.AE_PORT = builder.comment("Port for the hosted website").defineInRange("port", 2324, 1, 65535);
        this.AE_PASSWORD = builder.comment("Password for the admin account").define("password", (Object)new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString());
        this.ALLOW_NO_PASSWORD_ON_LOCALHOST = builder.comment("Don't require to login using loopback address (127.0.0.1/localhost)").define("allow_no_password_on_localhost", true);
        this.AE_PUBLIC_MODE = builder.comment("Public server mode = enable registration system on the website, players will be able to register and login to monitor their own ae networks, if disabled, there is only one admin account with password set in the config file with access to all networks on the server").define("public_mode", true);
        this.AE_MAX_REQUESTS_BEFORE_LOGGED_IN_PER_MINUTE = builder.comment("How many requests can be made before user is logged in per minute").defineInRange("max_requests_before_logged_in_per_minute", 20, 1, 1000);
        builder.pop();
        builder.push("Discord");
        this.DISCORD_WEBHOOK = builder.comment("Discord webhook url (OPTIONAL, leave empty to ignore) (WORKS ONLY IF PUBLIC_MODE IS DISABLED)").define("webhook", (Object)"");
        this.DISCORD_ROLE_ID = builder.comment("Role to ping on message (OPTIONAL, leave empty to ignore)").define("role_id", (Object)"");
        builder.pop();
        builder.push("Tracking");
        this.TRACKING_TRACK_MACHINE_CRAFTING = builder.comment("Track automated crafting jobs (not ordered by player)").define("track_machine_crafting", false);
        builder.pop();
    }

    public static File getConfigFile(String fileName) {
        if (configDirectory == null && Files.notExists(configDirectory = FMLPaths.CONFIGDIR.get().resolve("ae2webintegration/"), new LinkOption[0])) {
            try {
                Files.createDirectories(configDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return configDirectory.resolve(fileName).toFile();
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new Config(BUILDER);
        SPEC = BUILDER.build();
    }
}

