/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core.ae2request.sync;

import java.util.Map;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.GetCPUList;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;

public class CancelCPU
extends ISyncedRequest {
    private String cpuName;

    @Override
    boolean init(Map<String, String> getParams) {
        if (!getParams.containsKey("cpu")) {
            this.noParam("cpu");
            return false;
        }
        this.cpuName = getParams.get("cpu");
        return true;
    }

    @Override
    void handle(IAEGrid grid) {
        if (grid == null) {
            this.deny("GRID_NOT_FOUND");
            return;
        }
        ICraftingCPUCluster cluster = GetCPUList.getCPUList(grid.web$getCraftingGrid()).get(this.cpuName);
        if (cluster == null) {
            this.deny("CPU_NOT_FOUND");
            return;
        }
        if (cluster.web$isBusy()) {
            cluster.web$cancel();
            this.done();
            return;
        }
        this.deny("CPU_NOT_BUSY");
    }
}

