/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core.commands;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.tuple.Pair;
import pl.kuba6000.ae2webintegration.core.AE2Controller;
import pl.kuba6000.ae2webintegration.core.Config;
import pl.kuba6000.ae2webintegration.core.WebData;

public class BaseCommandHandler {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ae2webintegration").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(p -> p.hasPermission(4))).executes(BaseCommandHandler::reload))).then(Commands.literal((String)"auth").then(RequiredArgumentBuilder.argument((String)"token", (ArgumentType)StringArgumentType.string()).executes(BaseCommandHandler::auth))));
    }

    public static int reload(CommandContext<CommandSourceStack> context) {
        ((CommentedFileConfig)Config.CONFIG.getConfigData()).load();
        Config.SPEC.afterReload();
        AE2Controller.stopHTTPServer();
        AE2Controller.startHTTPServer();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Successfully reloaded the config and restarted the web server!")), false);
        return 1;
    }

    public static int auth(CommandContext<CommandSourceStack> context) {
        String token = StringArgumentType.getString(context, (String)"token");
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayer();
        if (sender == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "This command can only be used by players!")));
            return -1;
        }
        UUID id = sender.getUUID();
        Pair<String, String> p = AE2Controller.awaitingRegistration.get(id);
        if (p == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "You have to initialize the registration on the web interface first!")));
            return -1;
        }
        if (!((String)p.getLeft()).equals(token)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Invalid token!")));
            return -1;
        }
        WebData.setPassword(sender.getGameProfile(), (String)p.getRight());
        AE2Controller.awaitingRegistration.remove(id);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Registered successfully!")), false);
        return 1;
    }
}

