/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import pl.kuba6000.ae2webintegration.Tags;

public class VersionChecker {
    private static final String VERSION_IDENTIFIER = "-forge-1.20.1";
    private static final String versionCheckURL = "https://api.github.com/repos/kuba6000/AE2-Web-Integration/tags";
    private static String latestTag = null;
    private static long lastChecked = 0L;

    private static void updateLatestVersion() {
        block12: {
            if (lastChecked != 0L) {
                if (!Tags.VERSION.equals(latestTag)) {
                    return;
                }
                long elapsed = System.currentTimeMillis() - lastChecked;
                if (latestTag == null ? elapsed < 300000L : elapsed < 18000000L) {
                    return;
                }
            }
            lastChecked = System.currentTimeMillis();
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(versionCheckURL).openConnection();
                if (conn.getResponseCode() != 200) break block12;
                try (BufferedReader buf = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    JsonElement element = new JsonParser().parse((Reader)buf);
                    for (JsonElement tag : element.getAsJsonArray()) {
                        String name = tag.getAsJsonObject().get("name").getAsString();
                        if (!name.contains(VERSION_IDENTIFIER)) continue;
                        latestTag = name;
                        return;
                    }
                    latestTag = Tags.VERSION;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isOutdated() {
        VersionChecker.updateLatestVersion();
        if (latestTag == null) {
            return false;
        }
        return !latestTag.equals(Tags.VERSION);
    }

    public static String getLatestTag() {
        return latestTag;
    }
}

