/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core.discord;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.kuba6000.ae2webintegration.core.Config;

public class DiscordManager
extends Thread {
    private static final Logger LOG = LogManager.getLogger((String)"ae2webintegration_core - DISCORD INTEGRATION");
    private static DiscordManager thread;
    private static ConcurrentLinkedQueue<DiscordEmbed> toPush;

    public static void init() {
        if (thread != null) {
            return;
        }
        thread = new DiscordManager();
        thread.start();
    }

    public static void postMessageNonBlocking(DiscordEmbed message) {
        toPush.offer(message);
    }

    private static void postMessage(DiscordEmbed message) {
        if (((String)Config.INSTANCE.DISCORD_WEBHOOK.get()).isEmpty()) {
            return;
        }
        String roleID = (String)Config.INSTANCE.DISCORD_ROLE_ID.get();
        JsonObject json = new JsonObject();
        json.addProperty("username", "AE2 Web Integration");
        json.addProperty("content", (String)(!roleID.isEmpty() ? "<@&" + roleID + ">" : ""));
        JsonArray embeds = new JsonArray();
        JsonObject embed = new JsonObject();
        embed.addProperty("title", message.title);
        embed.addProperty("description", message.description);
        embed.addProperty("color", (Number)message.color);
        embeds.add((JsonElement)embed);
        json.add("embeds", (JsonElement)embeds);
        json.add("attachments", (JsonElement)new JsonArray());
        URL url = null;
        try {
            url = new URL((String)Config.INSTANCE.DISCORD_WEBHOOK.get());
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.addRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("User-Agent", "AE2-Web-Integration");
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            OutputStream stream = connection.getOutputStream();
            stream.write(json.toString().getBytes());
            stream.flush();
            stream.close();
            int code = connection.getResponseCode();
            if (code != 200 && code != 204) {
                LOG.error("Error, response code: {}", (Object)code);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (true) {
            if (toPush.peek() != null) {
                DiscordEmbed message;
                while ((message = toPush.poll()) != null) {
                    DiscordManager.postMessage(message);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static {
        toPush = new ConcurrentLinkedQueue();
    }

    public static class DiscordEmbed {
        String title;
        String description;
        int color;

        public DiscordEmbed(String title, String description, int color) {
            this.title = title;
            this.description = description;
            this.color = color;
        }

        public DiscordEmbed(String title, String description) {
            this(title, description, 1752220);
        }
    }
}

