/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.ae2interface.mixins.AE2.implementations;

import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.me.Grid;
import appeng.me.helpers.PlayerSource;
import appeng.parts.reporting.AbstractTerminalPart;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import pl.kuba6000.ae2webintegration.core.AE2Controller;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAEPathingGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAESecurityGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAEStorageGrid;

@Mixin(value={Grid.class}, remap=false)
public abstract class AEGridMixin
implements IAEGrid,
IAESecurityGrid {
    @Unique
    private Class<?> web$lastUsedMachineClass = null;
    @Unique
    public Component web$lastFakePlayerChatMessage;
    @Unique
    private PlayerSource web$cachedPlayerSource = null;
    @Unique
    private final SetMultimap<Integer, IGridNode> web$ownerTracker = MultimapBuilder.hashKeys().hashSetValues().build();
    @Unique
    private int web$hashKey = -1;
    @Unique
    private static final Class<?> WIRELESS_ACCESS_POINT_MACHINE_CLASS = WirelessAccessPointBlockEntity.class;

    @Override
    public IAECraftingGrid web$getCraftingGrid() {
        return (IAECraftingGrid)((Grid)this).getCraftingService();
    }

    @Override
    public IAEPathingGrid web$getPathingGrid() {
        return (IAEPathingGrid)((Grid)this).getPathingService();
    }

    @Override
    public IAEStorageGrid web$getStorageGrid() {
        return (IAEStorageGrid)((Grid)this).getStorageService();
    }

    @Override
    public IAESecurityGrid web$getSecurityGrid() {
        return this;
    }

    @Override
    public boolean web$isEmpty() {
        return ((Grid)this).isEmpty();
    }

    @Override
    public Object web$getPlayerSource() {
        ServerLevel world;
        Object actionHost;
        Grid internalGrid = (Grid)this;
        Set terminals = null;
        if (this.web$lastUsedMachineClass != null) {
            terminals = internalGrid.getMachines(this.web$lastUsedMachineClass);
        }
        if (this.web$lastUsedMachineClass == null || terminals.isEmpty()) {
            this.web$lastUsedMachineClass = null;
            Iterable machines = internalGrid.getMachineClasses();
            for (Class machine : machines) {
                if (!AbstractTerminalPart.class.isAssignableFrom(machine) || (terminals = internalGrid.getMachines(machine)).isEmpty()) continue;
                this.web$lastUsedMachineClass = machine;
                break;
            }
        }
        if (this.web$lastUsedMachineClass == null || terminals.isEmpty()) {
            Object o = internalGrid.getPivot().getOwner();
            actionHost = o instanceof IActionHost ? (IActionHost)o : null;
            world = ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD);
        } else {
            actionHost = (IActionHost)terminals.iterator().next();
            world = actionHost.getActionableNode().getLevel();
        }
        if (this.web$cachedPlayerSource != null) {
            if (this.web$cachedPlayerSource.machine().get() != actionHost) {
                this.web$cachedPlayerSource = null;
            } else {
                return this.web$cachedPlayerSource;
            }
        }
        this.web$cachedPlayerSource = new PlayerSource((Player)new FakePlayer(world, AE2Controller.AEControllerProfile){

            public void sendSystemMessage(Component p_component, boolean bypassHiddenChat) {
                AEGridMixin.this.web$lastFakePlayerChatMessage = p_component;
            }
        }, actionHost);
        return this.web$cachedPlayerSource;
    }

    @Override
    public Component web$getLastFakePlayerChatMessage() {
        return this.web$lastFakePlayerChatMessage;
    }

    @Unique
    private void web$updateHashKey() {
        this.web$hashKey = this.web$ownerTracker.isEmpty() ? -1 : this.web$ownerTracker.values().stream().map(g -> {
            GlobalPos pos = ((WirelessAccessPointBlockEntity)g.getOwner()).getGlobalPos();
            return Objects.hash(pos.dimension().registry(), pos.dimension().location(), pos.pos());
        }).sorted().findFirst().orElse(-1);
    }

    @Redirect(method={"add"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/SetMultimap;put(Ljava/lang/Object;Ljava/lang/Object;)Z"))
    private boolean ae2webintegration$trackOwnerAddition(SetMultimap<Class<?>, IGridNode> instance, Object clazz, Object gridNode) {
        int owner;
        boolean result = instance.put((Object)((Class)clazz), (Object)((IGridNode)gridNode));
        if (clazz == WIRELESS_ACCESS_POINT_MACHINE_CLASS && (owner = ((IGridNode)gridNode).getOwningPlayerId()) != -1) {
            this.web$ownerTracker.put((Object)owner, (Object)((IGridNode)gridNode));
            GlobalPos pos = ((WirelessAccessPointBlockEntity)((IGridNode)gridNode).getOwner()).getGlobalPos();
            int hash = Objects.hash(pos.dimension().registry(), pos.dimension().location(), pos.pos());
            if (this.web$hashKey > hash || this.web$hashKey == -1) {
                this.web$hashKey = hash;
            }
        }
        return result;
    }

    @Redirect(method={"remove"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/SetMultimap;remove(Ljava/lang/Object;Ljava/lang/Object;)Z"))
    private boolean ae2webintegration$trackOwnerRemoval(SetMultimap<Class<?>, IGridNode> instance, Object clazz, Object gridNode) {
        int owner;
        boolean result = instance.remove((Object)((Class)clazz), (Object)((IGridNode)gridNode));
        if (clazz == WIRELESS_ACCESS_POINT_MACHINE_CLASS && (owner = ((IGridNode)gridNode).getOwningPlayerId()) != -1) {
            this.web$ownerTracker.remove((Object)owner, (Object)((IGridNode)gridNode));
            this.web$updateHashKey();
        }
        return result;
    }

    @Override
    public boolean web$isAvailable() {
        return !this.web$ownerTracker.isEmpty();
    }

    @Override
    public long web$getSecurityKey() {
        return this.web$hashKey;
    }

    @Override
    public int web$getOwner() {
        return this.web$ownerTracker.keySet().stream().sorted().findFirst().orElse(-1);
    }

    @Override
    public GameProfile web$getOwnerProfile() {
        UUID profileID = IPlayerRegistry.getMapping((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).getProfileId(this.web$getOwner());
        if (profileID == null) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().getProfileCache().get(profileID).orElse(null);
    }

    @Override
    public boolean web$hasPermissions(int playerId) {
        return this.web$ownerTracker.containsKey((Object)playerId);
    }
}

