/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.ae2interface.mixins.AE2.implementations.service;

import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.me.helpers.PlayerSource;
import appeng.me.service.CraftingService;
import appeng.me.service.helpers.NetworkCraftingProviders;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import pl.kuba6000.ae2webintegration.core.interfaces.IAECraftingJob;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEKey;
import pl.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;
import pl.kuba6000.ae2webintegration.core.interfaces.ICraftingMediumTracker;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;

@Mixin(value={CraftingService.class}, remap=false)
public abstract class AECraftingGridMixin
implements IAECraftingGrid {
    @Shadow
    @Final
    private NetworkCraftingProviders craftingProviders;

    @Shadow
    public abstract Set<AEKey> getCraftables(AEKeyFilter var1);

    @Override
    public ICraftingMediumTracker web$getCraftingProviders() {
        return (ICraftingMediumTracker)this.craftingProviders;
    }

    @Override
    public int web$getCPUCount() {
        return ((CraftingService)this).getCpus().size();
    }

    @Override
    public Set<ICraftingCPUCluster> web$getCPUs() {
        ImmutableSet aecpus = ((CraftingService)this).getCpus();
        ArrayList sortedCpus = new ArrayList(aecpus);
        sortedCpus.sort((c1, c2) -> {
            int a = Long.compare(c2.getCoProcessors(), c1.getCoProcessors());
            if (a != 0) {
                return a;
            }
            return Long.compare(c2.getAvailableStorage(), c1.getAvailableStorage());
        });
        LinkedHashSet<ICraftingCPUCluster> cpus = new LinkedHashSet<ICraftingCPUCluster>(aecpus.size());
        int i = 1;
        for (ICraftingCPU cpu : sortedCpus) {
            cpus.add((ICraftingCPUCluster)cpu);
            ((ICraftingCPUCluster)cpu).web$setInternalID(i++);
        }
        return cpus;
    }

    @Override
    public Future<IAECraftingJob> web$beginCraftingJob(IAEGrid grid, IAEKey stack, long amount) {
        PlayerSource actionSrc = (PlayerSource)grid.web$getPlayerSource();
        Future job = ((CraftingService)this).beginCraftingCalculation(((Player)actionSrc.player().get()).level(), () -> actionSrc, (AEKey)stack, amount, CalculationStrategy.REPORT_MISSING_ITEMS);
        return job;
    }

    @Override
    public String web$submitJob(IAECraftingJob job, ICraftingCPUCluster target, boolean prioritizePower, IAEGrid grid) {
        if (target == null) {
            throw new UnsupportedOperationException();
        }
        ICraftingSubmitResult result = ((CraftingService)this).submitJob((ICraftingPlan)job, null, (ICraftingCPU)target, prioritizePower, (IActionSource)grid.web$getPlayerSource());
        if (result.successful()) {
            return null;
        }
        Object errorMessage = "";
        switch (result.errorCode()) {
            case INCOMPLETE_PLAN: {
                errorMessage = (String)errorMessage + "Crafting plan is incomplete.";
                break;
            }
            case NO_CPU_FOUND: {
                errorMessage = (String)errorMessage + "No CPU found for the crafting job.";
                break;
            }
            case NO_SUITABLE_CPU_FOUND: {
                errorMessage = (String)errorMessage + "No suitable CPU found for the crafting job.";
                break;
            }
            case CPU_BUSY: {
                errorMessage = (String)errorMessage + "CPU is busy with another job.";
                break;
            }
            case CPU_OFFLINE: {
                errorMessage = (String)errorMessage + "CPU is offline.";
                break;
            }
            case CPU_TOO_SMALL: {
                errorMessage = (String)errorMessage + "CPU is too small for the crafting job.";
                break;
            }
            case MISSING_INGREDIENT: {
                Object detail = result.errorDetail();
                Object detailString = "";
                detailString = detail instanceof GenericStack ? (String)detailString + ((GenericStack)detail).what().getId().toString() : "UNKNOWN";
                errorMessage = (String)errorMessage + "Ingredient went missing: " + (String)detailString;
                break;
            }
            default: {
                errorMessage = (String)errorMessage + "Unknown error occurred during crafting job submission.";
            }
        }
        return errorMessage;
    }

    @Override
    public Set<IAEKey> web$getCraftables(Function<IAEKey, Boolean> filter) {
        return this.getCraftables(filter == null ? g -> true : key -> (Boolean)filter.apply((IAEKey)key));
    }
}

