/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.kuba6000.ae2webintegration.Tags;
import pl.kuba6000.ae2webintegration.core.AE2Controller;
import pl.kuba6000.ae2webintegration.core.Config;
import pl.kuba6000.ae2webintegration.core.GridData;
import pl.kuba6000.ae2webintegration.core.WebData;
import pl.kuba6000.ae2webintegration.core.commands.BaseCommandHandler;
import pl.kuba6000.ae2webintegration.core.discord.DiscordManager;
import pl.kuba6000.ae2webintegration.core.utils.VersionChecker;

@Mod(value="ae2webintegration_core")
@EventBusSubscriber(modid="ae2webintegration_core")
public class AE2WebIntegration {
    public static final String MODID = "ae2webintegration_core";
    public static final Logger LOG = LogManager.getLogger((String)"ae2webintegration_core");
    public static ModContainer myContainer;

    public AE2WebIntegration() {
        Tags.VERSION = ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString();
        myContainer = ModLoadingContext.get().getActiveContainer();
        Config.CONFIG = ConfigTracker.INSTANCE.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, myContainer, "ae2webintegration/ae2webintegration.toml");
        WebData.loadData();
        GridData.loadData();
        LOG.info("AE2WebIntegration loading at version {}", (Object)Tags.VERSION);
        if (VersionChecker.isOutdated()) {
            LOG.warn("You are not on latest version ! Consider updating to {} at https://github.com/kuba6000/AE2-Web-Integration/releases/latest", (Object)VersionChecker.getLatestTag());
        }
    }

    @SubscribeEvent
    public static void commandsRegister(RegisterCommandsEvent event) {
        BaseCommandHandler.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void serverStarted(ServerStartedEvent event) {
        AE2Controller.init();
        DiscordManager.init();
        if (!((Boolean)Config.INSTANCE.AE_PUBLIC_MODE.get()).booleanValue() && !((String)Config.INSTANCE.DISCORD_WEBHOOK.get()).isEmpty()) {
            DiscordManager.postMessageNonBlocking(new DiscordManager.DiscordEmbed("AE2 Web Integration", "Discord integration started!"));
        } else if (((Boolean)Config.INSTANCE.AE_PUBLIC_MODE.get()).booleanValue() && !((String)Config.INSTANCE.DISCORD_WEBHOOK.get()).isEmpty()) {
            DiscordManager.postMessageNonBlocking(new DiscordManager.DiscordEmbed("AE2 Web Integration", "Warning!\nDiscord integration webhook is set in the config, but the public mode is enabled!\nDiscord integration will be disabled!", 15548997));
        }
    }

    @SubscribeEvent
    public static void serverStopping(ServerStoppingEvent event) {
        AE2Controller.stopHTTPServer();
    }
}

