/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core.ae2request.sync;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import pl.kuba6000.ae2webintegration.core.GridData;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import pl.kuba6000.ae2webintegration.core.api.AEApi.AEControllerState;
import pl.kuba6000.ae2webintegration.core.interfaces.IAE;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAEPathingGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAESecurityGrid;

public class GetGridList
extends ISyncedRequest {
    @Override
    public void handle(IAE ae) {
        ArrayList<JSON_GridData> grids = new ArrayList<JSON_GridData>();
        for (IAEGrid grid : ae.web$getGrids()) {
            IAEPathingGrid pathing = grid.web$getPathingGrid();
            if (pathing == null || pathing.web$isNetworkBooting() || pathing.web$getControllerState() != AEControllerState.CONTROLLER_ONLINE) continue;
            IAESecurityGrid security = grid.web$getSecurityGrid();
            if (security == null || !security.web$isAvailable() || security.web$getSecurityKey() == -1L) {
                if (!this.context.isAdmin()) continue;
                grids.add(new JSON_GridData(-1L, grid.web$getCraftingGrid().web$getCPUCount(), "N/A", false, false));
                continue;
            }
            if (!this.context.isAdmin() && !security.web$hasPermissions(this.context.getUserID())) continue;
            GameProfile gameProfile = security.web$getOwnerProfile();
            GridData gridData = GridData.get(security.web$getSecurityKey());
            grids.add(new JSON_GridData(security.web$getSecurityKey(), grid.web$getCraftingGrid().web$getCPUCount(), gameProfile == null ? "N/A" : gameProfile.getName(), security.web$hasPermissions(this.context.getUserID()), gridData.isTracked));
        }
        grids.sort((d1, d2) -> {
            if (d1.isOwned && !d2.isOwned) {
                return -1;
            }
            if (!d1.isOwned && d2.isOwned) {
                return 1;
            }
            if (d1.isTrackingEnabled && !d2.isTrackingEnabled) {
                return -1;
            }
            if (!d1.isTrackingEnabled && d2.isTrackingEnabled) {
                return 1;
            }
            if (d1.key == -1L && d2.key != -1L) {
                return 1;
            }
            if (d1.key != -1L && d2.key == -1L) {
                return -1;
            }
            return Integer.compare(d2.cpuCount, d1.cpuCount);
        });
        this.setData(grids);
        this.done();
    }

    private static class JSON_GridData {
        public long key;
        public int cpuCount;
        public String owner;
        public boolean isOwned;
        public boolean isTrackingEnabled = false;

        JSON_GridData(long key, int cpuCount, String owner, boolean isOwned, boolean isTrackingEnabled) {
            this.key = key;
            this.cpuCount = cpuCount;
            this.owner = owner;
            this.isOwned = isOwned;
            this.isTrackingEnabled = isTrackingEnabled;
        }
    }
}

