/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core.utils;

import java.net.InetAddress;
import java.util.HashMap;

public class RateLimiter {
    private final int MAX_REQUESTS_PER_INTERVAL;
    private final int RESET_INTERVAL_MS;
    private final int RESET_WHITELIST_INTERVAL_MS;
    private long lastUpdate = 0L;
    private final HashMap<InetAddress, Integer> requestCounter = new HashMap();
    private final HashMap<InetAddress, Long> whitelist = new HashMap();

    public RateLimiter(int maxRequestsPerInterval, int resetIntervalMs, int resetWhitelistIntervalMs) {
        this.MAX_REQUESTS_PER_INTERVAL = maxRequestsPerInterval;
        this.RESET_INTERVAL_MS = resetIntervalMs;
        this.RESET_WHITELIST_INTERVAL_MS = resetWhitelistIntervalMs;
    }

    public boolean isAllowed(InetAddress userId) {
        this.updateRequests();
        if (this.whitelist.containsKey(userId)) {
            return true;
        }
        return this.requestCounter.merge(userId, 1, Integer::sum) < this.MAX_REQUESTS_PER_INTERVAL;
    }

    public void ensureWhitelisted(InetAddress userId) {
        this.whitelist.put(userId, System.currentTimeMillis());
    }

    private void updateRequests() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdate > (long)this.RESET_INTERVAL_MS) {
            this.requestCounter.clear();
            this.lastUpdate = currentTime;
        }
        this.whitelist.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > (long)this.RESET_WHITELIST_INTERVAL_MS);
    }
}

