/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.ae2interface.mixins.AE2.implementations;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.me.Grid;
import appeng.me.helpers.PlayerSource;
import appeng.parts.reporting.AbstractPartTerminal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import pl.kuba6000.ae2webintegration.core.AE2Controller;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAEPathingGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAESecurityGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAEStorageGrid;

@Mixin(value={Grid.class}, remap=false)
public abstract class AEGridMixin
implements IAEGrid {
    @Unique
    private Class<? extends IGridHost> web$lastUsedMachineClass = null;
    @Unique
    public ITextComponent web$lastFakePlayerChatMessage;
    @Unique
    private PlayerSource web$cachedPlayerSource = null;

    @Override
    public IAECraftingGrid web$getCraftingGrid() {
        return (IAECraftingGrid)((Grid)this).getCache(ICraftingGrid.class);
    }

    @Override
    public IAEPathingGrid web$getPathingGrid() {
        return (IAEPathingGrid)((Grid)this).getCache(IPathingGrid.class);
    }

    @Override
    public IAEStorageGrid web$getStorageGrid() {
        return (IAEStorageGrid)((Grid)this).getCache(IStorageGrid.class);
    }

    @Override
    public IAESecurityGrid web$getSecurityGrid() {
        return (IAESecurityGrid)((Grid)this).getCache(ISecurityGrid.class);
    }

    @Override
    public boolean web$isEmpty() {
        return ((Grid)this).isEmpty();
    }

    @Override
    public Object web$getPlayerSource() {
        WorldServer world;
        IActionHost actionHost;
        Grid internalGrid = (Grid)this;
        IMachineSet terminals = null;
        if (this.web$lastUsedMachineClass != null) {
            terminals = internalGrid.getMachines(this.web$lastUsedMachineClass);
        }
        if (this.web$lastUsedMachineClass == null || terminals.isEmpty()) {
            this.web$lastUsedMachineClass = null;
            Iterable machines = internalGrid.getMachineClasses();
            for (Class machine : machines) {
                if (!AbstractPartTerminal.class.isAssignableFrom(machine) || (terminals = internalGrid.getMachines(machine)).isEmpty()) continue;
                this.web$lastUsedMachineClass = machine;
                break;
            }
        }
        if (this.web$lastUsedMachineClass == null || terminals.isEmpty()) {
            actionHost = null;
            world = FMLCommonHandler.instance().getMinecraftServerInstance().getWorld(0);
        } else {
            IGridNode node = (IGridNode)terminals.iterator().next();
            actionHost = (IActionHost)node.getMachine();
            world = node.getWorld();
        }
        if (this.web$cachedPlayerSource != null) {
            if (this.web$cachedPlayerSource.machine().get() != actionHost) {
                this.web$cachedPlayerSource = null;
            } else {
                return this.web$cachedPlayerSource;
            }
        }
        this.web$cachedPlayerSource = new PlayerSource((EntityPlayer)new FakePlayer(world, AE2Controller.AEControllerProfile){

            public void sendMessage(ITextComponent message) {
                AEGridMixin.this.web$lastFakePlayerChatMessage = message;
            }

            public void sendStatusMessage(ITextComponent message, boolean actionBar) {
                AEGridMixin.this.web$lastFakePlayerChatMessage = message;
            }
        }, actionHost);
        return this.web$cachedPlayerSource;
    }

    @Override
    public ITextComponent web$getLastFakePlayerChatMessage() {
        return this.web$lastFakePlayerChatMessage;
    }
}

