/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.ae2interface.mixins.AE2.implementations;

import appeng.core.worlddata.IWorldPlayerMapping;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEPlayerData;

@Mixin(targets={"appeng.core.worlddata.PlayerData"}, remap=false)
public class AEPlayerDataMixin
implements IAEPlayerData {
    @Shadow
    @Final
    private IWorldPlayerMapping playerMapping;

    @Shadow
    public int getPlayerID(@Nonnull GameProfile profile) {
        throw new UnsupportedOperationException("Mixin failed to apply.");
    }

    @Override
    public GameProfile web$getPlayerProfile(int playerId) {
        Optional maybe = this.playerMapping.get(playerId);
        if (!maybe.isPresent()) {
            return null;
        }
        UUID uuid = (UUID)maybe.get();
        GameProfile p = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerProfileCache().getProfileByUUID(uuid);
        if (p == null) {
            p = new GameProfile(uuid, uuid.toString());
        }
        return p;
    }

    @Override
    public int web$getPlayerId(GameProfile id) {
        return this.getPlayerID(id);
    }
}

