/*
 * Decompiled with CFR 0.152.
 */
package pl.kuba6000.ae2webintegration.core.ae2request.sync;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.Future;
import pl.kuba6000.ae2webintegration.core.AE2Controller;
import pl.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import pl.kuba6000.ae2webintegration.core.interfaces.IAECraftingJob;
import pl.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;
import pl.kuba6000.ae2webintegration.core.interfaces.IItemList;
import pl.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import pl.kuba6000.ae2webintegration.core.interfaces.service.IAEStorageGrid;

public class Order
extends ISyncedRequest {
    private IItemStack item;

    @Override
    boolean init(Map<String, String> getParams) {
        if (!getParams.containsKey("item") || !getParams.containsKey("quantity")) {
            this.noParam("item", "quantity");
            return false;
        }
        int hash = Integer.parseInt(getParams.get("item"));
        int quantity = Integer.parseInt(getParams.get("quantity"));
        this.item = AE2Controller.hashcodeToAEItemStack.get(hash);
        if (this.item == null || !this.item.web$isCraftable()) {
            this.deny("ITEM_NOT_FOUND");
            return false;
        }
        this.item = this.item.web$copy();
        this.item.web$setStackSize(quantity);
        return true;
    }

    @Override
    void handle(IAEGrid grid) {
        if (grid == null) {
            this.deny("GRID_NOT_FOUND");
            return;
        }
        IAECraftingGrid craftingGrid = grid.web$getCraftingGrid();
        boolean allBusy = true;
        for (ICraftingCPUCluster cpu : craftingGrid.web$getCPUs()) {
            if (cpu.web$isBusy()) continue;
            allBusy = false;
            break;
        }
        if (!allBusy) {
            IAEStorageGrid storageGrid = grid.web$getStorageGrid();
            IItemList itemList = storageGrid.web$getItemStorageList();
            IItemStack realItem = itemList.web$findPrecise(this.item);
            if (realItem != null && realItem.web$isCraftable()) {
                Future<IAECraftingJob> job = craftingGrid.web$beginCraftingJob(grid, this.item);
                int jobID = this.gridData.addJob(job);
                JsonObject jobData = new JsonObject();
                jobData.addProperty("jobID", (Number)jobID);
                if (this.gridData.jobs.size() > 3) {
                    int toDeleteBelowAndEqual = jobID - 3;
                    this.gridData.jobs.entrySet().removeIf(integerFutureEntry -> (Integer)integerFutureEntry.getKey() <= toDeleteBelowAndEqual);
                }
                this.setData(jobData);
                this.done();
            } else {
                this.deny("ITEM_NOT_FOUND");
            }
        } else {
            this.deny("ALL_CPU_BUSY");
        }
    }
}

