/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.ae2interface.implementations;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.me.Grid;
import appeng.parts.reporting.AbstractPartTerminal;
import com.kuba6000.ae2webintegration.ae2interface.implementations.IAEObject;
import com.kuba6000.ae2webintegration.ae2interface.implementations.service.AECraftingGrid;
import com.kuba6000.ae2webintegration.ae2interface.implementations.service.AEPathingGrid;
import com.kuba6000.ae2webintegration.ae2interface.implementations.service.AEStorageGrid;
import com.kuba6000.ae2webintegration.core.AE2Controller;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAEPathingGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAEStorageGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class AEGrid
extends IAEObject<IGrid>
implements IAEGrid {
    private Class<? extends IGridHost> lastUsedMachineClass = null;
    public IChatComponent lastFakePlayerChatMessage;

    public AEGrid(IGrid grid) {
        super(grid);
    }

    @Override
    public IAECraftingGrid getCraftingGrid() {
        return new AECraftingGrid((ICraftingGrid)((IGrid)this.get()).getCache(ICraftingGrid.class));
    }

    @Override
    public IAEPathingGrid getPathingGrid() {
        return new AEPathingGrid((IPathingGrid)((IGrid)this.get()).getCache(IPathingGrid.class));
    }

    @Override
    public IAEStorageGrid getStorageGrid() {
        return new AEStorageGrid((IStorageGrid)((IGrid)this.get()).getCache(IStorageGrid.class));
    }

    @Override
    public boolean isEmpty() {
        return ((IGrid)this.get()).isEmpty();
    }

    @Override
    public boolean internalObjectEquals(IAEGrid obj) {
        return this.get() == ((AEGrid)obj).get();
    }

    public PlayerSource getPlayerSource() {
        Grid internalGrid = (Grid)this.get();
        IMachineSet terminals = null;
        if (this.lastUsedMachineClass != null) {
            terminals = internalGrid.getMachines(this.lastUsedMachineClass);
        }
        if (this.lastUsedMachineClass == null || terminals.isEmpty()) {
            this.lastUsedMachineClass = null;
            Iterable machines = internalGrid.getMachineClasses();
            for (Class machine : machines) {
                if (!AbstractPartTerminal.class.isAssignableFrom(machine) || (terminals = internalGrid.getMachines(machine)).isEmpty()) continue;
                this.lastUsedMachineClass = machine;
                break;
            }
        }
        if (this.lastUsedMachineClass == null || terminals.isEmpty()) {
            throw new RuntimeException("There is no terminal in the AE system");
        }
        IGridNode node = (IGridNode)terminals.iterator().next();
        IActionHost actionHost = (IActionHost)node.getMachine();
        World world = node.getWorld();
        return new PlayerSource((EntityPlayer)new FakePlayer((WorldServer)world, AE2Controller.AEControllerProfile){

            public void func_145747_a(IChatComponent message) {
                AEGrid.this.lastFakePlayerChatMessage = message;
            }
        }, actionHost);
    }
}

