/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.ae2interface.implementations.service;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import com.google.common.collect.ImmutableSet;
import com.kuba6000.ae2webintegration.ae2interface.implementations.AECraftingCPUCluster;
import com.kuba6000.ae2webintegration.ae2interface.implementations.AECraftingJob;
import com.kuba6000.ae2webintegration.ae2interface.implementations.AEGrid;
import com.kuba6000.ae2webintegration.ae2interface.implementations.IAEObject;
import com.kuba6000.ae2webintegration.ae2interface.implementations.ItemStack;
import com.kuba6000.ae2webintegration.core.interfaces.IAECraftingJob;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.util.IChatComponent;

public class AECraftingGrid
extends IAEObject<ICraftingGrid>
implements IAECraftingGrid {
    public AECraftingGrid(ICraftingGrid object) {
        super(object);
    }

    @Override
    public int getCPUCount() {
        return ((ICraftingGrid)this.get()).getCpus().size();
    }

    @Override
    public Set<ICraftingCPUCluster> getCPUs() {
        ImmutableSet aecpus = ((ICraftingGrid)this.get()).getCpus();
        LinkedHashSet<ICraftingCPUCluster> cpus = new LinkedHashSet<ICraftingCPUCluster>(aecpus.size());
        int i = 1;
        for (ICraftingCPU cpu : aecpus) {
            cpus.add(new AECraftingCPUCluster((CraftingCPUCluster)cpu, i++));
        }
        return cpus;
    }

    @Override
    public Future<IAECraftingJob> beginCraftingJob(IAEGrid grid, IItemStack craftWhat) {
        PlayerSource actionSrc = ((AEGrid)grid).getPlayerSource();
        final Future job = ((ICraftingGrid)this.get()).beginCraftingJob(actionSrc.player.field_70170_p, (IGrid)((AEGrid)grid).get(), (BaseActionSource)actionSrc, ((ItemStack)craftWhat).stack, null);
        return new Future<IAECraftingJob>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return job.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return job.isCancelled();
            }

            @Override
            public boolean isDone() {
                return job.isDone();
            }

            @Override
            public IAECraftingJob get() throws InterruptedException, ExecutionException {
                ICraftingJob got = (ICraftingJob)job.get();
                if (got == null) {
                    return null;
                }
                return new AECraftingJob(got);
            }

            @Override
            public IAECraftingJob get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                ICraftingJob got = (ICraftingJob)job.get(timeout, unit);
                if (got == null) {
                    return null;
                }
                return new AECraftingJob(got);
            }
        };
    }

    @Override
    public IChatComponent submitJob(IAECraftingJob job, ICraftingCPUCluster target, boolean prioritizePower, IAEGrid grid) {
        ICraftingLink link = ((ICraftingGrid)this.get()).submitJob((ICraftingJob)((AECraftingJob)job).get(), null, (ICraftingCPU)((AECraftingCPUCluster)target).get(), prioritizePower, (BaseActionSource)((AEGrid)grid).getPlayerSource());
        if (link != null) {
            return null;
        }
        return ((AEGrid)grid).lastFakePlayerChatMessage;
    }
}

