/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core;

import com.kuba6000.ae2webintegration.core.Config;
import com.kuba6000.ae2webintegration.core.ae2request.async.GetTracking;
import com.kuba6000.ae2webintegration.core.ae2request.async.GetTrackingHistory;
import com.kuba6000.ae2webintegration.core.ae2request.async.IAsyncRequest;
import com.kuba6000.ae2webintegration.core.ae2request.sync.CancelCPU;
import com.kuba6000.ae2webintegration.core.ae2request.sync.GetCPU;
import com.kuba6000.ae2webintegration.core.ae2request.sync.GetCPUList;
import com.kuba6000.ae2webintegration.core.ae2request.sync.GetItems;
import com.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import com.kuba6000.ae2webintegration.core.ae2request.sync.Job;
import com.kuba6000.ae2webintegration.core.ae2request.sync.Order;
import com.kuba6000.ae2webintegration.core.api.AEApi.AEControllerState;
import com.kuba6000.ae2webintegration.core.interfaces.IAE;
import com.kuba6000.ae2webintegration.core.interfaces.IAECraftingJob;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAEPathingGrid;
import com.kuba6000.ae2webintegration.core.utils.HTTPUtils;
import com.kuba6000.ae2webintegration.core.utils.VersionChecker;
import com.mojang.authlib.GameProfile;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class AE2Controller {
    public static IAE AE2Interface;
    public static IAEGrid activeGrid;
    public static long timer;
    private static HttpServer server;
    public static GameProfile AEControllerProfile;
    public static ConcurrentLinkedQueue<ISyncedRequest> requests;
    private static final ExecutorService serverThread;
    public static ConcurrentHashMap<Integer, IItemStack> hashcodeToAEItemStack;
    public static int nextJobID;
    public static HashMap<Integer, Future<IAECraftingJob>> jobs;

    public static void startHTTPServer() {
        try {
            server = HttpServer.create(new InetSocketAddress(Config.AE_PORT), 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        server.createContext("/list", new SyncedRequestHandler(GetCPUList.class));
        server.createContext("/get", new SyncedRequestHandler(GetCPU.class));
        server.createContext("/cancelcpu", new SyncedRequestHandler(CancelCPU.class));
        server.createContext("/items", new SyncedRequestHandler(GetItems.class));
        server.createContext("/order", new SyncedRequestHandler(Order.class));
        server.createContext("/job", new SyncedRequestHandler(Job.class));
        server.createContext("/trackinghistory", new ASyncRequestHandler(GetTrackingHistory.class));
        server.createContext("/gettracking", new ASyncRequestHandler(GetTracking.class));
        server.createContext("/", new WebHandler());
        server.setExecutor(serverThread);
        server.start();
    }

    public static void stopHTTPServer() {
        server.stop(0);
    }

    public static int getNextJobID() {
        return nextJobID++;
    }

    private static boolean checkAuth(HttpExchange t) {
        if (Config.ALLOW_NO_PASSWORD_ON_LOCALHOST && t.getRemoteAddress().getAddress().isLoopbackAddress()) {
            return true;
        }
        Object auth = t.getRequestHeaders().get("Authorization");
        if (auth == null || auth.isEmpty()) {
            return false;
        }
        String token = (String)auth.get(0);
        token = token.replace("Basic ", "");
        try {
            String[] user_pass = new String(Base64.getDecoder().decode(token), "UTF-8").split(":");
            if (user_pass.length < 2) {
                return false;
            }
            String user = user_pass[0];
            String password = user_pass[1];
            if (password.equals(Config.AE_PASSWORD)) {
                return true;
            }
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            return false;
        }
        return false;
    }

    private static boolean preHTTPHandler(HttpExchange t) throws IOException {
        t.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        if (t.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
            t.getResponseHeaders().add("Access-Control-Allow-Methods", "GET, OPTIONS");
            t.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type,Authorization");
            t.sendResponseHeaders(204, -1L);
            return true;
        }
        if (!AE2Controller.checkAuth(t)) {
            t.getResponseHeaders().add("WWW-Authenticate", "Basic realm=\"AE2 Panel, please login\"");
            t.sendResponseHeaders(401, -1L);
            return true;
        }
        return false;
    }

    private static boolean sendRequest(ISyncedRequest request) {
        int timeout;
        requests.offer(request);
        for (timeout = 0; !request.isDone.get() && timeout < 50; ++timeout) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                return requests.remove(request);
            }
        }
        if (timeout == 50) {
            return requests.remove(request);
        }
        return true;
    }

    public static boolean tryValidateOrVerify(IAEGrid testGrid, IAECraftingGrid craftingGrid) {
        if (AE2Controller.isValid()) {
            return activeGrid.internalObjectEquals(testGrid);
        }
        if (craftingGrid == null) {
            craftingGrid = testGrid.getCraftingGrid();
        }
        if (craftingGrid.getCPUCount() >= Config.AE_CPUS_THRESHOLD) {
            activeGrid = testGrid;
            return true;
        }
        return false;
    }

    public static boolean tryValidate() {
        for (IAEGrid grid : AE2Interface.getGrids()) {
            IAECraftingGrid craftingGrid;
            IAEPathingGrid pathingGrid = grid.getPathingGrid();
            if (pathingGrid == null || pathingGrid.isNetworkBooting() || pathingGrid.getControllerState() != AEControllerState.CONTROLLER_ONLINE || (craftingGrid = grid.getCraftingGrid()) == null || (long)craftingGrid.getCPUCount() < (long)Config.AE_CPUS_THRESHOLD) continue;
            activeGrid = grid;
            return true;
        }
        return false;
    }

    public static boolean isValid() {
        if (activeGrid == null) {
            return false;
        }
        if (!activeGrid.isValid()) {
            return false;
        }
        if (activeGrid.isEmpty()) {
            activeGrid = null;
            return false;
        }
        IAEPathingGrid pathingGrid = activeGrid.getPathingGrid();
        if (pathingGrid == null || pathingGrid.isNetworkBooting() || pathingGrid.getControllerState() != AEControllerState.CONTROLLER_ONLINE) {
            activeGrid = null;
            return false;
        }
        return true;
    }

    public static void init() {
        try {
            AE2Controller.startHTTPServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            AEControllerProfile = new GameProfile(UUID.nameUUIDFromBytes("AE2-WEB-INTEGRATION-AE2CONTROLLER".getBytes("UTF-8")), "AE2CONTROLLER");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        requests = new ConcurrentLinkedQueue();
        serverThread = Executors.newCachedThreadPool();
        hashcodeToAEItemStack = new ConcurrentHashMap();
        nextJobID = 1;
        jobs = new HashMap();
    }

    static class SyncedRequestHandler
    implements HttpHandler {
        private final Constructor<? extends ISyncedRequest> factory;

        public SyncedRequestHandler(Class<? extends ISyncedRequest> syncedRequestClass) {
            try {
                this.factory = syncedRequestClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            ISyncedRequest syncedRequest;
            if (AE2Controller.preHTTPHandler(t)) {
                return;
            }
            Map<String, String> GET_PARAMS = HTTPUtils.parseQueryString(t.getRequestURI().getQuery());
            try {
                syncedRequest = this.factory.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (syncedRequest.init(GET_PARAMS)) {
                AE2Controller.sendRequest(syncedRequest);
            }
            byte[] raw_response = syncedRequest.getJSON().getBytes();
            t.sendResponseHeaders(200, raw_response.length);
            OutputStream os = t.getResponseBody();
            os.write(raw_response);
            os.close();
        }
    }

    static class ASyncRequestHandler
    implements HttpHandler {
        private final Constructor<? extends IAsyncRequest> factory;

        public ASyncRequestHandler(Class<? extends IAsyncRequest> syncedRequestClass) {
            try {
                this.factory = syncedRequestClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            IAsyncRequest syncedRequest;
            if (AE2Controller.preHTTPHandler(t)) {
                return;
            }
            Map<String, String> GET_PARAMS = HTTPUtils.parseQueryString(t.getRequestURI().getQuery());
            try {
                syncedRequest = this.factory.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            syncedRequest.handle(GET_PARAMS);
            byte[] raw_response = syncedRequest.getJSON().getBytes();
            t.sendResponseHeaders(200, raw_response.length);
            OutputStream os = t.getResponseBody();
            os.write(raw_response);
            os.close();
        }
    }

    static class WebHandler
    implements HttpHandler {
        WebHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String response;
            if (!AE2Controller.checkAuth(t)) {
                t.getResponseHeaders().add("WWW-Authenticate", "Basic realm=\"AE2 Panel, please login\"");
                t.sendResponseHeaders(401, -1L);
                return;
            }
            String path = t.getRequestURI().getPath();
            if (!(path.equals("/") || path.isEmpty() || path.equals("/index.php") || path.equals("/index.html") || path.equals("/index.htm") || path.equals("/index.asp") || path.equals("/index.aspx") || path.equals("/index.jsp"))) {
                if (path.equals("/favicon.ico")) {
                    t.getResponseHeaders().set("Content-Type", "image/x-icon");
                    try (InputStream is = AE2Controller.class.getResourceAsStream("/assets/favicon.ico");){
                        if (is == null) {
                            return;
                        }
                        byte[] raw_response = IOUtils.toByteArray((InputStream)is);
                        is.read(raw_response);
                        t.sendResponseHeaders(200, raw_response.length);
                        OutputStream os = t.getResponseBody();
                        os.write(raw_response);
                        os.close();
                    }
                    return;
                }
                String response2 = "<h1>Invalid url! (ERROR 404)</h1>";
                byte[] raw_response = response2.getBytes();
                t.sendResponseHeaders(404, raw_response.length);
                OutputStream os = t.getResponseBody();
                os.write(raw_response);
                os.close();
                return;
            }
            try (InputStream is = AE2Controller.class.getResourceAsStream("/assets/webpage.html");){
                if (is == null) {
                    return;
                }
                try (InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader reader = new BufferedReader(isr);){
                    response = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                }
            }
            response = response.replace("_REPLACE_ME_VERSION_OUTDATED", VersionChecker.isOutdated() ? "true" : "false");
            byte[] raw_response = response.getBytes();
            t.sendResponseHeaders(200, raw_response.length);
            OutputStream os = t.getResponseBody();
            os.write(raw_response);
            os.close();
        }
    }
}

