/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core.ae2request.sync;

import com.kuba6000.ae2webintegration.core.AE2Controller;
import com.kuba6000.ae2webintegration.core.AE2JobTracker;
import com.kuba6000.ae2webintegration.core.ae2request.sync.GetCPUList;
import com.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import com.kuba6000.ae2webintegration.core.api.JSON_CompactedItem;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;
import com.kuba6000.ae2webintegration.core.interfaces.IItemList;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class GetCPU
extends ISyncedRequest {
    String cpuName = null;

    @Override
    public boolean init(Map<String, String> getParams) {
        if (!getParams.containsKey("cpu")) {
            this.noParam("cpu");
            return false;
        }
        this.cpuName = getParams.get("cpu");
        return true;
    }

    @Override
    public void handle(IAEGrid grid) {
        IAECraftingGrid craftingGrid = grid.getCraftingGrid();
        ICraftingCPUCluster cpu = GetCPUList.getCPUList(craftingGrid).get(this.cpuName);
        if (cpu == null) {
            this.deny("CPU_NOT_FOUND");
            return;
        }
        JSON_ClusterData clusterData = new JSON_ClusterData();
        clusterData.size = cpu.getAvailableStorage();
        clusterData.isBusy = cpu.isBusy();
        if (clusterData.isBusy) {
            JSON_CompactedItem compactedItem;
            clusterData.finalOutput = cpu.getFinalOutput();
            AE2JobTracker.JobTrackingInfo trackingInfo = AE2JobTracker.trackingInfoMap.get(cpu);
            clusterData.hasTrackingInfo = trackingInfo != null;
            HashMap<JSON_CompactedItem, JSON_CompactedItem> prep = new HashMap<JSON_CompactedItem, JSON_CompactedItem>();
            IItemList items = AE2Controller.AE2Interface.createItemList();
            cpu.getActiveItems(items);
            for (IItemStack itemStack : items) {
                compactedItem = JSON_CompactedItem.create(itemStack);
                prep.computeIfAbsent(compactedItem, (Function<JSON_CompactedItem, JSON_CompactedItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$0(com.kuba6000.ae2webintegration.core.api.JSON_CompactedItem com.kuba6000.ae2webintegration.core.api.JSON_CompactedItem ), (Lcom/kuba6000/ae2webintegration/core/api/JSON_CompactedItem;)Lcom/kuba6000/ae2webintegration/core/api/JSON_CompactedItem;)((JSON_CompactedItem)compactedItem)).active += itemStack.getStackSize();
            }
            items = AE2Controller.AE2Interface.createItemList();
            cpu.getPendingItems(items);
            for (IItemStack itemStack : items) {
                compactedItem = JSON_CompactedItem.create(itemStack);
                prep.computeIfAbsent(compactedItem, (Function<JSON_CompactedItem, JSON_CompactedItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$1(com.kuba6000.ae2webintegration.core.api.JSON_CompactedItem com.kuba6000.ae2webintegration.core.api.JSON_CompactedItem ), (Lcom/kuba6000/ae2webintegration/core/api/JSON_CompactedItem;)Lcom/kuba6000/ae2webintegration/core/api/JSON_CompactedItem;)((JSON_CompactedItem)compactedItem)).pending += itemStack.getStackSize();
            }
            items = AE2Controller.AE2Interface.createItemList();
            cpu.getStorageItems(items);
            for (IItemStack itemStack : items) {
                compactedItem = JSON_CompactedItem.create(itemStack);
                prep.computeIfAbsent(compactedItem, (Function<JSON_CompactedItem, JSON_CompactedItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$2(com.kuba6000.ae2webintegration.core.api.JSON_CompactedItem com.kuba6000.ae2webintegration.core.api.JSON_CompactedItem ), (Lcom/kuba6000/ae2webintegration/core/api/JSON_CompactedItem;)Lcom/kuba6000/ae2webintegration/core/api/JSON_CompactedItem;)((JSON_CompactedItem)compactedItem)).stored += itemStack.getStackSize();
            }
            if (clusterData.hasTrackingInfo) {
                clusterData.timeStarted = trackingInfo.timeStarted;
                clusterData.timeElapsed = System.currentTimeMillis() - clusterData.timeStarted;
                for (IItemStack stack : trackingInfo.timeSpentOn.keySet()) {
                    JSON_CompactedItem finalCompactedItem = compactedItem = JSON_CompactedItem.create(stack);
                    compactedItem = prep.computeIfAbsent(compactedItem, k -> finalCompactedItem);
                    compactedItem.timeSpentCrafting += trackingInfo.getTimeSpentOn(stack);
                    compactedItem.craftedTotal += trackingInfo.craftedTotal.getOrDefault(stack, 0L).longValue();
                    compactedItem.shareInCraftingTime += trackingInfo.getShareInCraftingTime(stack);
                    compactedItem.shareInCraftingTimeCombined = Math.min((double)compactedItem.timeSpentCrafting / (double)clusterData.timeElapsed, 1.0);
                    compactedItem.craftsPerSec = (double)compactedItem.craftedTotal / ((double)compactedItem.timeSpentCrafting / 1000.0);
                }
            }
            clusterData.items = new ArrayList(prep.values());
            clusterData.items.sort((i1, i2) -> {
                if (i1.active > 0L && i2.active > 0L) {
                    return Long.compare(i2.active, i1.active);
                }
                if (i1.active > 0L && i2.active == 0L) {
                    return -1;
                }
                if (i1.active == 0L && i2.active > 0L) {
                    return 1;
                }
                if (i1.pending > 0L && i2.pending > 0L) {
                    return Long.compare(i2.pending, i1.pending);
                }
                if (i1.pending > 0L && i2.pending == 0L) {
                    return -1;
                }
                if (i1.pending == 0L && i2.pending > 0L) {
                    return 1;
                }
                return Long.compare(i2.stored, i1.stored);
            });
        }
        this.setData(clusterData);
        this.done();
    }

    private static /* synthetic */ JSON_CompactedItem lambda$handle$2(JSON_CompactedItem compactedItem, JSON_CompactedItem k) {
        return compactedItem;
    }

    private static /* synthetic */ JSON_CompactedItem lambda$handle$1(JSON_CompactedItem compactedItem, JSON_CompactedItem k) {
        return compactedItem;
    }

    private static /* synthetic */ JSON_CompactedItem lambda$handle$0(JSON_CompactedItem compactedItem, JSON_CompactedItem k) {
        return compactedItem;
    }

    private static class JSON_ClusterData {
        public long size;
        public boolean isBusy;
        public IItemStack finalOutput;
        public ArrayList<JSON_CompactedItem> items;
        public boolean hasTrackingInfo = false;
        public long timeStarted = 0L;
        public long timeElapsed = 0L;

        private JSON_ClusterData() {
        }
    }
}

