/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core.ae2request.sync;

import com.kuba6000.ae2webintegration.core.AE2JobTracker;
import com.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import java.util.LinkedHashMap;
import java.util.Map;

public class GetCPUList
extends ISyncedRequest {
    public static Map<String, ICraftingCPUCluster> getCPUList(IAECraftingGrid craftingGrid) {
        LinkedHashMap<String, ICraftingCPUCluster> orderedMap = new LinkedHashMap<String, ICraftingCPUCluster>();
        for (ICraftingCPUCluster cpu : craftingGrid.getCPUs()) {
            String name = cpu.getName();
            orderedMap.put(name, cpu);
        }
        return orderedMap;
    }

    @Override
    public boolean init(Map<String, String> getParams) {
        return true;
    }

    @Override
    public void handle(IAEGrid grid) {
        Map<String, ICraftingCPUCluster> clusters = GetCPUList.getCPUList(grid.getCraftingGrid());
        LinkedHashMap<String, JSON_CpuInfo> cpuList = new LinkedHashMap<String, JSON_CpuInfo>(clusters.size());
        for (Map.Entry<String, ICraftingCPUCluster> entry : clusters.entrySet()) {
            JSON_CpuInfo cpuInfo = new JSON_CpuInfo();
            ICraftingCPUCluster cluster = entry.getValue();
            cpuInfo.availableStorage = cluster.getAvailableStorage();
            cpuInfo.usedStorage = cluster.getUsedStorage();
            cpuInfo.coProcessors = cluster.getCoProcessors();
            cpuInfo.isBusy = cluster.isBusy();
            if (cpuInfo.isBusy) {
                cpuInfo.finalOutput = cluster.getFinalOutput();
                AE2JobTracker.JobTrackingInfo trackingInfo = AE2JobTracker.trackingInfoMap.get(cluster);
                cpuInfo.hasTrackingInfo = trackingInfo != null;
                if (cpuInfo.hasTrackingInfo) {
                    cpuInfo.timeStarted = trackingInfo.timeStarted;
                }
            }
            cpuList.put(entry.getKey(), cpuInfo);
        }
        this.setData(cpuList);
        this.done();
    }

    private static class JSON_CpuInfo {
        public boolean isBusy;
        public IItemStack finalOutput;
        public long availableStorage;
        public long usedStorage;
        public long coProcessors;
        public boolean hasTrackingInfo = false;
        public long timeStarted = 0L;

        private JSON_CpuInfo() {
        }
    }
}

