/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core.ae2request.sync;

import com.google.gson.JsonObject;
import com.kuba6000.ae2webintegration.core.AE2Controller;
import com.kuba6000.ae2webintegration.core.ae2request.sync.ISyncedRequest;
import com.kuba6000.ae2webintegration.core.interfaces.IAECraftingJob;
import com.kuba6000.ae2webintegration.core.interfaces.IAEGrid;
import com.kuba6000.ae2webintegration.core.interfaces.ICraftingCPUCluster;
import com.kuba6000.ae2webintegration.core.interfaces.IItemList;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAECraftingGrid;
import com.kuba6000.ae2webintegration.core.interfaces.service.IAEStorageGrid;
import java.util.Map;
import java.util.concurrent.Future;

public class Order
extends ISyncedRequest {
    private IItemStack item;

    @Override
    public boolean init(Map<String, String> getParams) {
        if (!getParams.containsKey("item") || !getParams.containsKey("quantity")) {
            this.noParam("item", "quantity");
            return false;
        }
        int hash = Integer.parseInt(getParams.get("item"));
        int quantity = Integer.parseInt(getParams.get("quantity"));
        this.item = AE2Controller.hashcodeToAEItemStack.get(hash);
        if (this.item == null || !this.item.isCraftable()) {
            this.deny("ITEM_NOT_FOUND");
            return false;
        }
        this.item = this.item.copy();
        this.item.setStackSize(quantity);
        return true;
    }

    @Override
    public void handle(IAEGrid grid) {
        IAECraftingGrid craftingGrid = grid.getCraftingGrid();
        boolean allBusy = true;
        for (ICraftingCPUCluster cpu : craftingGrid.getCPUs()) {
            if (cpu.isBusy()) continue;
            allBusy = false;
            break;
        }
        if (!allBusy) {
            IAEStorageGrid storageGrid = grid.getStorageGrid();
            IItemList itemList = storageGrid.getItemStorageList();
            IItemStack realItem = itemList.findPrecise(this.item);
            if (realItem != null && realItem.isCraftable()) {
                Future<IAECraftingJob> job = craftingGrid.beginCraftingJob(grid, this.item);
                int jobID = AE2Controller.getNextJobID();
                AE2Controller.jobs.put(jobID, job);
                JsonObject jobData = new JsonObject();
                jobData.addProperty("jobID", (Number)jobID);
                if (AE2Controller.jobs.size() > 3) {
                    int toDeleteBelowAndEqual = jobID - 3;
                    AE2Controller.jobs.entrySet().removeIf(integerFutureEntry -> (Integer)integerFutureEntry.getKey() <= toDeleteBelowAndEqual);
                }
                this.setData(jobData);
                this.done();
            } else {
                this.deny("ITEM_NOT_FOUND");
            }
        } else {
            this.deny("ALL_CPU_BUSY");
        }
    }
}

