/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.ae2webintegration.core.api;

import com.kuba6000.ae2webintegration.core.AE2JobTracker;
import com.kuba6000.ae2webintegration.core.api.DimensionalCoords;
import com.kuba6000.ae2webintegration.core.interfaces.IItemStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class JSON_CompactedJobTrackingInfo {
    public IItemStack finalOutput;
    public long timeStarted;
    public long timeDone;
    public boolean wasCancelled;
    public ArrayList<CompactedTrackingGSONItem> items = new ArrayList();
    public ArrayList<AEInterfaceGSON> interfaceShare = new ArrayList();

    public JSON_CompactedJobTrackingInfo(AE2JobTracker.JobTrackingInfo info) {
        this.finalOutput = info.finalOutput;
        this.timeStarted = info.timeStarted;
        this.timeDone = info.timeDone;
        long elapsed = this.timeDone - this.timeStarted;
        this.wasCancelled = info.wasCancelled;
        for (Map.Entry<IItemStack, Long> entry : info.timeSpentOn.entrySet()) {
            IItemStack stack = entry.getKey();
            long spent = entry.getValue();
            CompactedTrackingGSONItem item = new CompactedTrackingGSONItem();
            item.itemid = stack.getItemID();
            item.itemname = stack.getDisplayName();
            item.timeSpentOn = spent;
            item.craftedTotal = info.craftedTotal.get(stack);
            item.shareInCraftingTime = info.getShareInCraftingTime(stack);
            item.shareInCraftingTimeCombined = Math.min((double)item.timeSpentOn / (double)elapsed, 1.0);
            item.craftsPerSec = (double)item.craftedTotal / ((double)item.timeSpentOn / 1000.0);
            for (Pair<Long, Long> longLongPair : info.itemShare.get(stack)) {
                item.timings.add(new timingClass((Long)longLongPair.getKey(), (Long)longLongPair.getValue()));
            }
            this.items.add(item);
        }
        this.items.sort((i1, i2) -> Double.compare(i2.shareInCraftingTime, i1.shareInCraftingTime));
        for (Map.Entry<Object, Serializable> entry : info.interfaceShare.entrySet()) {
            AEInterfaceGSON interfaceGSON = new AEInterfaceGSON();
            interfaceGSON.name = ((AE2JobTracker.AEInterface)entry.getKey()).name;
            interfaceGSON.location = ((AE2JobTracker.AEInterface)entry.getKey()).location;
            for (Pair longLongPair : (ArrayList)entry.getValue()) {
                interfaceGSON.timings.add(new timingClass((Long)longLongPair.getKey(), (Long)longLongPair.getValue()));
            }
            long interfaceElapsed = 0L;
            for (Pair pair : (ArrayList)entry.getValue()) {
                interfaceElapsed += (Long)pair.getValue() - (Long)pair.getKey();
            }
            interfaceGSON.timingsCombined = interfaceElapsed;
            this.interfaceShare.add(interfaceGSON);
        }
        this.interfaceShare.sort((i1, i2) -> Long.compare(i2.timingsCombined, i1.timingsCombined));
    }

    public static class CompactedTrackingGSONItem {
        public String itemid;
        public String itemname;
        public long timeSpentOn;
        public long craftedTotal;
        public double shareInCraftingTime = 0.0;
        public double shareInCraftingTimeCombined = 0.0;
        public double craftsPerSec = 0.0;
        public ArrayList<timingClass> timings = new ArrayList();
    }

    public static class timingClass {
        long started;
        long ended;

        public timingClass(long started, long ended) {
            this.started = started;
            this.ended = ended;
        }
    }

    public static class AEInterfaceGSON {
        String name;
        public ArrayList<timingClass> timings = new ArrayList();
        public long timingsCombined;
        public HashSet<DimensionalCoords> location = new HashSet();
    }
}

