/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PermissionsHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.ChatComponent;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.api.PasteAPI;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import me.RockinChaos.itemjoin.utils.menus.Menu;
import me.RockinChaos.itemjoin.utils.sql.DataObject;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChatExecutor
implements CommandExecutor {
    private final HashMap<String, Boolean> confirmationRequests = new HashMap();

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String label, @Nonnull String[] args) {
        Execute executor = this.matchExecutor(args);
        if (Execute.DEFAULT.accept(sender, args, 0)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aItemJoin v" + ItemJoin.getCore().getPlugin().getDescription().getVersion() + "&e by RockinChaos", "&bThis should be the version submitted to the developer \n&bwhen submitting a bug or feature request.", "https://github.com/RockinChaos/ItemJoin/issues", ChatComponent.ClickAction.OPEN_URL);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help&a for the help menu.", "&eClick to View the Help Menu.", "/itemjoin help", ChatComponent.ClickAction.RUN_COMMAND);
        } else if (Execute.HELP.accept(sender, args, 1)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aItemJoin v" + ItemJoin.getCore().getPlugin().getDescription().getVersion() + "&e by RockinChaos", "&bThis should be the version submitted to the developer \n&bwhen submitting a bug or feature request.", "https://github.com/RockinChaos/ItemJoin/issues", ChatComponent.ClickAction.OPEN_URL);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Help &7- &eThis help menu.", "&aExecuting this command shows this help menu!", "/itemjoin help", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Dump &7- &eGets a debug link for support.", "&aSends a paste link of their configuration files. \n&cThis should be sent to the plugin developer and NOT SHARED PUBLICLY.", "/itemjoin dump", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Reload &7- &eReloads the .yml files.", "&aFully reloads the plugin, fetching \n&aany changes made to the .yml files. \n\n&aBe sure to save changes made to your .yml files!", "/itemjoin reload", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Updates &7- &eChecks for plugin updates.", "&aChecks to see if there are any updates available for this plugin.", "/itemjoin updates", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Upgrade &7- &eUpdates to latest version.", "&aAttempts to Upgrade this plugin to the latest version. \n&aYou will need to restart the server for this process to complete.", "/itemjoin upgrade", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 2&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 2", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 1/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 2)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin List &7- &eView existing items and their worlds.", "&aView an entire list of the existing \n&acustom items and their respective worlds.", "/itemjoin list", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin World &7- &eCheck what world you are in, debugging.", "&aDisplays the world that your Player is currently in. \n&aUseful for debugging, such as comparing to your enabled-worlds.", "/itemjoin world", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Menu &7- &eOpens the GUI Creator for custom items.", "&aCreate custom items in-game without the need \n&ato manually edit the .yml files.", "/itemjoin menu", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Permissions &7- &eLists your permissions.", "&aLists the Permissions for your Player. \n\n&aGreen&b means you have permission whereas \n&cRed&b means you do not have permission.", "/itemjoin permissions", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Query <Item> &7- &eDisplays the custom item data.", "&aDisplays the important item info for the existing custom item-node.", "/itemjoin query ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Info &7- &eGets data-info of the held item.", "&aDisplays the important item info for the item you are currently holding. \n&aUseful for finding the data-value and id of the item to be used.", "/itemjoin info", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 3&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 3", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 2/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 3)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Get <Item> &7- &eGives that ItemJoin item.", "&aGives you the custom item in its designated slot. \n\n&aThis will not work if you already have the item.", "/itemjoin get ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Get <Item> <Qty> &7- &eGives amount of said item.", "&aGives you the custom item in its designated slot with the specified quantity. \n\n&aThis &cWILL&a work if you already have the item.", "/itemjoin get ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Get <Item> <User> &7- &eGives to said player.", "&aGives the custom item to the specified player name. \n\n&aThis will not work if they already have the item.", "/itemjoin get ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Get <Item> <User> <Qty> &7- &eGives qty to player.", "&aGives the custom item to the specified player name with the specified quantity. \n\n&aThis &cWILL&a work if they already have the item.", "/itemjoin get ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 4&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 4", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 3/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 4)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Remove <Item> &7- &eRemoves item from inventory.", "&aRemoves the custom item from your inventory. \n\n&aThis will not work if you do not have the item.", "/itemjoin remove ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Remove <Item> <Qty> &7- &eRemoves qty of item.", "&aRemoves the custom item from your inventory with the specified quantity. \n\n&aThis will not work if you do not have the item.", "/itemjoin remove ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Remove <Item> <Qty> &7- &eRemoves qty of item.", "&aRemoves the custom item from the specified player name. \n\n&aThis will not work if they do not have the item.", "/itemjoin remove ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Remove <Item> <User> <Qty> &7- &eRemoves qty.", "&aRemoves the custom item from the specified player name with the specified quantity. \n\n&aThis will not work if they do not have the item.", "/itemjoin remove ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 5&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 5", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 4/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 5)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin GetOnline <Item> &7- &eGives to all online.", "&aGives the custom item to all online players.", "/itemjoin getonline ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin GetOnline <Item> <Qty> &7- &eGives qty to all online.", "&aGives the custom item with the specified quantity to all online players.", "/itemjoin getonline ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin RemoveOnline <Item> &7- &eRemoves from all online.", "&aRemoves the custom item from all online players.", "/itemjoin removeonline ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin RemoveOnline <Item> <Qty> &7- &eRemoves qty.", "&aRemoves the custom item with the specified quantity from all online players.", "/itemjoin removeonline ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 6&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 6", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 5/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 6)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin GetAll &7- &eGives all ItemJoin items.", "&aGives you all the custom items.", "/itemjoin getall", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin GetAll <User> &7- &eGives all items to said player.", "&aGives all custom items to the specified player name.", "/itemjoin getall ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin RemoveAll &7- &eRemoves all ItemJoin items.", "&aRemoves all custom items from your inventory.", "/itemjoin removeall", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin RemoveAll <User> &7- &eRemoves from player.", "&aRemoves all custom items from the specified player name.", "/itemjoin removeall ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 7&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 7", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 6/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 7)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Enable &7- &eEnables ItemJoin for all players.", "&aEnables ItemJoin for all players. \nPlayers will be able to get custom items.", "/itemjoin enable", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Enable <User> &7- &eEnables ItemJoin for player.", "&aEnables ItemJoin for the specified player name. \nThis player will be able to get custom items.", "/itemjoin enable ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Enable <User> <World> &7- &eFor player/world.", "&aEnables ItemJoin for the specified player name in the specified world. \nThis player will be able to get custom items in this world.", "/itemjoin enable ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 8&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 8", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 7/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 8)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Disable &7- &eDisables ItemJoin for all players.", "&aDisables ItemJoin for all players. \nPlayers will NOT be able to get custom items.", "/itemjoin disable", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Disable <User> &7- &eDisables ItemJoin for player.", "&aDisables ItemJoin for the specified player name. \nThis player will NOT be able to get custom items.", "/itemjoin disable ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Disable <User> <World> &7- &eFor player/world.", "&aDisables ItemJoin for the specified player name in the specified world. \nThis player will NOT be able to get custom items in this world.", "/itemjoin disable ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 9&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 9", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 8/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 9)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Purge &7- &eDeletes the database file.", "&c&l[DANGER] &eThe Following Destroys Data &nPermanently!&e&c&l [DANGER] \n\n&aPurges ALL Player Data from the Database file! \n\n&c&n&lTHIS CANNOT BE UNDONE.", "/itemjoin purge", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Purge map-id <Image> &7- &eMap-Images data.", "&c&l[DANGER] &eThe Following Destroys Data &nPermanently!&e&c&l [DANGER] \n\n&aPurges the map-id data for the custom-image from the Database file! \n\n&c&n&lTHIS CANNOT BE UNDONE.", "/itemjoin purge map-id ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Purge first-join <User> &7- &eFirst-Join data.", "&c&l[DANGER] &eThe Following Destroys Data &nPermanently!&e&c&l [DANGER] \n\n&aPurges the first-join data for the player name from the Database file! \n\n&c&n&lTHIS CANNOT BE UNDONE.", "/itemjoin purge first-join ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Purge first-world <User> &7- &eFirst-World data.", "&c&l[DANGER] &eThe Following Destroys Data &nPermanently!&e&c&l [DANGER] \n\n&aPurges the first-world data for the player name from the Database file! \n\n&c&n&lTHIS CANNOT BE UNDONE.", "/itemjoin purge first-world ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Purge ip-limits <User> &7- &eIp-Limits data.", "&c&l[DANGER] &eThe Following Destroys Data &nPermanently!&e&c&l [DANGER] \n\n&aPurges the ip-limits data for the player name from the Database file! \n\n&c&n&lTHIS CANNOT BE UNDONE.", "/itemjoin purge ip-limits ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Help 10&a for the next page.", "&eClick to View the Next Page.", "/itemjoin help 10", ChatComponent.ClickAction.RUN_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]--------------&a&l[&e Help Menu 9/10 &a&l]&a&l&m---------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.HELP.accept(sender, args, 10)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Purge enabled-players <User> &7- &eThe Data.", "&c&l[DANGER] &eThe Following Destroys Data &nPermanently!&e&c&l [DANGER] \n\n&aPurges the enabled-players data for the player name from the Database file! \n\n&c&n&lTHIS CANNOT BE UNDONE.", "/itemjoin purge enabled-players ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l/ItemJoin Purge first-commands <User> &7- &eThe Data.", "&c&l[DANGER] &eThe Following Destroys Data &nPermanently!&e&c&l [DANGER] \n\n&aPurges the first-commands data for the player name from the Database file! \n\n&c&n&lTHIS CANNOT BE UNDONE.", "/itemjoin purge first-commands ", ChatComponent.ClickAction.SUGGEST_COMMAND);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aFound a bug? Report it @");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&ahttps://github.com/RockinChaos/ItemJoin/issues", "&eClick to Submit a Bug or Feature Request.", "https://github.com/RockinChaos/ItemJoin/issues", ChatComponent.ClickAction.OPEN_URL);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]---------------&a&l[&e Help Menu 10/10 &a&l]&a&l&m--------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
        } else if (Execute.DUMP.accept(sender, args, 0)) {
            this.dump(sender);
        } else if (Execute.RELOAD.accept(sender, args, 0)) {
            PluginData.getInfo().hardReload(false);
            ItemJoin.getCore().getLang().sendLangMessage("commands.default.configReload", sender, new PlaceHolder[0]);
        } else if (Execute.MENU.accept(sender, args, 0)) {
            Menu.startMenu(sender);
            ItemJoin.getCore().getLang().sendLangMessage("commands.menu.openMenu", sender, new PlaceHolder[0]);
        } else if (Execute.INFO.accept(sender, args, 0)) {
            this.info(sender);
        } else if (Execute.QUERY.accept(sender, args, 0)) {
            this.query(sender, args);
        } else if (Execute.WORLD.accept(sender, args, 0)) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.WORLD, ((Player)sender).getWorld().getName());
            ItemJoin.getCore().getLang().sendLangMessage("commands.world.worldHeader", sender, placeHolders);
            ItemJoin.getCore().getLang().sendLangMessage("commands.world.worldRow", sender, placeHolders);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]--------------&a&l[&e Worlds In Menu 1/1 &a&l]&a&l&m-------------[");
        } else if (Execute.LIST.accept(sender, args, 1)) {
            this.list(sender, 1);
        } else if (Execute.LIST.accept(sender, args, 2)) {
            this.list(sender, Integer.parseInt(args[1]));
        } else if (Execute.PERMISSIONS.accept(sender, args, 1)) {
            this.permissions(sender, 1);
        } else if (Execute.PERMISSIONS.accept(sender, args, 2)) {
            this.permissions(sender, Integer.parseInt(args[1]));
        } else if (Execute.PURGE.accept(sender, args, 0)) {
            if (args.length == 1) {
                this.purge(sender, "Database", "All Players");
            } else if (args[1].equalsIgnoreCase("map-ids") || args[1].equalsIgnoreCase("ip-limits") || args[1].equalsIgnoreCase("first-join") || args[1].equalsIgnoreCase("first-world") || args[1].equalsIgnoreCase("enabled-players") || args[1].equalsIgnoreCase("first-commands")) {
                this.purge(sender, args[1], args.length >= 3 ? args[2] : "All Players");
            }
        } else if (Execute.ENABLE.accept(sender, args, 0)) {
            this.push(sender, args, true);
        } else if (Execute.DISABLE.accept(sender, args, 0)) {
            this.push(sender, args, false);
        } else if (Execute.GETONLINE.accept(sender, args, 0)) {
            if (args.length >= 2) {
                this.handleOnline(sender, args, false);
            }
        } else if (Execute.GET.accept(sender, args, 0)) {
            this.handleItems(sender, args, false);
        } else if (Execute.GETALL.accept(sender, args, 0)) {
            this.handleAllItems(sender, args, false);
        } else if (Execute.REMOVEONLINE.accept(sender, args, 0)) {
            if (args.length >= 2) {
                this.handleOnline(sender, args, true);
            }
        } else if (Execute.REMOVE.accept(sender, args, 0)) {
            this.handleItems(sender, args, true);
        } else if (Execute.REMOVEALL.accept(sender, args, 0)) {
            this.handleAllItems(sender, args, true);
        } else if (Execute.UPDATE.accept(sender, args, 0)) {
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER, sender.getName());
            ItemJoin.getCore().getLang().sendLangMessage("commands.updates.checkRequest", (CommandSender)Bukkit.getServer().getConsoleSender(), placeHolders);
            SchedulerUtils.runAsync(() -> ItemJoin.getCore().getUpdater().checkUpdates(sender, true));
        } else if (Execute.UPGRADE.accept(sender, args, 0)) {
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER, sender.getName());
            ItemJoin.getCore().getLang().sendLangMessage("commands.updates.updateRequest", (CommandSender)Bukkit.getServer().getConsoleSender(), placeHolders);
            SchedulerUtils.runAsync(() -> ItemJoin.getCore().getUpdater().forceUpdates(sender));
        } else if (Execute.DEBUG.accept(sender, args, 0)) {
            if (ServerUtils.devListening()) {
                ItemJoin.getCore().getLang().dispatchMessage(sender, ItemJoin.getCore().getData().getPluginPrefix() + " &aYou are &nnow listening&a for debug messages.");
            } else {
                ItemJoin.getCore().getLang().dispatchMessage(sender, ItemJoin.getCore().getData().getPluginPrefix() + "&cYou are &nno longer&c listening for debug messages.");
            }
        } else if (executor == null) {
            ItemJoin.getCore().getLang().sendLangMessage("commands.default.unknownCommand", sender, new PlaceHolder[0]);
        } else if (!executor.playerRequired(sender, args)) {
            ItemJoin.getCore().getLang().sendLangMessage("commands.default.noPlayer", sender, new PlaceHolder[0]);
            if (executor.equals((Object)Execute.GET)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.get.usageSyntax", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.GETALL)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.get.usageSyntax", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.REMOVE)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.remove.usageSyntax", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.REMOVEALL)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.remove.usageSyntax", sender, new PlaceHolder[0]);
            }
        } else if (!executor.hasSyntax(args, 0)) {
            if (executor.equals((Object)Execute.GET)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.get.badSyntax", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.GETONLINE)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.get.badOnlineSyntax", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.REMOVE)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.remove.badSyntax", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.REMOVEONLINE)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.remove.badOnlineSyntax", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.PURGE)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.default.unknownCommand", sender, new PlaceHolder[0]);
            } else if (executor.equals((Object)Execute.QUERY)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.query.badSyntax", sender, new PlaceHolder[0]);
            }
        } else if (!executor.hasPermission(sender, args)) {
            ItemJoin.getCore().getLang().sendLangMessage("commands.default.noPermission", sender, new PlaceHolder[0]);
        }
        return true;
    }

    private Execute matchExecutor(String[] args) {
        for (Execute command : Execute.values()) {
            if (!command.acceptArgs(args)) continue;
            return command;
        }
        return null;
    }

    private void dump(CommandSender sender) {
        try {
            HashMap<String, String> files = new HashMap<String, String>();
            files.put("latest.log", Files.asCharSource((File)new File("logs/latest.log"), (Charset)StandardCharsets.UTF_8).read());
            YamlConfiguration configData = YamlConfiguration.loadConfiguration((File)new File(ItemJoin.getCore().getPlugin().getDataFolder() + "/config.yml"));
            configData.set("Database.user", (Object)"**********");
            configData.set("Database.pass", (Object)"**********");
            files.put("config.yml", configData.saveToString());
            files.put("lang.yml", Files.asCharSource((File)new File(ItemJoin.getCore().getPlugin().getDataFolder() + "/" + ItemJoin.getCore().getLang().getFile()), (Charset)StandardCharsets.UTF_8).read());
            files.put("items.yml", Files.asCharSource((File)new File(ItemJoin.getCore().getPlugin().getDataFolder() + "/items.yml"), (Charset)StandardCharsets.UTF_8).read());
            PasteAPI pasteURI = new PasteAPI(sender, Collections.singletonList("ExploitFixer"), files);
            pasteURI.getPaste(pasteURL -> {
                if (pasteURL != null) {
                    ServerUtils.logInfo(sender.getName() + " has generated a debug paste at " + pasteURL);
                    if (!(sender instanceof ConsoleCommandSender)) {
                        ItemJoin.getCore().getLang().dispatchMessage(sender, "%prefix% &a" + pasteURL, "&eClick me to copy the url.", (String)pasteURL, ChatComponent.ClickAction.OPEN_URL);
                    }
                } else {
                    if (!(sender instanceof ConsoleCommandSender)) {
                        ItemJoin.getCore().getLang().dispatchMessage(sender, "%prefix% &cFailed to generate the DUMP URL, please try again later.");
                    }
                    ServerUtils.logSevere("{ChatExecutor} Failed to generate the DUMP URL, this is not necessarily a bug.");
                }
            });
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ChatExecutor} Failed to execute the DUMP command.");
            ServerUtils.sendSevereTrace(e);
        }
    }

    private void info(CommandSender sender) {
        ItemStack handItem = PlayerHandler.getHandItem((Player)sender);
        if (handItem.getType() != Material.AIR) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, " ");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]-----------------&a&l[&e Item Info &a&l]&a&l&m----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM, handItem.getType().toString());
            ItemJoin.getCore().getLang().sendLangMessage("commands.info.material", sender, placeHolders);
            if (!ServerUtils.hasSpecificUpdate("1_13")) {
                placeHolders.with(PlaceHolder.Holder.ITEM, String.valueOf(LegacyAPI.getDataValue(handItem)));
                ItemJoin.getCore().getLang().sendLangMessage("commands.info.data", sender, placeHolders);
            }
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]-----------------&a&l[&e Item Info &a&l]&a&l&m----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, " ");
        } else {
            ItemJoin.getCore().getLang().sendLangMessage("commands.item.noItemHeld", sender, new PlaceHolder[0]);
        }
    }

    private void query(@Nonnull CommandSender sender, @Nonnull String[] args) {
        ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(args[1]);
        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM, itemMap != null ? itemMap.getConfigName() : args[1]);
        if (itemMap != null) {
            placeHolders.with(PlaceHolder.Holder.ITEM_TYPE, itemMap.getDynamicMaterials() == null || itemMap.getDynamicMaterials().isEmpty() ? itemMap.getMaterial().name() : itemMap.getDynamicMaterials().toString().replace("[", "").replace("{", "").replace("]", "").replace("}", ""));
            placeHolders.with(PlaceHolder.Holder.ITEM_SLOT, itemMap.getMultipleSlots() == null || itemMap.getMultipleSlots().isEmpty() ? itemMap.getSlot() : itemMap.getMultipleSlots().toString().replace("[", "").replace("{", "").replace("]", "").replace("}", ""));
            if (sender instanceof Player) {
                if (itemMap.hasPermission((Player)sender, ((Player)sender).getWorld())) {
                    placeHolders.with(PlaceHolder.Holder.ITEM_PERMISSION, "&a[\u00e2\u0153\u201d] " + PermissionsHandler.customPermissions(itemMap.getPermissionNode(), ((Player)sender).getWorld().getName() + "." + itemMap.getConfigName()));
                } else {
                    placeHolders.with(PlaceHolder.Holder.ITEM_PERMISSION, "&c[\u00e2\u0153\u02dc] " + PermissionsHandler.customPermissions(itemMap.getPermissionNode(), ((Player)sender).getWorld().getName() + "." + itemMap.getConfigName()));
                }
            } else {
                placeHolders.with(PlaceHolder.Holder.ITEM_PERMISSION, "&a[\u00e2\u0153\u201d] itemjoin.console." + itemMap.getConfigName());
            }
            ItemJoin.getCore().getLang().dispatchMessage(sender, " ");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]-----------------&a&l[&e Query Data &a&l]&a&l&m----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().sendLangMessage("commands.query.node", sender, placeHolders);
            ItemJoin.getCore().getLang().sendLangMessage("commands.query.material", sender, placeHolders);
            ItemJoin.getCore().getLang().sendLangMessage("commands.query.slot", sender, placeHolders);
            ItemJoin.getCore().getLang().sendLangMessage("commands.query.permission", sender, placeHolders);
            ItemJoin.getCore().getLang().dispatchMessage(sender, "");
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]-----------------&a&l[&e Query Data &a&l]&a&l&m----------------[");
            ItemJoin.getCore().getLang().dispatchMessage(sender, " ");
        } else {
            ItemJoin.getCore().getLang().sendLangMessage("commands.item.noItem", sender, placeHolders);
        }
    }

    private void list(CommandSender sender, int page) {
        ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
        int maxPage = PluginData.getInfo().getListPages();
        int lineCount = 0;
        boolean worldSent = false;
        for (World world : Bukkit.getWorlds()) {
            if (lineCount + 1 == page * 15) continue;
            boolean itemFound = false;
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.WORLD, world.getName());
            if (lineCount <= page * 15 && (page == 1 || lineCount >= (page - 1) * 15)) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.list.worldHeader", sender, placeHolders);
                ++lineCount;
                worldSent = true;
            } else {
                ++lineCount;
            }
            ArrayList<String> inputListed = new ArrayList<String>();
            for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
                if (inputListed.contains(itemMap.getConfigName()) || !itemMap.inWorld(world)) continue;
                if (page == 1 && lineCount < page * 15 || page != 1 && lineCount <= page * 15 && lineCount >= (page - 1) * 15) {
                    if (!(worldSent || lineCount > page * 15 || page != 1 && lineCount < (page - 1) * 15)) {
                        ItemJoin.getCore().getLang().sendLangMessage("commands.list.worldHeader", sender, placeHolders);
                        ++lineCount;
                        worldSent = true;
                    }
                    placeHolders.with(PlaceHolder.Holder.ITEM, itemMap.getConfigName());
                    inputListed.add(itemMap.getConfigName());
                    ItemJoin.getCore().getLang().sendLangMessage("commands.list.itemRow", sender, placeHolders);
                }
                ++lineCount;
                itemFound = true;
            }
            if (itemFound) continue;
            ItemJoin.getCore().getLang().sendLangMessage("commands.list.noItems", sender, new PlaceHolder[0]);
            ++lineCount;
        }
        if (page != maxPage) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin List " + (page + 1) + "&a for the next page.", "&eClick to View the Next Page.", "/itemjoin list " + (page + 1), ChatComponent.ClickAction.RUN_COMMAND);
        }
        ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]----------------&a&l[&e List Menu " + page + "/" + maxPage + " &a&l]&a&l&m---------------[");
    }

    /*
     * Unable to fully structure code
     */
    private void permissions(CommandSender sender, int page) {
        block12: {
            block11: {
                ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------------&a&l[&e ItemJoin &a&l]&a&l&m-----------------[");
                maxPage = PluginData.getInfo().getPermissionPages();
                opPermissionRequired = ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items-OP");
                permissionRequired = ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items");
                if (page != 1) break block11;
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.*") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.*" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.*");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.all") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.All" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.All");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.use") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Use" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Use");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.reload") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Reload" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Reload");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.updates") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Updates" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Updates");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.upgrade") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Upgrade" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Upgrade");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.permissions") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Permissions" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Permissions");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.query") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Query" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Query");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.get") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Get" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Get");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.remove") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Remove" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Remove");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.enable") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Enable" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Enable");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.disable") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Disable" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Disable");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.get.others") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Get&r&a.Others" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Get&r&c.Others");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.remove.others") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Remove&r&a.Others" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Remove&r&c.Others");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.enable.others") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Enable&r&a.Others" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Enable&r&c.Others");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.disable.others") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Disable&r&a.Others" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Disable&r&c.Others");
                ItemJoin.getCore().getLang().dispatchMessage(sender, PermissionsHandler.hasPermission(sender, "itemjoin.bypass.inventorymodify") != false ? "&a[\u00e2\u0153\u201d] ItemJoin&r&a.Bypass&r&a.InventoryModify" : "&c[\u00e2\u0153\u02dc] ItemJoin&r&c.Bypass&r&c.InventoryModify");
                for (World world : Bukkit.getWorlds()) {
                    v0 = ItemJoin.getCore().getLang();
                    if (!PermissionsHandler.hasPermission(sender, "itemjoin." + world.getName() + ".*")) ** GOTO lbl-1000
                    if (opPermissionRequired == false || sender.isOp() == false ? opPermissionRequired == false : sender.isPermissionSet("itemjoin." + world.getName() + ".*") != false) ** GOTO lbl-1000
                    if (permissionRequired != false && sender.isOp() == false ? sender.isPermissionSet("itemjoin." + world.getName() + ".*") != false : permissionRequired == false) lbl-1000:
                    // 2 sources

                    {
                        v1 = "&a[\u00e2\u0153\u201d] ItemJoin&r&a." + world.getName() + "&r&a.*";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = "&c[\u00e2\u0153\u02dc] ItemJoin&r&c." + world.getName() + "&r&c.*";
                    }
                    v0.dispatchMessage(sender, v1);
                }
                break block12;
            }
            if (page != 0) {
                customPermissions = new ArrayList<String>();
                inputMessage = new ArrayList<String>();
                for (World world : Bukkit.getServer().getWorlds()) {
                    probable = null;
                    for (Object itemMap : ItemJoin.getCore().getChances().getItems().keySet()) {
                        if (!((ItemMap)itemMap).hasItem((Player)sender, true)) continue;
                        probable = (ItemMap)itemMap;
                    }
                    if (probable == null) {
                        probable = (ItemMap)ItemJoin.getCore().getChances().getRandom((Player)sender);
                    }
                    for (ItemMap item : ItemUtilities.getUtilities().getItems()) {
                        if (customPermissions.contains(PermissionsHandler.customPermissions(item.getPermissionNode(), world.getName() + "." + item.getConfigName())) || !item.inWorld(world) || (probable == null || !item.getConfigName().equals(probable.getConfigName())) && item.getProbability() != -1) continue;
                        customPermissions.add(PermissionsHandler.customPermissions(item.getPermissionNode(), world.getName() + "." + item.getConfigName()));
                        if (item.hasPermission((Player)sender, world)) {
                            inputMessage.add("&a[\u00e2\u0153\u201d] " + PermissionsHandler.customPermissions(item.getPermissionNode(), world.getName() + "." + item.getConfigName()).replace(".", "&r&a."));
                            continue;
                        }
                        inputMessage.add("&c[\u00e2\u0153\u02dc] " + PermissionsHandler.customPermissions(item.getPermissionNode(), world.getName() + "." + item.getConfigName()).replace(".", "&r&c."));
                    }
                }
                for (i = page == 2 ? 0 : (page - 2) * 15 + 1; i <= ((page - 1) * 15 <= inputMessage.size() ? (page - 1) * 15 : inputMessage.size() - 1); ++i) {
                    ItemJoin.getCore().getLang().dispatchMessage(sender, (String)inputMessage.get(i));
                }
            }
        }
        if (page != maxPage) {
            ItemJoin.getCore().getLang().dispatchMessage(sender, "&aType &a&l/ItemJoin Permissions " + (page + 1) + "&a for the next page.", "&eClick to View the Next Page.", "/itemjoin permissions " + (page + 1), ChatComponent.ClickAction.RUN_COMMAND);
        }
        ItemJoin.getCore().getLang().dispatchMessage(sender, "&a&l&m]------------&a&l[&e Permissions Menu " + page + "/" + maxPage + " &a&l]&a&l&m-----------[");
    }

    private void purge(CommandSender sender, String table, String args) {
        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PURGE_DATA, table).with(PlaceHolder.Holder.TARGET_PLAYER, args).with(PlaceHolder.Holder.COMMAND, table.equalsIgnoreCase("Database") ? "/ij purge" : "/ij purge " + table + (table.equalsIgnoreCase("map-ids") ? " <image>" : " <player>"));
        ArrayList handledPlayers = new ArrayList();
        boolean[] hasFailed = new boolean[]{false};
        if (this.confirmationRequests.get(table + sender.getName()) != null && this.confirmationRequests.get(table + sender.getName()).equals(true)) {
            if (!table.equalsIgnoreCase("Database")) {
                PlayerHandler.forSelectedEntities(sender, !args.equalsIgnoreCase("ALL") && !args.equalsIgnoreCase("All Players") ? args : null, argsPlayer -> {
                    DataObject dataObject;
                    if (!(table.equalsIgnoreCase("map-ids") || argsPlayer != null || args.equalsIgnoreCase("ALL") || args.equalsIgnoreCase("All Players"))) {
                        placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, args);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.default.noTarget", sender, placeHolders);
                        hasFailed[0] = true;
                        return;
                    }
                    String playerId = argsPlayer != null ? PlayerHandler.getPlayerID(argsPlayer) : null;
                    placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, argsPlayer != null ? argsPlayer.getName() : "NULL");
                    DataObject dataObject2 = table.replace("-", "_").equalsIgnoreCase("map_ids") ? new DataObject(DataObject.Table.MAP_IDS, null, "", args, "") : (table.replace("-", "_").equalsIgnoreCase("first_join") ? new DataObject(DataObject.Table.FIRST_JOIN, playerId, "", "", "") : (table.replace("-", "_").equalsIgnoreCase("first_world") ? new DataObject(DataObject.Table.FIRST_WORLD, playerId, "", "", "") : (table.replace("-", "_").equalsIgnoreCase("ip_limits") ? new DataObject(DataObject.Table.IP_LIMITS, playerId, "", "", "") : (table.replace("-", "_").equalsIgnoreCase("enabled_players") ? new DataObject(DataObject.Table.ENABLED_PLAYERS, playerId, "", "", "", "") : (dataObject = table.replace("-", "_").equalsIgnoreCase("first_commands") ? new DataObject(DataObject.Table.FIRST_COMMANDS, playerId, "", "", "") : null)))));
                    if (dataObject != null) {
                        ItemJoin.getCore().getSQL().removeData(dataObject, playerId == null);
                    }
                    if (argsPlayer != null && !handledPlayers.contains(argsPlayer.getName()) || !handledPlayers.contains("All Players")) {
                        handledPlayers.add(argsPlayer != null ? argsPlayer.getName() : "All Players");
                    }
                });
            } else {
                ItemJoin.getCore().getData().setStarted(false);
                ItemJoin.getCore().getSQL().purgeDatabase();
                SchedulerUtils.runAsyncLater(20L, () -> {
                    ItemJoin.getCore().getSQL().refresh();
                    SchedulerUtils.runAsyncLater(2L, () -> SchedulerUtils.runSingleAsync(() -> ItemJoin.getCore().getData().setStarted(true)));
                });
            }
            if (!hasFailed[0]) {
                if (!handledPlayers.isEmpty()) {
                    placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, ((Object)handledPlayers).toString().replace("]", "").replace("[", ""));
                }
                ItemJoin.getCore().getLang().sendLangMessage("commands.database.purgeSuccess", sender, placeHolders);
            }
            this.confirmationRequests.remove(table + sender.getName());
        } else {
            this.confirmationRequests.put(table + sender.getName(), true);
            ItemJoin.getCore().getLang().sendLangMessage("commands.database.purgeWarn", sender, placeHolders);
            ItemJoin.getCore().getLang().sendLangMessage("commands.database.purgeConfirm", sender, placeHolders);
            SchedulerUtils.runLater(100L, () -> {
                if (this.confirmationRequests.get(table + sender.getName()) != null && this.confirmationRequests.get(table + sender.getName()).equals(true)) {
                    ItemJoin.getCore().getLang().sendLangMessage("commands.database.purgeTimeOut", sender, new PlaceHolder[0]);
                    this.confirmationRequests.remove(table + sender.getName());
                }
            });
        }
    }

    private void push(CommandSender sender, String[] args, boolean enable) {
        String world = args.length == 3 ? args[2] : "Global";
        ArrayList handledPlayers = new ArrayList();
        ArrayList failedPlayers = new ArrayList();
        PlaceHolder placeHolder = new PlaceHolder().with(PlaceHolder.Holder.WORLD, world);
        PlayerHandler.forSelectedEntities(sender, args.length >= 2 ? args[1] : "ALL", argsPlayer -> {
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName()).with(PlaceHolder.Holder.PLAYER, sender.getName()).with(PlaceHolder.Holder.WORLD, world);
            if (args.length >= 2 && argsPlayer == null) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.default.noTarget", sender, placeHolders);
                return;
            }
            DataObject dataObject = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(argsPlayer), world, "ALL", String.valueOf(enable)));
            if (dataObject == null || Boolean.valueOf(dataObject.getEnabled()).equals(!enable)) {
                ItemJoin.getCore().getSQL().removeData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(argsPlayer), world, "ALL", String.valueOf(!enable)), new boolean[0]);
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(argsPlayer), world, "ALL", String.valueOf(enable)));
                if (args.length < 2) {
                    ItemJoin.getCore().getLang().sendLangMessage("commands." + (enable ? "enabled." : "disabled.") + "globalPlayers", sender, placeHolders);
                } else if (!handledPlayers.contains(argsPlayer.getName())) {
                    handledPlayers.add(argsPlayer.getName());
                }
                if (args.length >= 2 && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                    placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName());
                    ItemJoin.getCore().getLang().sendLangMessage("commands." + (enable ? "enabled." : "disabled.") + (args.length == 3 ? "forTargetWorld" : "forTarget"), (CommandSender)argsPlayer, placeHolders);
                }
            } else if (args.length < 2) {
                ItemJoin.getCore().getLang().sendLangMessage("commands." + (enable ? "enabled." : "disabled.") + "globalPlayersFailed", sender, placeHolders);
            } else if (!failedPlayers.contains(argsPlayer.getName())) {
                failedPlayers.add(argsPlayer.getName());
            }
        });
        if (!handledPlayers.isEmpty()) {
            String player = ((Object)handledPlayers).toString().replace("]", "").replace("[", "");
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, player).with(PlaceHolder.Holder.PLAYER, player).with(PlaceHolder.Holder.PLAYERS, player);
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (enable ? "enabled." : "disabled.") + (args.length == 3 ? "forPlayerWorld" : "forPlayer"), sender, placeHolder);
        } else if (!failedPlayers.isEmpty()) {
            String player = ((Object)failedPlayers).toString().replace("]", "").replace("[", "");
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, player).with(PlaceHolder.Holder.PLAYER, player).with(PlaceHolder.Holder.PLAYERS, player);
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (enable ? "enabled." : "disabled.") + (args.length == 3 ? "forPlayerWorldFailed" : "forPlayerFailed"), sender, placeHolder);
        }
    }

    private void handleItems(CommandSender sender, String[] args, boolean remove) {
        ArrayList handledPlayers = new ArrayList();
        ArrayList failedPlayers = new ArrayList();
        ArrayList failedPermission = new ArrayList();
        PlaceHolder placeHolder = new PlaceHolder().with(PlaceHolder.Holder.ITEM, args[1]);
        boolean[] hasFailed = new boolean[]{false};
        PlayerHandler.forSelectedEntities(sender, args.length >= 3 ? args[2] : null, player -> {
            int amount;
            Player argsPlayer = args.length >= 3 ? player : (Player)sender;
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TARGET_PLAYER, args.length >= 3 && argsPlayer != null ? argsPlayer.getName() : (args.length >= 3 ? args[2] : sender.getName())).with(PlaceHolder.Holder.ITEM, args[1]);
            int n = amount = (args.length >= 3 && argsPlayer == null || args.length > 3) && StringUtils.isInt(args[args.length - 1]) ? Integer.parseInt(args[args.length - 1]) : 0;
            if (args.length >= 3 && !StringUtils.isInt(args[2]) && argsPlayer == null) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.default.noTarget", sender, placeHolders);
                return;
            }
            if (argsPlayer == null && sender instanceof Player) {
                argsPlayer = (Player)sender;
            }
            boolean messageSent = false;
            ItemMap itemMapExist = ItemUtilities.getUtilities().getItemMap(args[1]);
            if (itemMapExist == null) {
                if (!hasFailed[0]) {
                    ItemJoin.getCore().getLang().sendLangMessage("commands.item.noItem", sender, placeHolders);
                    hasFailed[0] = true;
                }
                return;
            }
            ArrayList<String> multiSlots = new ArrayList<String>();
            HashMap<String, Integer> arbitraryMap = new HashMap<String, Integer>();
            for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
                if (!itemMap.getConfigName().equalsIgnoreCase(args[1]) || arbitraryMap.containsKey(itemMap.getConfigName()) && (Integer)arbitraryMap.get(itemMap.getConfigName()) == 0 || argsPlayer == null) continue;
                if (itemMap.getSlot().equalsIgnoreCase("ARBITRARY") && !arbitraryMap.containsKey(itemMap.getConfigName())) {
                    int arbitrary = ItemUtilities.getUtilities().getArbitrary(itemMap);
                    int count = 0;
                    for (ItemStack inPlayerInventory : argsPlayer.getInventory().getContents()) {
                        if (!itemMap.isSimilar(argsPlayer, inPlayerInventory)) continue;
                        ++count;
                    }
                    arbitraryMap.put(itemMap.getConfigName(), arbitrary - count);
                }
                String customName = StringUtils.translateLayout(itemMap.getCustomName(), argsPlayer, new PlaceHolder[0]);
                boolean canGive = !remove && itemMap.inWorld(argsPlayer.getWorld()) && itemMap.conditionMet(argsPlayer, "trigger-conditions", true, false) && (amount != 0 || itemMap.isAlwaysGive() || multiSlots.contains(itemMap.getConfigName()) || !itemMap.hasItem(argsPlayer, false));
                placeHolder.with(PlaceHolder.Holder.ITEM, customName).with(PlaceHolder.Holder.AMOUNT, Integer.toString(amount == 0 ? 1 : amount));
                placeHolders.with(PlaceHolder.Holder.ITEM, customName);
                if (remove && itemMap.hasItem(argsPlayer, true) || canGive && ItemUtilities.getUtilities().canOverwrite(argsPlayer, itemMap)) {
                    if (remove || !itemMap.isCMDPermissionNeeded() || itemMap.hasPermission(argsPlayer, argsPlayer.getWorld())) {
                        ItemStack topItem;
                        if (itemMap.isAlwaysGive() && !StringUtils.isInt(args[args.length - 1])) {
                            amount = itemMap.getCount(argsPlayer);
                        }
                        if (StringUtils.getSlotConversion(itemMap.getSlot()) != 0 && PlayerHandler.isCraftingInv(argsPlayer) && (topItem = CompatUtils.getTopInventory(argsPlayer).getItem(0)) != null && !topItem.getType().equals((Object)Material.AIR)) {
                            ItemHandler.returnCraftingItem(argsPlayer, 0, topItem.clone(), 0L);
                        }
                        if (remove) {
                            itemMap.removeFrom(argsPlayer, amount);
                        } else {
                            itemMap.giveTo(argsPlayer, amount);
                            if (arbitraryMap.containsKey(itemMap.getConfigName())) {
                                int arbitraryCount = (Integer)arbitraryMap.get(itemMap.getConfigName()) - 1;
                                arbitraryMap.put(itemMap.getConfigName(), arbitraryCount);
                            } else if (!itemMap.getMultipleSlots().isEmpty() && !multiSlots.contains(itemMap.getConfigName())) {
                                multiSlots.add(itemMap.getConfigName());
                            }
                        }
                        placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName()).with(PlaceHolder.Holder.AMOUNT, Integer.toString(amount == 0 ? 1 : amount));
                        if (!messageSent) {
                            if (!handledPlayers.contains(argsPlayer.getName()) && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                                handledPlayers.add(argsPlayer.getName());
                            }
                            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.removedYou" : "get.givenYou"), (CommandSender)argsPlayer, placeHolders);
                        }
                        PlayerHandler.quickCraftSave(argsPlayer);
                    } else if (!messageSent && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                        if (!failedPermission.contains(argsPlayer.getName()) && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                            failedPermission.add(argsPlayer.getName());
                        }
                        ItemJoin.getCore().getLang().sendLangMessage("commands.get.noPermission", (CommandSender)argsPlayer, placeHolders);
                    }
                } else if (!(messageSent || args.length < 3 || StringUtils.isInt(args[2]) || sender.getName().equalsIgnoreCase(argsPlayer.getName()))) {
                    placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName());
                    if (canGive) {
                        placeHolders.with(PlaceHolder.Holder.FAIL_COUNT, String.valueOf(1));
                        if (argsPlayer.getInventory().firstEmpty() == -1) {
                            ItemJoin.getCore().getLang().sendLangMessage("general.failedInventory", (CommandSender)argsPlayer, placeHolders);
                        } else {
                            ItemJoin.getCore().getLang().sendLangMessage("general.failedOverwrite", (CommandSender)argsPlayer, placeHolders);
                        }
                        if (!failedPermission.contains(argsPlayer.getName()) && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                            failedPermission.add(argsPlayer.getName());
                        }
                    } else {
                        ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.targetTriedRemoval" : "get.targetTriedGive"), (CommandSender)argsPlayer, placeHolders);
                        if (!failedPlayers.contains(argsPlayer.getName()) && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                            failedPlayers.add(argsPlayer.getName());
                        }
                    }
                } else if (!messageSent) {
                    placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName());
                    if (canGive) {
                        placeHolders.with(PlaceHolder.Holder.FAIL_COUNT, String.valueOf(1));
                        if (argsPlayer.getInventory().firstEmpty() == -1) {
                            ItemJoin.getCore().getLang().sendLangMessage("general.failedInventory", (CommandSender)argsPlayer, placeHolders);
                        } else {
                            ItemJoin.getCore().getLang().sendLangMessage("general.failedOverwrite", (CommandSender)argsPlayer, placeHolders);
                        }
                    } else {
                        ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.failedInventory" : "get.failedInventory"), sender, placeHolders);
                    }
                }
                if (messageSent) continue;
                messageSent = true;
            }
        });
        if (!handledPlayers.isEmpty()) {
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, ((Object)handledPlayers).toString().replace("]", "").replace("[", ""));
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.removedTarget" : "get.givenTarget"), sender, placeHolder);
        } else if (!failedPlayers.isEmpty()) {
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, ((Object)failedPlayers).toString().replace("]", "").replace("[", ""));
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.targetFailedInventory" : "get.targetFailedInventory"), sender, placeHolder);
        } else if (!failedPermission.isEmpty()) {
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, ((Object)failedPermission).toString().replace("]", "").replace("[", ""));
            ItemJoin.getCore().getLang().sendLangMessage("commands.get.targetNoPermission", sender, placeHolder);
        }
    }

    private void handleOnline(CommandSender sender, String[] args, boolean remove) {
        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM, args[1]);
        ArrayList handledPlayers = new ArrayList();
        ArrayList failedPlayers = new ArrayList();
        int amount = args.length == 3 ? Integer.parseInt(args[2]) : 0;
        boolean[] hasFailed = new boolean[]{false};
        PlayerHandler.forOnlinePlayers(argsPlayer -> {
            boolean messageSent = false;
            ItemMap itemMapExist = ItemUtilities.getUtilities().getItemMap(args[1]);
            if (itemMapExist == null) {
                if (!hasFailed[0]) {
                    ItemJoin.getCore().getLang().sendLangMessage("commands.item.noItem", sender, placeHolders);
                    hasFailed[0] = true;
                }
                return;
            }
            placeHolders.with(PlaceHolder.Holder.ITEM, StringUtils.translateLayout(itemMapExist.getCustomName(), argsPlayer, new PlaceHolder[0])).with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName()).with(PlaceHolder.Holder.AMOUNT, amount == 0 ? "&lAll" : Integer.toString(amount));
            ArrayList<String> multiSlots = new ArrayList<String>();
            for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
                boolean canGive;
                if (!itemMap.getConfigName().equalsIgnoreCase(args[1]) || !remove && itemMap.isCMDPermissionNeeded() && !itemMap.hasPermission((Player)argsPlayer, argsPlayer.getWorld())) continue;
                boolean bl = canGive = !remove && itemMap.inWorld(argsPlayer.getWorld()) && itemMap.conditionMet((Player)argsPlayer, "trigger-conditions", true, false) && (amount != 0 || itemMap.isAlwaysGive() || multiSlots.contains(itemMap.getConfigName()) || !itemMap.hasItem((Player)argsPlayer, false));
                if (remove && itemMap.hasItem((Player)argsPlayer, true) || canGive && ItemUtilities.getUtilities().canOverwrite((Player)argsPlayer, itemMap)) {
                    ItemStack topItem;
                    if (StringUtils.getSlotConversion(itemMap.getSlot()) != 0 && PlayerHandler.isCraftingInv(argsPlayer) && (topItem = CompatUtils.getTopInventory(argsPlayer).getItem(0)) != null && !topItem.getType().equals((Object)Material.AIR)) {
                        ItemHandler.returnCraftingItem(argsPlayer, 0, topItem.clone(), 0L);
                    }
                    if (remove) {
                        itemMap.removeFrom((Player)argsPlayer, amount);
                    } else {
                        itemMap.giveTo((Player)argsPlayer, amount);
                        if (!itemMap.getMultipleSlots().isEmpty() && !multiSlots.contains(itemMap.getConfigName())) {
                            multiSlots.add(itemMap.getConfigName());
                        }
                    }
                    if (!messageSent && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                        ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.removedYou" : "get.givenYou"), (CommandSender)argsPlayer, placeHolders);
                    }
                    if (!messageSent && !handledPlayers.contains(argsPlayer.getName())) {
                        handledPlayers.add(argsPlayer.getName());
                    }
                    PlayerHandler.quickCraftSave(argsPlayer);
                } else if (!messageSent) {
                    if (!sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                        if (canGive) {
                            placeHolders.with(PlaceHolder.Holder.FAIL_COUNT, String.valueOf(1));
                            if (argsPlayer.getInventory().firstEmpty() == -1) {
                                ItemJoin.getCore().getLang().sendLangMessage("general.failedInventory", (CommandSender)argsPlayer, placeHolders);
                            } else {
                                ItemJoin.getCore().getLang().sendLangMessage("general.failedOverwrite", (CommandSender)argsPlayer, placeHolders);
                            }
                        } else {
                            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.targetTriedRemoval" : "get.targetTriedGive"), (CommandSender)argsPlayer, placeHolders);
                        }
                    }
                    if (!failedPlayers.contains(argsPlayer.getName())) {
                        failedPlayers.add(argsPlayer.getName());
                    }
                }
                if (messageSent) continue;
                messageSent = true;
            }
        });
        placeHolders.with(PlaceHolder.Holder.PLAYERS, ((Object)handledPlayers).toString().replace("]", "").replace("[", ""));
        if (!handledPlayers.isEmpty()) {
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.removedOnline" : "get.givenOnline"), sender, placeHolders);
        } else if (!failedPlayers.isEmpty()) {
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.onlineFailedInventory" : "get.onlineFailedInventory"), sender, placeHolders);
        }
    }

    private void handleAllItems(CommandSender sender, String[] args, boolean remove) {
        ArrayList handledPlayers = new ArrayList();
        ArrayList failedPlayers = new ArrayList();
        ArrayList failedPermission = new ArrayList();
        PlaceHolder placeHolder = new PlaceHolder();
        PlayerHandler.forSelectedEntities(sender, args.length >= 2 ? args[1] : null, player -> {
            ItemStack topItem;
            Player argsPlayer = args.length >= 2 ? player : (Player)sender;
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TARGET_PLAYER, args.length >= 2 ? args[1] : sender.getName());
            if (argsPlayer == null) {
                ItemJoin.getCore().getLang().sendLangMessage("commands.default.noTarget", sender, placeHolders);
                return;
            }
            boolean itemGiven = false;
            int failedCount = 0;
            boolean failedPermissions = false;
            if (!remove && PlayerHandler.isCraftingInv(argsPlayer) && (topItem = CompatUtils.getTopInventory(argsPlayer).getItem(0)) != null && !topItem.getType().equals((Object)Material.AIR)) {
                ItemHandler.returnCraftingItem(argsPlayer, 0, topItem.clone(), 0L);
            }
            ItemMap probable = null;
            for (Object itemMap : ItemJoin.getCore().getChances().getItems().keySet()) {
                if (!((ItemMap)itemMap).hasItem(argsPlayer, true)) continue;
                probable = (ItemMap)itemMap;
            }
            if (probable == null) {
                probable = (ItemMap)ItemJoin.getCore().getChances().getRandom(argsPlayer);
            }
            ArrayList<String> multiSlots = new ArrayList<String>();
            HashMap<String, Integer> arbitraryMap = new HashMap<String, Integer>();
            for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
                boolean isAllowed;
                boolean bl = isAllowed = !(arbitraryMap.containsKey(itemMap.getConfigName()) && (Integer)arbitraryMap.get(itemMap.getConfigName()) == 0 || !remove && (!itemMap.inWorld(argsPlayer.getWorld()) || (probable == null || !itemMap.getConfigName().equals(probable.getConfigName())) && itemMap.getProbability() != -1 || itemMap.isCMDPermissionNeeded() && !itemMap.hasPermission(argsPlayer, argsPlayer.getWorld())));
                if (isAllowed && (remove || ItemUtilities.getUtilities().canOverwrite(argsPlayer, itemMap))) {
                    if (itemMap.getSlot().equalsIgnoreCase("ARBITRARY") && !arbitraryMap.containsKey(itemMap.getConfigName())) {
                        int arbitrary = ItemUtilities.getUtilities().getArbitrary(itemMap);
                        int count = 0;
                        for (ItemStack inPlayerInventory : argsPlayer.getInventory().getContents()) {
                            if (!itemMap.isSimilar(argsPlayer, inPlayerInventory)) continue;
                            ++count;
                        }
                        arbitraryMap.put(itemMap.getConfigName(), arbitrary - count);
                    }
                    if (!(remove && itemMap.hasItem(argsPlayer, true) || !remove && !itemMap.hasItem(argsPlayer, false)) && (remove || !itemMap.isAlwaysGive() && !multiSlots.contains(itemMap.getConfigName())) || !remove && !itemMap.conditionMet(argsPlayer, "trigger-conditions", true, false)) continue;
                    if (remove) {
                        itemMap.removeFrom(argsPlayer, new int[0]);
                    } else {
                        itemMap.giveTo(argsPlayer, new int[0]);
                        if (arbitraryMap.containsKey(itemMap.getConfigName())) {
                            int arbitraryCount = (Integer)arbitraryMap.get(itemMap.getConfigName()) - 1;
                            arbitraryMap.put(itemMap.getConfigName(), arbitraryCount);
                        } else if (!itemMap.getMultipleSlots().isEmpty() && !multiSlots.contains(itemMap.getConfigName())) {
                            multiSlots.add(itemMap.getConfigName());
                        }
                    }
                    if (!itemGiven) {
                        itemGiven = true;
                    }
                    PlayerHandler.quickCraftSave(argsPlayer);
                    continue;
                }
                if (!failedPermissions && !itemMap.hasPermission(argsPlayer, argsPlayer.getWorld())) {
                    failedPermissions = true;
                    continue;
                }
                if (remove || !isAllowed || itemMap.hasItem(argsPlayer, false) && !itemMap.isAlwaysGive() && !multiSlots.contains(itemMap.getConfigName())) continue;
                ++failedCount;
            }
            if (itemGiven && failedCount == 0) {
                failedPermissions = false;
                placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName());
                ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.removedYou_All" : "get.givenYou_All"), (CommandSender)argsPlayer, placeHolders);
                if (!handledPlayers.contains(argsPlayer.getName()) && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                    handledPlayers.add(argsPlayer.getName());
                }
            } else if (!failedPermissions && failedCount == 0) {
                placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, argsPlayer.getName());
                if (sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                    ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.failedInventory_All" : "get.failedInventory_All"), sender, placeHolders);
                } else if (!failedPlayers.contains(argsPlayer.getName())) {
                    failedPlayers.add(argsPlayer.getName());
                }
                if (!sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                    placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, sender.getName());
                    ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.targetTriedGive_All" : "get.targetTriedGive_All"), (CommandSender)argsPlayer, placeHolders);
                }
            } else if (failedCount > 0) {
                placeHolders.with(PlaceHolder.Holder.FAIL_COUNT, String.valueOf(failedCount));
                if (argsPlayer.getInventory().firstEmpty() == -1) {
                    ItemJoin.getCore().getLang().sendLangMessage("general.failedInventory", (CommandSender)argsPlayer, placeHolders);
                } else {
                    ItemJoin.getCore().getLang().sendLangMessage("general.failedOverwrite", (CommandSender)argsPlayer, placeHolders);
                }
                if (!failedPermission.contains(argsPlayer.getName()) && !sender.getName().equalsIgnoreCase(argsPlayer.getName())) {
                    failedPermission.add(argsPlayer.getName());
                }
            }
            if (failedPermissions) {
                placeHolders.with(PlaceHolder.Holder.TARGET_PLAYER, argsPlayer.getName());
                ItemJoin.getCore().getLang().sendLangMessage("commands.get." + (!sender.getName().equalsIgnoreCase(argsPlayer.getName()) ? "targetNoPermission_All" : "noPermission_All"), sender, placeHolders);
            }
        });
        if (!handledPlayers.isEmpty()) {
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, ((Object)handledPlayers).toString().replace("]", "").replace("[", ""));
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.removedTarget_All" : "get.givenTarget_All"), sender, placeHolder);
        } else if (!failedPlayers.isEmpty()) {
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, ((Object)failedPlayers).toString().replace("]", "").replace("[", ""));
            ItemJoin.getCore().getLang().sendLangMessage("commands." + (remove ? "remove.targetFailedInventory_All" : "get.targetFailedInventory_All"), sender, placeHolder);
        } else if (!failedPermission.isEmpty()) {
            placeHolder.with(PlaceHolder.Holder.TARGET_PLAYER, ((Object)failedPermission).toString().replace("]", "").replace("[", ""));
            ItemJoin.getCore().getLang().sendLangMessage("commands.get.targetNoPermission_All", sender, placeHolder);
        }
    }

    public static enum Execute {
        DEFAULT("", "itemjoin.use", false),
        HELP("help", "itemjoin.use", false),
        DUMP("dump", "itemjoin.dump", false),
        RELOAD("rl, reload", "itemjoin.reload", false),
        MENU("menu, creator", "itemjoin.menu", true),
        INFO("info", "itemjoin.use", true),
        QUERY("query", "itemjoin.query", false),
        WORLD("world, worlds", "itemjoin.use", true),
        LIST("list", "itemjoin.list", false),
        PERMISSIONS("permission, permissions", "itemjoin.permissions", true),
        PURGE("purge", "itemjoin.purge", false),
        ENABLE("enable", "itemjoin.enable, itemjoin.enable.others", false),
        DISABLE("disable", "itemjoin.disable, itemjoin.disable.others", false),
        GET("get, give", "itemjoin.get, itemjoin.get.others", true),
        GETALL("getAll, giveAll", "itemjoin.get, itemjoin.get.others", true),
        GETONLINE("getOnline, giveOnline", "itemjoin.get.others", false),
        REMOVE("remove", "itemjoin.remove, itemjoin.remove.others", true),
        REMOVEALL("removeAll", "itemjoin.remove, itemjoin.remove.others", true),
        REMOVEONLINE("removeOnline", "itemjoin.remove.others", false),
        UPDATE("update, updates", "itemjoin.updates", false),
        UPGRADE("upgrade", "itemjoin.upgrade", false),
        DEBUG("debug", "itemjoin.use", true);

        private final String command;
        private final String permission;
        private final boolean player;

        private Execute(String command, String permission, boolean player) {
            this.command = command;
            this.permission = permission;
            this.player = player;
        }

        public boolean accept(CommandSender sender, String[] args, int page) {
            return args.length == 0 && this.equals((Object)DEFAULT) && this.hasPermission(sender, args) || args.length != 0 && StringUtils.splitIgnoreCase(this.command, args[0], ",") && this.hasSyntax(args, page) && this.playerRequired(sender, args) && this.hasPermission(sender, args);
        }

        public boolean acceptArgs(String[] args) {
            return args.length == 0 || StringUtils.splitIgnoreCase(this.command, args[0], ",");
        }

        private boolean hasSyntax(String[] args, int page) {
            return args.length >= 2 && (args[1].equalsIgnoreCase(String.valueOf(page)) || page == 2 && StringUtils.isInt(args[1]) && Integer.parseInt(args[1]) != 0 && Integer.parseInt(args[1]) != 1 && (this.equals((Object)PERMISSIONS) && Integer.parseInt(args[1]) <= PluginData.getInfo().getPermissionPages() || this.equals((Object)LIST) && Integer.parseInt(args[1]) <= PluginData.getInfo().getListPages()) || page == 1 && this.equals((Object)PERMISSIONS) && StringUtils.isInt(args[1]) && Integer.parseInt(args[1]) == 0 || !StringUtils.isInt(args[1]) && (!this.equals((Object)PURGE) || args.length < 3)) || args.length < 2 && !this.equals((Object)GET) && !this.equals((Object)GETONLINE) && !this.equals((Object)REMOVE) && !this.equals((Object)REMOVEONLINE) && !this.equals((Object)QUERY) || this.equals((Object)PURGE) && args.length >= 3 && (args[1].equalsIgnoreCase("map-ids") || args[1].equalsIgnoreCase("ip-limits") || args[1].equalsIgnoreCase("first-join") || args[1].equalsIgnoreCase("first-world") || args[1].equalsIgnoreCase("enabled-players") || args[1].equalsIgnoreCase("first-commands"));
        }

        public boolean hasPermission(CommandSender sender, String[] args) {
            String[] permissions = this.permission.replace(" ", "").split(",");
            boolean multiPerms = this.permission.contains(",");
            return multiPerms && (!this.equals((Object)GET) && !this.equals((Object)REMOVE) && (args.length >= 2 && !StringUtils.isInt(args[1]) && PermissionsHandler.hasPermission(sender, permissions[1]) || (args.length < 2 || StringUtils.isInt(args[1])) && PermissionsHandler.hasPermission(sender, permissions[0])) || (this.equals((Object)GET) || this.equals((Object)REMOVE)) && (args.length == 3 && StringUtils.isInt(args[2]) || args.length == 2) && PermissionsHandler.hasPermission(sender, permissions[0]) || (args.length == 3 && !StringUtils.isInt(args[2]) || args.length >= 3) && PermissionsHandler.hasPermission(sender, permissions[1])) || !multiPerms && PermissionsHandler.hasPermission(sender, this.permission) && (!this.equals((Object)DEBUG) || PermissionsHandler.isDeveloper(sender));
        }

        public boolean playerRequired(CommandSender sender, String[] args) {
            return !this.player || !(sender instanceof ConsoleCommandSender) || (this.equals((Object)GETALL) || this.equals((Object)REMOVEALL)) && args.length >= 2 || (this.equals((Object)GET) || this.equals((Object)REMOVE)) && (args.length != 3 || PlayerHandler.getPlayerString(args[2]) != null || !StringUtils.isInt(args[2])) && args.length != 2;
        }
    }
}

