/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin;

import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import me.RockinChaos.itemjoin.utils.sql.DataObject;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class ChatToggleExecutor
implements CommandExecutor {
    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String label, @Nonnull String[] args) {
        if (!(sender instanceof ConsoleCommandSender)) {
            Player player = (Player)sender;
            ItemMap itemMap = this.getCommandMap(command, args);
            if (itemMap != null) {
                DataObject dataObject = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(player), "Global", itemMap.getConfigName(), String.valueOf(false)));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER, player.getName()).with(PlaceHolder.Holder.WORLD, player.getWorld().getName()).with(PlaceHolder.Holder.ITEM, itemMap.getConfigName());
                if ((dataObject == null || Boolean.valueOf(dataObject.getEnabled()).equals(true)) && (itemMap.getToggleNode() == null || itemMap.getToggleNode().isEmpty() || itemMap.getToggleNode() != null && !itemMap.getToggleNode().isEmpty() && sender.hasPermission(itemMap.getToggleNode()))) {
                    if (PluginData.getInfo().isEnabled(player, "ALL")) {
                        String toggleMessage;
                        ItemJoin.getCore().getSQL().removeData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(player), "Global", itemMap.getConfigName(), String.valueOf(true)), new boolean[0]);
                        ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(player), "Global", itemMap.getConfigName(), String.valueOf(false)));
                        placeHolders.with(PlaceHolder.Holder.STATE, "off");
                        if (itemMap.hasItem(player, true)) {
                            itemMap.removeFrom(player, new int[0]);
                        }
                        String string = toggleMessage = itemMap.getToggleMessage() != null ? StringUtils.translateLayout(itemMap.getToggleMessage(), player, placeHolders) : null;
                        if (toggleMessage != null) {
                            ServerUtils.messageSender((CommandSender)player, toggleMessage, false);
                        } else {
                            ItemJoin.getCore().getLang().sendLangMessage("commands.disabled.toggleDisable", (CommandSender)player, placeHolders);
                        }
                    } else {
                        ItemJoin.getCore().getLang().sendLangMessage("commands.disabled.togglePlayerFailed", sender, placeHolders);
                    }
                } else if (dataObject != null && Boolean.valueOf(dataObject.getEnabled()).equals(false) && (itemMap.getToggleNode() == null || itemMap.getToggleNode().isEmpty() || itemMap.getToggleNode() != null && !itemMap.getToggleNode().isEmpty() && sender.hasPermission(itemMap.getToggleNode()))) {
                    if (PluginData.getInfo().isEnabled(player, "ALL")) {
                        String toggleMessage;
                        ItemJoin.getCore().getSQL().removeData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(player), "Global", itemMap.getConfigName(), String.valueOf(false)), new boolean[0]);
                        placeHolders.with(PlaceHolder.Holder.STATE, "on");
                        if (!itemMap.hasItem(player, true)) {
                            itemMap.giveTo(player, new int[0]);
                        }
                        String string = toggleMessage = itemMap.getToggleMessage() != null ? StringUtils.translateLayout(itemMap.getToggleMessage(), player, placeHolders) : null;
                        if (toggleMessage != null) {
                            ServerUtils.messageSender((CommandSender)player, toggleMessage, false);
                        } else {
                            ItemJoin.getCore().getLang().sendLangMessage("commands.enabled.toggleEnable", (CommandSender)player, placeHolders);
                        }
                    } else {
                        ItemJoin.getCore().getLang().sendLangMessage("commands.enabled.togglePlayerFailed", sender, placeHolders);
                    }
                } else if (itemMap.getToggleNode() == null || itemMap.getToggleNode().isEmpty() || !sender.hasPermission(itemMap.getToggleNode())) {
                    ItemJoin.getCore().getLang().sendLangMessage("commands.default.noPermission", sender, new PlaceHolder[0]);
                }
            } else {
                sender.sendMessage("Unknown command. Type \"/help\" for help.");
            }
        } else {
            ItemJoin.getCore().getLang().sendLangMessage("commands.default.noPlayer", sender, new PlaceHolder[0]);
        }
        return true;
    }

    private ItemMap getCommandMap(Command command, String[] args) {
        ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(command.getDescription());
        boolean canToggle = false;
        for (String commands : itemMap.getToggleCommands()) {
            if (!commands.equalsIgnoreCase(command.getName())) continue;
            canToggle = true;
            break;
        }
        if (args.length != 0 && !canToggle) {
            StringBuilder fullCommand = new StringBuilder(command.getName());
            for (String length : args) {
                fullCommand.append(" ").append(length);
            }
            block2: for (ItemMap item : ItemUtilities.getUtilities().getItems()) {
                if (canToggle) break;
                for (String commands : item.getToggleCommands()) {
                    if (!commands.equalsIgnoreCase(fullCommand.toString().trim())) continue;
                    itemMap = item;
                    canToggle = true;
                    continue block2;
                }
            }
        }
        return canToggle ? itemMap : null;
    }
}

