/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.item.ItemCommand;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class APIUtils {
    public void setItems(Player player) {
        ItemMap probable = null;
        for (Object itemMap : ItemJoin.getCore().getChances().getItems().keySet()) {
            if (!((ItemMap)itemMap).hasItem(player, true)) continue;
            probable = (ItemMap)itemMap;
        }
        if (probable == null) {
            probable = (ItemMap)ItemJoin.getCore().getChances().getRandom(player);
        }
        int session = StringUtils.getRandom(1, 80000);
        ArrayList<String> multiSlots = new ArrayList<String>();
        for (ItemMap item : ItemUtilities.getUtilities().getItems()) {
            if (item.inWorld(player.getWorld()) && (probable != null && item.getConfigName().equals(probable.getConfigName()) || item.getProbability() == -1) && PluginData.getInfo().isEnabled(player, item.getConfigName()) && item.isLimitMode(player.getGameMode()) && item.hasPermission(player, player.getWorld()) && ItemUtilities.getUtilities().isObtainable(player, item, session, ItemUtilities.TriggerType.DEFAULT, "IJ_WORLD", multiSlots)) {
                item.giveTo(player, new int[0]);
                if (!item.getMultipleSlots().isEmpty() && !multiSlots.contains(item.getConfigName())) {
                    multiSlots.add(item.getConfigName());
                }
            }
            item.setAnimations(player);
        }
        ItemUtilities.getUtilities().sendFailCount(player, session, ItemUtilities.TriggerType.DEFAULT, "IJ_WORLD");
        PlayerHandler.updateInventory(player, 15L);
    }

    public boolean isCustom(ItemStack item, World world) {
        ItemMap itemMap = this.getMap(item, world, null);
        return itemMap != null;
    }

    public ItemStack getItemStack(Player player, String itemNode) {
        ItemMap itemMap = this.getMap(null, null, itemNode);
        if (itemMap != null) {
            return itemMap.getItemStack(player);
        }
        return null;
    }

    public String getNode(ItemStack item, World world) {
        ItemMap itemMap = this.getMap(item, world, null);
        if (itemMap != null) {
            return itemMap.getConfigName();
        }
        return null;
    }

    public List<String> getItemflags(String itemNode) {
        ItemMap itemMap = this.getMap(null, null, itemNode);
        ArrayList<String> itemflags = new ArrayList<String>();
        if (itemMap != null && itemMap.getItemFlags() != null && !itemMap.getItemFlags().isEmpty()) {
            Collections.addAll(itemflags, itemMap.getItemFlags().replace(" ", "").split(","));
            return itemflags;
        }
        return null;
    }

    public List<String> getCommands(String itemNode) {
        ItemMap itemMap = this.getMap(null, null, itemNode);
        ArrayList<String> commands = new ArrayList<String>();
        if (itemMap != null && itemMap.getCommands() != null && itemMap.getCommands().length > 0) {
            for (ItemCommand command : itemMap.getCommands()) {
                commands.add(command.getRawCommand());
            }
            return commands;
        }
        return null;
    }

    public List<String> getTriggers(String itemNode) {
        ItemMap itemMap = this.getMap(null, null, itemNode);
        ArrayList<String> triggers = new ArrayList<String>();
        if (itemMap != null && itemMap.getTriggers() != null && !itemMap.getTriggers().isEmpty()) {
            Collections.addAll(triggers, itemMap.getTriggers().replace(" ", "").split(","));
            return triggers;
        }
        return null;
    }

    public String getSlot(String itemNode) {
        ItemMap itemMap = this.getMap(null, null, itemNode);
        if (itemMap != null) {
            return itemMap.getSlot();
        }
        return null;
    }

    public List<String> getMultipleSlots(String itemNode) {
        ItemMap itemMap = this.getMap(null, null, itemNode);
        if (itemMap != null) {
            return itemMap.getMultipleSlots();
        }
        return null;
    }

    public List<String> getNodes() {
        return ItemUtilities.getUtilities().getItems().stream().map(ItemMap::getConfigName).collect(Collectors.toList());
    }

    private ItemMap getMap(ItemStack item, World world, String itemNode) {
        for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
            if (world != null && itemMap.inWorld(world) && itemMap.isSimilar(null, item)) {
                return itemMap;
            }
            if (world == null && itemMap.isSimilar(null, item)) {
                return itemMap;
            }
            if (world != null || item != null || !itemMap.getConfigName().equalsIgnoreCase(itemNode)) continue;
            return itemMap;
        }
        return null;
    }
}

