/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core;

import java.io.File;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.CoreData;
import me.RockinChaos.itemjoin.core.handlers.ConfigHandler;
import me.RockinChaos.itemjoin.core.handlers.LogHandler;
import me.RockinChaos.itemjoin.core.handlers.UpdateHandler;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.BungeeAPI;
import me.RockinChaos.itemjoin.core.utils.api.ChanceAPI;
import me.RockinChaos.itemjoin.core.utils.api.DependAPI;
import me.RockinChaos.itemjoin.core.utils.api.LanguageAPI;
import me.RockinChaos.itemjoin.core.utils.sql.SQL;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Core {
    private static Core core;
    private final JavaPlugin plugin;
    private final File pluginFile;

    public Core(@Nonnull JavaPlugin plugin, @Nonnull File pluginFile, @Nonnull String prefix) {
        core = this;
        this.plugin = plugin;
        this.pluginFile = pluginFile;
        core.getData().setPluginPrefix(prefix);
    }

    @Nonnull
    public static Core getCore() {
        return core;
    }

    public boolean isEnabled() {
        boolean isSupported = ServerUtils.hasSpecificUpdate("1_8");
        if (!isSupported) {
            ServerUtils.logSevere("detected incompatible server version.");
            ServerUtils.logSevere("only Minecraft 1.8 and above is supported... disabling...");
            this.getPlugin().getPluginLoader().disablePlugin((Plugin)this.getPlugin());
        }
        return isSupported;
    }

    @Nonnull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isStarted() {
        return CoreData.getData().isStarted();
    }

    @Nonnull
    public SQL getSQL() {
        return SQL.getSQL();
    }

    @Nonnull
    public CoreData getData() {
        return CoreData.getData();
    }

    @Nonnull
    public LanguageAPI getLang() {
        return LanguageAPI.getLang();
    }

    @Nonnull
    public LogHandler getFilter() {
        return LogHandler.getFilter();
    }

    @Nonnull
    public BungeeAPI getBungee() {
        return BungeeAPI.getBungee();
    }

    @Nonnull
    public ChanceAPI getChances() {
        return ChanceAPI.getChances();
    }

    @Nonnull
    public DependAPI getDependencies() {
        return DependAPI.getDepends();
    }

    @Nonnull
    public ConfigHandler getConfiguration() {
        return ConfigHandler.getConfig();
    }

    @Nonnull
    public FileConfiguration getConfig(@Nonnull String configFile) {
        return ConfigHandler.getConfig().getFile(configFile);
    }

    @Nonnull
    public UpdateHandler getUpdater() {
        return UpdateHandler.getUpdater(this.plugin, this.pluginFile, this.getData().checkForUpdates());
    }
}

