/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.handlers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Skull;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapView;
import org.bukkit.potion.PotionType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemHandler {
    private static final Map<String, Object> gameProfiles = new HashMap<String, Object>();

    @Nonnull
    public static ItemStack addLore(@Nonnull ItemStack item, String ... lores) {
        if (item.getType() != Material.AIR) {
            ItemMeta meta = item.getItemMeta();
            List<String> newLore = new ArrayList();
            if (meta != null) {
                if (meta.hasLore()) {
                    newLore = meta.getLore();
                }
                for (String lore : lores) {
                    if (newLore == null) continue;
                    newLore.add(StringUtils.colorFormat(lore));
                }
                meta.setLore(newLore);
                item.setItemMeta(meta);
            }
        }
        return item;
    }

    public static boolean isSimilar(@Nullable ItemStack item1, @Nullable ItemStack item2) {
        return item1 != null && item2 != null && item1.getType() != Material.AIR && item2.getType() != Material.AIR && item1.getType() == item2.getType() && item1.hasItemMeta() && item2.hasItemMeta() && Objects.requireNonNull(item1.getItemMeta()).hasDisplayName() && Objects.requireNonNull(item2.getItemMeta()).hasDisplayName() && item1.getItemMeta().getDisplayName().equalsIgnoreCase(item2.getItemMeta().getDisplayName());
    }

    @Nonnull
    public static String getMaterialName(@Nonnull ItemStack item) {
        String name = item.getType().name().toLowerCase().replace('_', ' ');
        try {
            return WordUtils.capitalizeFully((String)name);
        }
        catch (NullPointerException e) {
            ServerUtils.sendDebugTrace(e);
            return name;
        }
    }

    @Nonnull
    public static List<Enchantment> getEnchants() {
        return CompatUtils.values(Enchantment.class);
    }

    @Nonnull
    public static String getEnchantName(@Nonnull Enchantment enchant) {
        if (!ServerUtils.hasSpecificUpdate("1_13")) {
            return LegacyAPI.getEnchantName(enchant);
        }
        return CompatUtils.getKey(enchant).getKey();
    }

    @Nullable
    public static Enchantment getEnchantByName(@Nonnull String name) {
        if (ServerUtils.hasSpecificUpdate("1_13")) {
            try {
                Enchantment enchantName = LegacyAPI.getEnchantByKey(name);
                if (enchantName != null) {
                    return enchantName;
                }
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
        return LegacyAPI.getEnchant(name);
    }

    @Nullable
    public static org.bukkit.inventory.meta.trim.TrimMaterial getTrimMaterial(@Nonnull String name) {
        try {
            Field field = org.bukkit.inventory.meta.trim.TrimMaterial.class.getDeclaredField(name);
            Object value = field.get(name);
            return (org.bukkit.inventory.meta.trim.TrimMaterial)value;
        }
        catch (Exception e) {
            ServerUtils.logWarn("{ItemHandler} Failed to get the Trim Material " + name + ", check that you are using the proper name.");
            ServerUtils.sendDebugTrace(e);
            return null;
        }
    }

    @Nonnull
    public static List<org.bukkit.inventory.meta.trim.TrimMaterial> getTrimMaterials() {
        ArrayList<org.bukkit.inventory.meta.trim.TrimMaterial> trimMaterials = new ArrayList<org.bukkit.inventory.meta.trim.TrimMaterial>();
        try {
            for (Field fieldMaterial : org.bukkit.inventory.meta.trim.TrimMaterial.class.getDeclaredFields()) {
                trimMaterials.add((org.bukkit.inventory.meta.trim.TrimMaterial)fieldMaterial.get(fieldMaterial.getName()));
            }
            return trimMaterials;
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return trimMaterials;
        }
    }

    @Nullable
    public static TrimPattern getTrimPattern(@Nonnull String name) {
        try {
            Field field = TrimPattern.class.getDeclaredField(name);
            Object value = field.get(name);
            return (TrimPattern)value;
        }
        catch (Exception e) {
            ServerUtils.logWarn("{ItemHandler} Failed to get the Trim Pattern " + name + ", check that you are using the proper name.");
            ServerUtils.sendDebugTrace(e);
            return null;
        }
    }

    @Nonnull
    public static List<TrimPattern> getTrimPatterns() {
        ArrayList<TrimPattern> trimPatterns = new ArrayList<TrimPattern>();
        try {
            for (Field fieldPattern : TrimPattern.class.getDeclaredFields()) {
                trimPatterns.add((TrimPattern)fieldPattern.get(fieldPattern.getName()));
            }
            return trimPatterns;
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return trimPatterns;
        }
    }

    public static void setArmorTrim(@Nonnull ItemStack item, @Nonnull String material, @Nonnull String pattern) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null) {
            org.bukkit.inventory.meta.trim.TrimMaterial trimMaterial = ItemHandler.getTrimMaterial(material);
            TrimPattern trimPattern = ItemHandler.getTrimPattern(pattern);
            if (trimMaterial != null && trimPattern != null) {
                ((ArmorMeta)itemMeta).setTrim(new ArmorTrim(trimMaterial, trimPattern));
                item.setItemMeta(itemMeta);
            }
        }
    }

    public static short getDurability(@Nonnull ItemStack item) {
        if (!ServerUtils.hasSpecificUpdate("1_13")) {
            return LegacyAPI.getDurability(item);
        }
        if (item.getItemMeta() != null) {
            return (short)((Damageable)item.getItemMeta()).getDamage();
        }
        return 0;
    }

    @Nonnull
    public static ItemStack setDurability(@Nonnull ItemStack item, int durability) {
        if (item.getType().getMaxDurability() != 0 && durability != 0) {
            if (ServerUtils.hasSpecificUpdate("1_13")) {
                ItemMeta tempMeta = item.getItemMeta();
                if (tempMeta != null) {
                    ((Damageable)tempMeta).setDamage(durability);
                    item.setItemMeta(tempMeta);
                    return item;
                }
            } else {
                return LegacyAPI.setDurability(item, (short)durability);
            }
        }
        return item;
    }

    @Nonnull
    public static ItemStack modifyItem(@Nullable ItemStack itemCopy, boolean allItems, int amount) {
        if (itemCopy == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack item = new ItemStack(itemCopy);
        if ((item.getAmount() > amount && item.getAmount() != amount || item.getAmount() < amount) && !allItems) {
            item.setAmount(item.getAmount() - amount);
        } else {
            item = new ItemStack(Material.AIR);
        }
        return item;
    }

    public static void setData(@Nonnull ItemMeta itemMeta, int data) {
        itemMeta.setCustomModelData(Integer.valueOf(data));
    }

    public static String getPatternName(@Nonnull Object pattern) {
        return CompatUtils.getName(pattern);
    }

    @Nonnull
    public static List<PatternType> getPatterns() {
        return CompatUtils.values(PatternType.class);
    }

    @Nonnull
    public static ItemStack getItem(@Nonnull String material, int count, boolean glowing, boolean hideAttributes, @Nonnull String name, String ... lores) {
        ItemMeta tempMeta;
        ItemStack tempItem;
        String refMat = "";
        if (material.equalsIgnoreCase("AIR") || material.equalsIgnoreCase("AIR:0")) {
            material = "GLASS_PANE";
        }
        if (material.equalsIgnoreCase("WATER_BOTTLE")) {
            refMat = material;
            material = "POTION";
        }
        if (ServerUtils.hasSpecificUpdate("1_13")) {
            Material bukkitMaterial = ItemHandler.getMaterial(material, null);
            try {
                tempItem = new ItemStack(bukkitMaterial != Material.AIR ? bukkitMaterial : Material.STONE, count);
            }
            catch (IllegalArgumentException e) {
                return new ItemStack(Material.AIR);
            }
        } else {
            Material legacyMaterial;
            short dataValue = 0;
            if (material.contains(":")) {
                String[] parts = material.split(":");
                material = parts[0];
                dataValue = (short)Integer.parseInt(parts[1]);
            }
            tempItem = LegacyAPI.newItemStack((legacyMaterial = ItemHandler.getMaterial(material, null)) != Material.AIR ? legacyMaterial : Material.STONE, count, dataValue);
        }
        if (glowing) {
            ItemHandler.setGlowing(tempItem);
        }
        if ((tempMeta = tempItem.getItemMeta()) != null) {
            tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (tempMeta != null) {
            name = StringUtils.colorFormat(name);
            tempMeta.setDisplayName(name);
        }
        if (lores.length != 0 && tempMeta != null) {
            ArrayList<String> loreList = new ArrayList<String>();
            for (String loreString : lores) {
                if (loreString.isEmpty()) continue;
                if ((loreString = loreString.replace("//n", "/n").replace("\\n", "/n").replace("\n", "/n")).contains(" /n ")) {
                    String[] loreSplit;
                    for (String loreStringSplit : loreSplit = loreString.split(" /n ")) {
                        loreList.add(StringUtils.colorFormat(loreStringSplit));
                    }
                    continue;
                }
                loreList.add(StringUtils.colorFormat(loreString));
            }
            tempMeta.setLore(loreList);
        }
        if (hideAttributes && tempMeta != null) {
            CompatUtils.setDummyAttributes(tempMeta);
            tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            if (!ServerUtils.hasPreciseUpdate("1_20_5")) {
                tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS")});
            } else {
                tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            }
            if (ServerUtils.hasSpecificUpdate("1_20")) {
                tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
            }
            if (ServerUtils.hasSpecificUpdate("1_17")) {
                tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            }
        }
        if (ServerUtils.hasSpecificUpdate("1_9") && refMat.equalsIgnoreCase("WATER_BOTTLE") && tempMeta != null) {
            if (ServerUtils.hasPreciseUpdate("1_20_3")) {
                ((PotionMeta)tempMeta).setBasePotionType(PotionType.WATER);
            } else {
                LegacyAPI.setPotionData((PotionMeta)tempMeta, PotionType.WATER);
            }
        }
        tempItem.setItemMeta(tempMeta);
        return tempItem;
    }

    @Nonnull
    public static ItemStack getItem(@Nonnull Player player, @Nonnull String checkSlot) {
        int craftSlot = StringUtils.getSlotConversion(checkSlot);
        EntityEquipment equipment = player.getEquipment();
        ItemStack existingItem = null;
        if (StringUtils.isInt(checkSlot)) {
            existingItem = player.getInventory().getItem(Integer.parseInt(checkSlot));
        } else if (checkSlot.contains("%")) {
            String slot = StringUtils.translateLayout(checkSlot, player, new PlaceHolder[0]);
            if (StringUtils.isInt(slot)) {
                existingItem = player.getInventory().getItem(Integer.parseInt(slot));
            }
        } else if (CustomSlot.HELMET.isSlot(checkSlot) && equipment != null) {
            existingItem = equipment.getHelmet();
        } else if (CustomSlot.CHESTPLATE.isSlot(checkSlot) && equipment != null) {
            existingItem = equipment.getChestplate();
        } else if (CustomSlot.LEGGINGS.isSlot(checkSlot) && equipment != null) {
            existingItem = equipment.getLeggings();
        } else if (CustomSlot.BOOTS.isSlot(checkSlot) && equipment != null) {
            existingItem = equipment.getBoots();
        } else if (ServerUtils.hasSpecificUpdate("1_9") && CustomSlot.OFFHAND.isSlot(checkSlot) && equipment != null) {
            existingItem = equipment.getItemInOffHand();
        } else if (craftSlot != -1) {
            existingItem = CompatUtils.getTopInventory(player).getItem(craftSlot);
        }
        return existingItem != null && existingItem.getType() != Material.AIR ? existingItem : new ItemStack(Material.AIR);
    }

    @Nonnull
    public static Material getMaterial(@Nonnull String material, @Nullable String data) {
        try {
            Material mat;
            boolean isLegacy;
            boolean bl = isLegacy = data != null && Integer.parseInt(data) > 0;
            if (material.contains(":")) {
                String[] parts = material.split(":");
                material = parts[0];
                if (!parts[1].equalsIgnoreCase("0")) {
                    data = parts[1];
                    isLegacy = true;
                }
            }
            if (StringUtils.isInt(material) && !ServerUtils.hasSpecificUpdate("1_13")) {
                return LegacyAPI.findMaterial(Integer.parseInt(material));
            }
            if (StringUtils.isInt(material) && ServerUtils.hasSpecificUpdate("1_13") || isLegacy && ServerUtils.hasSpecificUpdate("1_13")) {
                if (!StringUtils.isInt(material)) {
                    material = "LEGACY_" + material;
                }
                int dataValue = data != null ? Integer.parseInt(data) : 0;
                if (!StringUtils.isInt(material)) {
                    Material mat2 = Material.getMaterial((String)material.toUpperCase());
                    if (mat2 != null) {
                        return LegacyAPI.getMaterial(mat2, (byte)dataValue);
                    }
                    return Material.AIR;
                }
                return LegacyAPI.getMaterial(Integer.parseInt(material), (byte)dataValue);
            }
            if (!ServerUtils.hasSpecificUpdate("1_13") ? (mat = Material.getMaterial((String)material.toUpperCase())) != null : (mat = Material.matchMaterial((String)material.toUpperCase())) != null) {
                return mat;
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        return Material.AIR;
    }

    public static boolean containsMaterial(@Nonnull Collection<ItemStack> itemStacks, @Nonnull Material material) {
        for (ItemStack item : itemStacks) {
            if (!item.getType().equals((Object)material)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static ItemStack setSkullTexture(@Nonnull Player player, @Nonnull ItemStack item, @Nonnull String skullTexture) {
        if (item.getItemMeta() != null) {
            ItemMeta itemMeta = ItemHandler.setSkullTexture(player, item.getItemMeta(), skullTexture);
            item.setItemMeta(itemMeta);
        }
        return item;
    }

    @Nonnull
    public static ItemMeta setSkullTexture(@Nonnull Player player, @Nonnull ItemMeta itemMeta, @Nonnull String skullTexture) {
        try {
            if (ServerUtils.hasPreciseUpdate("1_18_2")) {
                PlayerProfile playerProfile;
                if (!gameProfiles.containsKey(skullTexture)) {
                    UUID uuid = UUID.randomUUID();
                    playerProfile = Bukkit.createPlayerProfile((UUID)uuid, (String)uuid.toString().replaceAll("_", "").replaceAll("-", "").substring(0, 16));
                    PlayerTextures textures = playerProfile.getTextures();
                    URI textureURI = StringUtils.toTextureURI(skullTexture);
                    if (textureURI != null) {
                        textures.setSkin(textureURI.toURL());
                        playerProfile.setTextures(textures);
                    } else {
                        ServerUtils.logSevere("{ItemHandler} The specified skull-texture is INVALID: " + skullTexture + ".");
                        ServerUtils.logSevere("{ItemHandler} The skull-texture will NOT be set!");
                    }
                } else {
                    playerProfile = (PlayerProfile)gameProfiles.get(skullTexture);
                }
                ((SkullMeta)itemMeta).setOwnerProfile(playerProfile);
            } else {
                GameProfile gameProfile;
                if (!gameProfiles.containsKey(skullTexture)) {
                    UUID uuid = UUID.randomUUID();
                    gameProfile = new GameProfile(uuid, uuid.toString().replaceAll("_", "").replaceAll("-", "").substring(0, 16));
                    gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skullTexture));
                    gameProfiles.put(skullTexture, gameProfile);
                } else {
                    gameProfile = (GameProfile)gameProfiles.get(skullTexture);
                }
                Field declaredField = itemMeta.getClass().getDeclaredField("profile");
                declaredField.setAccessible(true);
                declaredField.set(itemMeta, gameProfile);
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        return itemMeta;
    }

    @Nonnull
    public static String getSkullTexture(@Nonnull ItemMeta meta) {
        Class<Property> propertyClass = Property.class;
        try {
            Class<?> cls = ReflectionUtils.getCraftBukkitClass("inventory.CraftMetaSkull");
            Object real = cls.cast(meta);
            Field field = real.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            GameProfile profile = (GameProfile)field.get(real);
            Collection props = profile.getProperties().get((Object)"textures");
            for (Property property : props) {
                try {
                    if (!propertyClass.getMethod("getName", new Class[0]).invoke((Object)property, new Object[0]).equals("textures")) continue;
                    return (String)propertyClass.getMethod("getValue", new Class[0]).invoke((Object)property, new Object[0]);
                }
                catch (Exception e) {
                    try {
                        if (!propertyClass.getMethod("name", new Class[0]).invoke((Object)property, new Object[0]).equals("textures")) continue;
                        return (String)propertyClass.getMethod("value", new Class[0]).invoke((Object)property, new Object[0]);
                    }
                    catch (Exception e2) {
                        ServerUtils.sendSevereTrace(e);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Nonnull
    public static String getSkullTexture(@Nonnull Skull skull) {
        Class<Property> propertyClass = Property.class;
        try {
            Field field = skull.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            GameProfile profile = (GameProfile)field.get(skull);
            Collection props = profile.getProperties().get((Object)"textures");
            for (Property property : props) {
                try {
                    if (!propertyClass.getMethod("getName", new Class[0]).invoke((Object)property, new Object[0]).equals("textures")) continue;
                    return (String)propertyClass.getMethod("getValue", new Class[0]).invoke((Object)property, new Object[0]);
                }
                catch (Exception e) {
                    try {
                        if (!propertyClass.getMethod("name", new Class[0]).invoke((Object)property, new Object[0]).equals("textures")) continue;
                        return (String)propertyClass.getMethod("value", new Class[0]).invoke((Object)property, new Object[0]);
                    }
                    catch (Exception e2) {
                        ServerUtils.sendSevereTrace(e);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Nonnull
    public static ItemMeta setSkullOwner(@Nonnull ItemMeta meta, @Nonnull Player player, @Nonnull String owner) {
        ItemHandler.setStoredSkull(meta, player, owner);
        return meta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setStoredSkull(@Nonnull ItemMeta meta, @Nonnull Player player, @Nonnull String owner) {
        if (owner.isEmpty()) return;
        SkullMeta skullMeta = (SkullMeta)meta;
        OfflinePlayer offPlayer = LegacyAPI.getOfflinePlayer(owner);
        if (Core.getCore().getDependencies().skinsRestorerEnabled()) {
            String textureValue = Core.getCore().getDependencies().getSkinValue(player.getUniqueId(), owner);
            if (textureValue != null) {
                ItemHandler.setSkullTexture(player, meta, textureValue);
                return;
            } else {
                try {
                    skullMeta.setOwningPlayer(offPlayer);
                    return;
                }
                catch (Throwable t) {
                    if (offPlayer.getName() == null) return;
                    LegacyAPI.setSkullOwner(player, skullMeta, offPlayer.getName());
                }
            }
            return;
        }
        try {
            skullMeta.setOwningPlayer(offPlayer);
            return;
        }
        catch (Throwable t) {
            if (offPlayer.getName() == null) return;
            LegacyAPI.setSkullOwner(player, skullMeta, offPlayer.getName());
        }
    }

    public static int stackItems(@Nonnull Player player, @Nonnull ItemStack item1, @Nonnull ItemStack item2, int slot, boolean topInventory) {
        int MINECRAFT_STACK_MAX = 64;
        int DESIRED_STACK_SIZE = item1.getAmount() + item2.getAmount();
        int REMAINING_STACK_SIZE = 0;
        if (DESIRED_STACK_SIZE > MINECRAFT_STACK_MAX) {
            item2.setAmount(MINECRAFT_STACK_MAX);
            item1.setAmount(DESIRED_STACK_SIZE - MINECRAFT_STACK_MAX);
            REMAINING_STACK_SIZE = item1.getAmount();
        } else if (slot == -1) {
            item2.setAmount(item2.getAmount() + 1);
            if (item1.getAmount() == 1) {
                CompatUtils.setCursor(player, new ItemStack(Material.AIR));
            } else {
                item1.setAmount(item1.getAmount() - 1);
            }
        } else {
            item2.setAmount(item2.getAmount() + item1.getAmount());
            if (slot == -2) {
                CompatUtils.setCursor(player, new ItemStack(Material.AIR));
            } else if (slot != -3) {
                if (topInventory) {
                    CompatUtils.getTopInventory(player).setItem(slot, new ItemStack(Material.AIR));
                } else {
                    player.getInventory().setItem(slot, new ItemStack(Material.AIR));
                }
            }
        }
        return REMAINING_STACK_SIZE;
    }

    @Nonnull
    public static MapView existingView(int id) {
        MapView view = LegacyAPI.getMapView(id);
        if (view == null) {
            view = LegacyAPI.createMapView();
        }
        return view;
    }

    public static void removeCraftItems(@Nonnull Player player) {
        Inventory craftView = CompatUtils.getTopInventory(player);
        ItemStack[] craftingContents = craftView.getContents();
        if (PlayerHandler.isCraftingInv(player)) {
            for (int k = 0; k < craftingContents.length; ++k) {
                craftView.setItem(k, new ItemStack(Material.AIR));
            }
        }
    }

    public static void returnCraftingItem(@Nonnull Player player, int slot, @Nonnull ItemStack item, long delay) {
        if (slot == 0) {
            ++delay;
        }
        SchedulerUtils.runLater(delay, () -> {
            if (!player.isOnline()) {
                return;
            }
            if (PlayerHandler.isCraftingInv(player) && player.getGameMode() != GameMode.CREATIVE) {
                CompatUtils.getTopInventory(player).setItem(slot, item);
                PlayerHandler.updateInventory(player, 1L);
            } else {
                ItemHandler.returnCraftingItem(player, slot, item, 10L);
            }
        });
    }

    @Nullable
    public static Inventory getCraftInventory(@Nonnull Player player) {
        boolean notNull;
        Inventory inv;
        block4: {
            block5: {
                block3: {
                    inv = Bukkit.createInventory(null, (int)9);
                    notNull = false;
                    if (!PlayerHandler.getCreativeCraftItems().containsKey(PlayerHandler.getPlayerID(player))) break block3;
                    ItemStack[] craftingContents = PlayerHandler.getCreativeCraftItems().get(PlayerHandler.getPlayerID(player));
                    for (int k = 0; k <= 4; ++k) {
                        if (craftingContents == null || craftingContents[k] == null) continue;
                        inv.setItem(k, craftingContents[k]);
                        if (craftingContents[k] == null || craftingContents[k].getType() == Material.AIR) continue;
                        notNull = true;
                    }
                    break block4;
                }
                if (!PlayerHandler.getOpenCraftItems().containsKey(PlayerHandler.getPlayerID(player))) break block5;
                ItemStack[] craftingContents = PlayerHandler.getOpenCraftItems().get(PlayerHandler.getPlayerID(player));
                for (int k = 0; k <= 4; ++k) {
                    if (craftingContents == null || craftingContents[k] == null) continue;
                    inv.setItem(k, craftingContents[k]);
                    if (craftingContents[k] == null || craftingContents[k].getType() == Material.AIR) continue;
                    notNull = true;
                }
                break block4;
            }
            if (!PlayerHandler.getCraftItems().containsKey(PlayerHandler.getPlayerID(player))) break block4;
            ItemStack[] craftingContents = PlayerHandler.getCraftItems().get(PlayerHandler.getPlayerID(player));
            for (int k = 0; k <= 4; ++k) {
                if (craftingContents == null || craftingContents[k] == null) continue;
                inv.setItem(k, craftingContents[k]);
                if (craftingContents[k] == null || craftingContents[k].getType() == Material.AIR) continue;
                notNull = true;
            }
        }
        return notNull ? inv : null;
    }

    public static boolean restoreCraftItems(@Nonnull Player player, @Nullable Inventory inventory) {
        Inventory craftView = CompatUtils.getTopInventory(player);
        if (inventory != null && PlayerHandler.isCraftingInv(player)) {
            for (int k = 4; k >= 0; --k) {
                ItemStack item = inventory.getItem(k);
                if (item == null || item.getType() == Material.AIR) continue;
                craftView.setItem(k, item.clone());
            }
            PlayerHandler.updateInventory(player, 1L);
            return true;
        }
        if (!PlayerHandler.isCraftingInv(player)) {
            SchedulerUtils.runLater(60L, () -> ItemHandler.restoreCraftItems(player, inventory));
        }
        return false;
    }

    @Nonnull
    public static ItemStack[] cloneContents(@Nonnull ItemStack[] contents) {
        int itr = 0;
        for (ItemStack itemStack : contents) {
            if (contents[itr] != null) {
                contents[itr] = itemStack.clone();
            }
            ++itr;
        }
        return contents;
    }

    public static void restoreContents(@Nonnull Inventory inventory, @Nonnull ItemStack[] contents) {
        int size = Math.min(inventory.getSize(), contents.length);
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, contents[i] == null ? null : contents[i].clone());
        }
    }

    public static boolean isContentsEmpty(@Nonnull ItemStack[] contents) {
        int size = 0;
        for (ItemStack itemStack : contents) {
            if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) continue;
            ++size;
        }
        return size != contents.length;
    }

    @Nonnull
    public static String serializeInventory(@Nonnull Inventory inventory) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataStream = new BukkitObjectOutputStream((OutputStream)byteStream);
            dataStream.writeInt(inventory.getSize());
            for (int i = 0; i < inventory.getSize(); ++i) {
                dataStream.writeObject((Object)inventory.getItem(i));
            }
            dataStream.close();
            ByteArrayOutputStream compressedStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = new GZIPOutputStream(compressedStream);
            gzipStream.write(byteStream.toByteArray());
            gzipStream.close();
            return Base64.getEncoder().encodeToString(compressedStream.toByteArray());
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return "";
        }
    }

    @Nullable
    public static Inventory deserializeInventory(@Nonnull String inventoryData) {
        try {
            byte[] data = Base64.getDecoder().decode(inventoryData);
            if (data == null || data.length < 2) {
                return null;
            }
            if (data[0] == 31 && data[1] == -117) {
                int bytesRead;
                ByteArrayInputStream compressedStream = new ByteArrayInputStream(data);
                GZIPInputStream gzipStream = new GZIPInputStream(compressedStream);
                ByteArrayOutputStream decompressedStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = gzipStream.read(buffer)) != -1) {
                    decompressedStream.write(buffer, 0, bytesRead);
                }
                gzipStream.close();
                data = decompressedStream.toByteArray();
            }
            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            BukkitObjectInputStream dataStream = new BukkitObjectInputStream((InputStream)byteStream);
            Inventory inventory = Bukkit.createInventory(null, (int)dataStream.readInt());
            for (int i = 0; i < inventory.getSize(); ++i) {
                inventory.setItem(i, (ItemStack)dataStream.readObject());
            }
            dataStream.close();
            return inventory;
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ItemStack setNBTData(@Nullable ItemStack item, Object tag) {
        String string = "CC_NBT";
        synchronized ("CC_NBT") {
            if (Core.getCore().getData().dataTagsEnabled() && item != null && item.getType() != Material.AIR) {
                try {
                    Class<?> craftItemStack = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack");
                    Object nmsItem = craftItemStack.getMethod("asNMSCopy", ItemStack.class).invoke(null, item);
                    if (ServerUtils.hasPreciseUpdate("1_20_5")) {
                        Object customDataType = ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("DataComponents"), ReflectionUtils.MinecraftField.CustomData.getField()).get(null);
                        Object customData = ReflectionUtils.getMethod(ReflectionUtils.getMinecraftClass("CustomData"), ReflectionUtils.MinecraftMethod.of.getMethod(), ReflectionUtils.getMinecraftClass("NBTTagCompound")).invoke(new Object[]{null}, tag);
                        Object builder = ReflectionUtils.getMethod(ReflectionUtils.getMinecraftClass("DataComponentPatch"), ReflectionUtils.MinecraftMethod.builder.getMethod(), new Class[0]).invoke(new Object[]{null}, new Object[0]);
                        ReflectionUtils.getMethod(builder.getClass(), ReflectionUtils.MinecraftMethod.set.getMethod(), ReflectionUtils.getMinecraftClass("DataComponentType"), Object.class).invoke(builder, customDataType, customData);
                        Object componentPatch = ReflectionUtils.getMethod(builder.getClass(), ReflectionUtils.MinecraftMethod.build.getMethod(), new Class[0]).invoke(builder, new Object[0]);
                        ReflectionUtils.getMethod(nmsItem.getClass(), ReflectionUtils.MinecraftMethod.applyComponentsAndValidate.getMethod(), componentPatch.getClass()).invoke(nmsItem, componentPatch);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return (ItemStack)craftItemStack.getMethod("asCraftMirror", ReflectionUtils.getMinecraftClass("ItemStack")).invoke(null, nmsItem);
                    }
                    nmsItem.getClass().getMethod(ReflectionUtils.MinecraftMethod.setTag.getMethod(), tag.getClass()).invoke(nmsItem, tag);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return (ItemStack)ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asCraftMirror", nmsItem.getClass()).invoke(null, nmsItem);
                }
                catch (ConcurrentModificationException craftItemStack) {
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        ServerUtils.logSevere("{ItemHandler} An error has occurred when setting NBTData to an item, reason: " + e.getCause() + ".");
                        ServerUtils.sendSevereThrowable(e.getCause());
                    } else {
                        ServerUtils.logSevere("{ItemHandler} An error has occurred when setting NBTData to an item, reason: " + e.getMessage() + ".");
                    }
                    ServerUtils.sendSevereTrace(e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getNBTData(@Nullable ItemStack item, @Nonnull List<String> dataList) {
        String string = "CC_NBT";
        synchronized ("CC_NBT") {
            if (Core.getCore().getData().dataTagsEnabled() && item != null && item.getType() != Material.AIR) {
                try {
                    Object tag = null;
                    Class<?> itemClass = ReflectionUtils.getMinecraftClass("ItemStack");
                    ItemStack itemCopy = item.clone();
                    Object nms = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, itemCopy);
                    if (ServerUtils.hasPreciseUpdate("1_20_5")) {
                        Object componentMap = ReflectionUtils.getMethod(itemClass, ReflectionUtils.MinecraftMethod.getComponents.getMethod(), new Class[0]).invoke(nms, new Object[0]);
                        Object customDataType = ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("DataComponents"), ReflectionUtils.MinecraftField.CustomData.getField()).get(null);
                        Object customDataOptional = ReflectionUtils.getMethod(ReflectionUtils.getMinecraftClass(ServerUtils.hasPreciseUpdate("1_21_5") ? "DataComponentGetter" : "DataComponentMap"), ReflectionUtils.MinecraftMethod.get.getMethod(), ReflectionUtils.getMinecraftClass("DataComponentType")).invoke(componentMap, customDataType);
                        if (customDataOptional != null) {
                            tag = ReflectionUtils.getMethod(customDataOptional.getClass(), ReflectionUtils.MinecraftMethod.copyTag.getMethod(), new Class[0]).invoke(customDataOptional, new Object[0]);
                        }
                    } else {
                        tag = itemClass.getMethod(ReflectionUtils.MinecraftMethod.getTag.getMethod(), new Class[0]).invoke(nms, new Object[0]);
                    }
                    if (tag != null) {
                        StringBuilder returnData = new StringBuilder();
                        for (String dataString : dataList) {
                            String data = (String)(ServerUtils.hasPreciseUpdate("1_21_5") ? tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.getString.getMethod(), String.class, String.class).invoke(tag, dataString, null) : tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.getString.getMethod(), String.class).invoke(tag, dataString));
                            if (data == null || data.isEmpty()) continue;
                            returnData.append(data).append(" ");
                        }
                        if (returnData.toString().isEmpty()) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return null;
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return returnData.toString().trim();
                    }
                }
                catch (ConcurrentModificationException tag) {
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        ServerUtils.logSevere("{ItemHandler} An error has occurred when getting NBTData to an item, reason: " + e.getCause() + ".");
                        ServerUtils.sendSevereThrowable(e.getCause());
                    } else {
                        ServerUtils.logSevere("{ItemHandler} An error has occurred when getting NBTData to an item, reason: " + e.getMessage() + ".");
                    }
                    ServerUtils.sendSevereTrace(e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public static boolean containsNBTData(@Nonnull ItemStack item, @Nonnull List<String> dataList) {
        if (Core.getCore().getData().dataTagsEnabled() && item.getType() != Material.AIR && ItemHandler.getNBTData(item, dataList) != null) {
            return true;
        }
        if (!Core.getCore().getData().dataTagsEnabled()) {
            String colorDecode = StringUtils.colorDecode(item);
            return !colorDecode.isEmpty();
        }
        return false;
    }

    @Nonnull
    public static String getDesignatedSlot(@Nonnull Material material) {
        String hand;
        String name = material.name().contains("_") ? material.name().split("_")[1] : material.name();
        String string = hand = ServerUtils.hasSpecificUpdate("1_13") ? "hand" : "mainhand";
        return name != null ? (name.equalsIgnoreCase("HELMET") ? "head" : (name.equalsIgnoreCase("CHESTPLATE") ? "chest" : (name.equalsIgnoreCase("LEGGINGS") ? "legs" : (name.equalsIgnoreCase("BOOTS") ? "feet" : (name.equalsIgnoreCase("HOE") ? hand : (name.equalsIgnoreCase("SWORD") ? hand : (name.equalsIgnoreCase("SHOVEL") ? hand : (name.equalsIgnoreCase("AXE") ? hand : (name.equalsIgnoreCase("PICKAXE") ? hand : "noslot"))))))))) : "noslot";
    }

    public static boolean usesOwningPlayer() {
        try {
            ReflectionUtils.getCanonicalClass("org.bukkit.inventory.meta.SkullMeta");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Nonnull
    public static ItemStack setGlowing(@Nonnull ItemStack item) {
        Enchantment enchant = item.getType().name().equalsIgnoreCase("ENCHANTED_BOOK") ? ItemHandler.getEnchantByName("BINDING_CURSE") : (item.getType().name().equalsIgnoreCase("BOW") ? ItemHandler.getEnchantByName("LUCK") : ItemHandler.getEnchantByName("ARROW_INFINITE"));
        if (enchant != null) {
            item.addUnsafeEnchantment(enchant, 1);
        }
        return item;
    }

    public static int getDelay(@Nonnull String context) {
        try {
            Integer returnInt = StringUtils.returnInteger(context);
            if (returnInt != null) {
                return returnInt;
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        return 0;
    }

    @Nullable
    public static String getDelayFormat(@Nonnull String context) {
        if (StringUtils.containsIgnoreCase(context, "<delay:" + StringUtils.returnInteger(context) + ">") || StringUtils.containsIgnoreCase(context, "delay:" + StringUtils.returnInteger(context)) || StringUtils.containsIgnoreCase(context, "<delay: " + StringUtils.returnInteger(context) + ">") || StringUtils.containsIgnoreCase(context, "delay: " + StringUtils.returnInteger(context))) {
            return "<delay:" + StringUtils.returnInteger(context) + ">";
        }
        return null;
    }

    @Nonnull
    public static String cutDelay(@Nullable String context) {
        if (context == null) {
            return "";
        }
        String delayFormat = ItemHandler.getDelayFormat(context);
        if (delayFormat != null) {
            return context.replace(delayFormat, "");
        }
        return context;
    }

    @Nonnull
    public static List<String> cutDelay(@Nonnull List<String> context) {
        ArrayList<String> newContext = new ArrayList<String>();
        for (String minorContext : context) {
            newContext.add(ItemHandler.cutDelay(minorContext));
        }
        return newContext;
    }

    public static boolean containsJSONEvent(@Nonnull String formatPage) {
        return formatPage.contains(JSONEvent.TEXT.matchType) || formatPage.contains(JSONEvent.COLOR.matchType) || formatPage.contains(JSONEvent.SHOW_TEXT.matchType) || formatPage.contains(JSONEvent.OPEN_URL.matchType) || formatPage.contains(JSONEvent.RUN_COMMAND.matchType);
    }

    public static void safetyCheckURL(@Nonnull String itemName, @Nonnull JSONEvent type, @Nonnull String inputResult) {
        if (type.equals((Object)JSONEvent.OPEN_URL) && !StringUtils.containsIgnoreCase(inputResult, "https") && !StringUtils.containsIgnoreCase(inputResult, "http")) {
            ServerUtils.logSevere("{ItemHandler} The URL Specified for the clickable link in the book " + itemName + " is missing http or https and will not be clickable.");
            ServerUtils.logWarn("{ItemHandler} A URL designed for a clickable link should resemble this link structure: https://www.google.com/");
        }
    }

    public static boolean isCustomSlot(@Nonnull String slot) {
        return slot.equalsIgnoreCase("OFFHAND") || slot.equalsIgnoreCase("ARBITRARY") || ItemHandler.isArmor(slot) || ItemHandler.isCraftingSlot(slot) || slot.contains("%");
    }

    public static boolean isArmor(@Nonnull String context) {
        return StringUtils.containsIgnoreCase(context, "HELMET") || StringUtils.containsIgnoreCase(context, "CHESTPLATE") || StringUtils.containsIgnoreCase(context, "LEGGINGS") || StringUtils.containsIgnoreCase(context, "BOOTS");
    }

    public static boolean isCraftingSlot(@Nonnull String slot) {
        return StringUtils.getSlotConversion(slot) != -1;
    }

    public static boolean isSkull(@Nonnull Material material) {
        return material.toString().equalsIgnoreCase("SKULL_ITEM") || material.toString().equalsIgnoreCase("PLAYER_HEAD");
    }

    public static boolean isBookQuill(@Nonnull ItemStack item) {
        return item.getType().toString().equalsIgnoreCase("WRITABLE_BOOK") || item.getType().toString().equalsIgnoreCase("BOOK_AND_QUILL");
    }

    public static enum CustomSlot {
        HELMET("Helmet"),
        CHESTPLATE("Chestplate"),
        LEGGINGS("Leggings"),
        BOOTS("Boots"),
        OFFHAND("Offhand"),
        CRAFTING("Crafting"),
        ARBITRARY("Arbitrary");

        private final String name;

        private CustomSlot(String name) {
            this.name = name;
        }

        public boolean isSlot(@Nonnull String slot) {
            return this.name.equalsIgnoreCase(slot);
        }
    }

    public static enum JSONEvent {
        TEXT("nullEvent", "text", "<text:"),
        COLOR("nullEvent", "color", "<color:"),
        SHOW_TEXT("hoverEvent", "show_text", "<show_text:"),
        OPEN_URL("clickEvent", "open_url", "<open_url:"),
        RUN_COMMAND("clickEvent", "run_command", "<run_command:"),
        CHANGE_PAGE("clickEvent", "change_page", "<change_page:");

        public final String event;
        public final String action;
        public final String matchType;

        private JSONEvent(@Nonnull String Event2, String Action2, String MatchType) {
            this.event = Event2;
            this.action = Action2;
            this.matchType = MatchType;
        }
    }

    public static enum TrimMaterial {
        AMETHYST("AMETHYST_SHARD"),
        COPPER("COPPER_INGOT"),
        DIAMOND("DIAMOND"),
        EMERALD("EMERALD"),
        GOLD("GOLD_INGOT"),
        IRON("IRON_INGOT"),
        LAPIS("LAPIS_LAZULI"),
        NETHERITE("NETHERITE_INGOT"),
        QUARTZ("QUARTZ"),
        REDSTONE("REDSTONE"),
        RESIN("RESIN_BRICK");

        private final String name;

        private TrimMaterial(String name) {
            this.name = name;
        }

        public Material getMaterial() {
            return ItemHandler.getMaterial(this.name, null);
        }
    }
}

