/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

public class LogHandler
extends AbstractFilter {
    private static LogHandler filter;
    private final HashMap<String, ArrayList<String>> hiddenExecutors = new HashMap();

    @Nonnull
    public static LogHandler getFilter() {
        if (filter == null) {
            filter = new LogHandler();
            ((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration().getLoggerConfig("").addFilter((Filter)filter);
        }
        return filter;
    }

    @Nonnull
    private Filter.Result handle(String message) {
        if (message == null) {
            return Filter.Result.NEUTRAL;
        }
        if (!this.hiddenExecutors.isEmpty() && this.hiddenExecutors.containsKey("commands-list")) {
            for (String word : this.hiddenExecutors.get("commands-list")) {
                if (!message.toLowerCase().contains(word.toLowerCase())) continue;
                return Filter.Result.DENY;
            }
        }
        return Filter.Result.NEUTRAL;
    }

    @Nonnull
    public Filter.Result filter(@Nonnull LogEvent event) {
        return this.handle(event.getMessage().getFormattedMessage());
    }

    @Nonnull
    public Filter.Result filter(@Nonnull Logger logger, @Nonnull Level level, @Nonnull Marker marker, Message msg, Throwable t) {
        return this.handle(msg.getFormattedMessage());
    }

    @Nonnull
    public Filter.Result filter(@Nonnull Logger logger, @Nonnull Level level, @Nonnull Marker marker, Object msg, Throwable t) {
        return this.handle(msg.toString());
    }

    @Nonnull
    public Filter.Result filter(@Nonnull Logger logger, @Nonnull Level level, @Nonnull Marker marker, String msg, Object ... params) {
        return this.handle(msg);
    }

    public void addHidden(@Nonnull String log, @Nonnull ArrayList<String> logList) {
        this.hiddenExecutors.put(log, logList);
    }

    @Nonnull
    public HashMap<String, ArrayList<String>> getHidden() {
        return this.hiddenExecutors;
    }

    public void refresh() {
        filter = new LogHandler();
        ((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration().getLoggerConfig("").addFilter((Filter)filter);
    }
}

