/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public abstract class ChatComponent {
    public static TextSection of(@Nonnull String text) {
        return new TextSection(true, true, null).setText(text);
    }

    public static void sendTo(@Nonnull TextSection text, Player player) {
        try {
            if (ServerUtils.hasPreciseUpdate("1_21_6")) {
                player.spigot().sendMessage(ComponentSerializer.parse((String)text.toString()));
            } else {
                Object craftPlayer = ReflectionUtils.getEntity(player);
                if (craftPlayer != null) {
                    Object connection = ReflectionUtils.getFieldValue(craftPlayer, ReflectionUtils.MinecraftField.PlayerConnection.getField());
                    Method sendPacket = connection.getClass().getMethod(ReflectionUtils.MinecraftMethod.sendPacket.getMethod(), ReflectionUtils.getMinecraftClass("Packet"));
                    Object textComponent = ChatComponent.getComponent(text, player);
                    Object packet = ChatComponent.createPacket(textComponent, player);
                    sendPacket.invoke(connection, packet);
                }
            }
        }
        catch (Exception e) {
            player.sendMessage(text.getText());
        }
    }

    @Nonnull
    private static Object getComponent(TextSection text, @Nonnull Player player) throws Exception {
        Class<?> serializer = ReflectionUtils.getMinecraftClass("IChatBaseComponent$ChatSerializer");
        if (ServerUtils.hasPreciseUpdate("1_20_5")) {
            Object craftServer = ReflectionUtils.invokeMethod("getHandle", player.getServer());
            Object mineServer = ReflectionUtils.invokeMethod(ReflectionUtils.MinecraftMethod.getServer.getMethod(), craftServer);
            Object registryAccess = ReflectionUtils.invokeMethod(ReflectionUtils.MinecraftMethod.registryAccess.getMethod(), mineServer);
            return serializer.getDeclaredMethod("a", String.class, ReflectionUtils.getMinecraftClass("HolderLookup$a")).invoke(null, text.toString(), registryAccess);
        }
        return serializer.getDeclaredMethod("a", String.class).invoke(null, text.toString());
    }

    @Nonnull
    private static Constructor<?> getPacketConstructor(@Nonnull Player player) throws Exception {
        Constructor<?> packetConstructor;
        Class<?> baseComponent = ReflectionUtils.getMinecraftClass("IChatBaseComponent");
        Class<?> chatPacket = ReflectionUtils.getMinecraftClass(ServerUtils.hasSpecificUpdate("1_19") ? "ClientboundSystemChatPacket" : "PacketPlayOutChat");
        if (ServerUtils.hasPreciseUpdate("1_20_5") || ServerUtils.hasSpecificUpdate("1_19")) {
            try {
                packetConstructor = chatPacket.getConstructor(baseComponent, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                packetConstructor = chatPacket.getConstructor(baseComponent, Boolean.TYPE);
            }
        } else if (ServerUtils.hasSpecificUpdate("1_16")) {
            Class<?> messageType = ReflectionUtils.getMinecraftClass("ChatMessageType");
            packetConstructor = chatPacket.getConstructor(baseComponent, messageType, player.getUniqueId().getClass());
        } else {
            packetConstructor = chatPacket.getConstructor(baseComponent);
        }
        return packetConstructor;
    }

    @Nonnull
    private static Object createPacket(@Nonnull Object textComponent, @Nonnull Player player) throws Exception {
        Object packet;
        Constructor<?> packetConstructor = ChatComponent.getPacketConstructor(player);
        int parameterCount = packetConstructor.getParameterCount();
        if (parameterCount == 3) {
            Class<?> chatMessageTypeClass = ReflectionUtils.getMinecraftClass("ChatMessageType");
            Object chatMessageType = chatMessageTypeClass.getMethod("a", Byte.TYPE).invoke(null, (byte)0);
            packet = packetConstructor.newInstance(textComponent, chatMessageType, player.getUniqueId());
        } else {
            packet = parameterCount == 2 ? (packetConstructor.getParameterTypes()[1] == Integer.TYPE ? packetConstructor.newInstance(textComponent, 0) : packetConstructor.newInstance(textComponent, false)) : packetConstructor.newInstance(textComponent);
        }
        return packet;
    }

    public static class TextSection
    extends ChatComponent {
        private final boolean isParent;
        private final boolean canHaveEvents;
        private final Gson gson = new Gson();
        private String text = "";
        private String insertion;
        private TextSection parent;
        private HoverEvent hoverEvent;
        private ClickEvent clickEvent;
        private ChatColor color = ServerUtils.hasPreciseUpdate("1_20_3") ? ChatColor.WHITE : ChatColor.RESET;
        private List<TextSection> extra;
        private boolean bold = false;
        private boolean italics = false;
        private boolean underline = false;
        private boolean obfuscated = false;
        private boolean strikethrough = false;

        private TextSection(boolean events, boolean isParent, @Nullable TextSection parent) {
            this.canHaveEvents = events;
            this.isParent = isParent;
            if (!isParent) {
                this.parent = parent;
            } else {
                this.extra = new ArrayList<TextSection>();
            }
        }

        public final void sendTo(@Nonnull Player player) {
            TextSection.sendTo(this, player);
        }

        @Nonnull
        public final TextSection append(@Nonnull String text) {
            TextSection section = new TextSection(true, false, this.getParent()).setText(text);
            this.getExtra().add(section);
            return section;
        }

        @Nonnull
        public final TextSection append(@Nonnull Consumer<TextSection> consumer) {
            TextSection section = new TextSection(true, false, this.getParent());
            consumer.accept(section);
            this.getExtra().add(section);
            return this;
        }

        @Nonnull
        public final TextSection append(@Nonnull TextSection textSection) {
            this.getExtra().add(textSection.getParent());
            return this;
        }

        @Nonnull
        public TextSection setColor(@Nonnull ChatColor color) {
            if (21 > color.ordinal() && color.ordinal() > 15) {
                return this;
            }
            this.color = color;
            return this;
        }

        @Nonnull
        public TextSection setBold(boolean bold) {
            this.bold = bold;
            return this;
        }

        @Nonnull
        public TextSection setItalics(boolean italics) {
            this.italics = italics;
            return this;
        }

        @Nonnull
        public TextSection setUnderlined(boolean underline) {
            this.underline = underline;
            return this;
        }

        @Nonnull
        public TextSection setObfuscated(boolean obfuscated) {
            this.obfuscated = obfuscated;
            return this;
        }

        @Nonnull
        public TextSection setStrikethrough(boolean strikethrough) {
            this.strikethrough = strikethrough;
            return this;
        }

        @Nonnull
        public TextSection shiftClickEvent(@Nonnull String insertion) {
            if (!this.canHaveEvents) {
                return this;
            }
            this.insertion = insertion;
            return this;
        }

        @Nonnull
        public TextSection hoverEvent(@Nonnull Consumer<HoverEvent> hoverEvent) {
            if (!this.canHaveEvents) {
                return this;
            }
            this.hoverEvent = new HoverEvent(this.parent);
            hoverEvent.accept(this.hoverEvent);
            return this;
        }

        public void hoverEvent(@Nonnull HoverEvent hoverEvent) {
            if (!this.canHaveEvents) {
                return;
            }
            this.hoverEvent = hoverEvent;
        }

        @Nonnull
        public TextSection clickEvent(@Nonnull Consumer<ClickEvent> clickEvent) {
            if (!this.canHaveEvents) {
                return this;
            }
            this.clickEvent = new ClickEvent();
            clickEvent.accept(this.clickEvent);
            return this;
        }

        public void clickEvent(@Nonnull ClickEvent clickEvent) {
            if (!this.canHaveEvents) {
                return;
            }
            this.clickEvent = clickEvent;
        }

        public final boolean isParent() {
            return this.isParent;
        }

        @Nonnull
        public List<TextSection> getExtra() {
            if (this.isParent) {
                return this.extra;
            }
            return this.getParent().getExtra();
        }

        @Nonnull
        public String getText() {
            return this.text;
        }

        @Nonnull
        public TextSection setText(@Nonnull String text) {
            this.text = text;
            return this;
        }

        @Nonnull
        public final TextSection getParent() {
            if (this.isParent) {
                return this;
            }
            return this.parent;
        }

        @Nonnull
        public JsonObject getJson() {
            JsonObject hover = null;
            if (this.hoverEvent != null && this.canHaveEvents) {
                hover = new JsonObject();
                ArrayList<JsonObject> val = new ArrayList<JsonObject>();
                val.add(this.hoverEvent.getHover().getJson());
                hover.addProperty("action", this.hoverEvent.getAction().toString().toLowerCase());
                hover.add("value", this.gson.toJsonTree(val));
            }
            JsonObject click = null;
            if (this.clickEvent != null && this.canHaveEvents) {
                click = new JsonObject();
                click.addProperty("action", this.clickEvent.getAction().toString().toLowerCase());
                click.addProperty("value", this.clickEvent.getClick());
            }
            JsonObject json = this.getJsonObject();
            if (hover != null) {
                json.add("hoverEvent", (JsonElement)hover);
            }
            if (click != null) {
                json.add("clickEvent", (JsonElement)click);
            }
            if (this.isParent && !this.extra.isEmpty()) {
                ArrayList<JsonObject> sections = new ArrayList<JsonObject>();
                for (TextSection section : this.extra) {
                    sections.add(section.getJson());
                }
                json.add("extra", this.gson.toJsonTree(sections));
            }
            return json;
        }

        @Nonnull
        private JsonObject getJsonObject() {
            JsonObject json = new JsonObject();
            json.addProperty("text", this.text);
            json.addProperty("color", this.color.name().toLowerCase());
            if (this.bold) {
                json.addProperty("bold", Boolean.valueOf(true));
            }
            if (this.italics) {
                json.addProperty("italic", Boolean.valueOf(true));
            }
            if (this.underline) {
                json.addProperty("underlined", Boolean.valueOf(true));
            }
            if (this.obfuscated) {
                json.addProperty("obfuscated", Boolean.valueOf(true));
            }
            if (this.insertion != null) {
                json.addProperty("insertion", this.insertion);
            }
            if (this.strikethrough) {
                json.addProperty("strikethrough", Boolean.valueOf(true));
            }
            return json;
        }

        @Nonnull
        public String getFormatted() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.bold) {
                stringBuilder.append(ChatColor.BOLD);
            }
            if (this.italics) {
                stringBuilder.append(ChatColor.ITALIC);
            }
            if (this.underline) {
                stringBuilder.append(ChatColor.UNDERLINE);
            }
            if (this.strikethrough) {
                stringBuilder.append(ChatColor.STRIKETHROUGH);
            }
            stringBuilder.append(this.color);
            stringBuilder.append(this.text);
            if (this.isParent && !this.extra.isEmpty()) {
                this.getExtra().forEach(textSection -> stringBuilder.append(textSection.getFormatted()));
            }
            return stringBuilder.toString();
        }

        @Nonnull
        public String toString() {
            if (this.isParent) {
                return this.getJson().toString();
            }
            return this.parent.getJson().toString();
        }

        @Nonnull
        public String toUnformatted() {
            StringBuilder builder = new StringBuilder();
            this.getParent().getSections().stream().map(TextSection::getText).forEach(builder::append);
            return builder.toString();
        }

        @Nonnull
        public List<TextSection> getSections() {
            ArrayList<TextSection> sections = new ArrayList<TextSection>(this.getParent().getExtra());
            sections.add(0, this.getParent());
            return sections;
        }
    }

    public static class ClickEvent {
        private ClickAction action = ClickAction.SUGGEST_COMMAND;
        private String click;

        public void action(@Nonnull ClickAction action) {
            this.action = action;
        }

        @Nonnull
        public ClickAction getAction() {
            return this.action;
        }

        public void click(@Nonnull String click) {
            this.click = click;
        }

        @Nonnull
        public String getClick() {
            return this.click;
        }
    }

    public static class HoverEvent {
        private final TextSection text;
        private HoverAction action = HoverAction.SHOW_TEXT;

        public HoverEvent(@Nonnull TextSection parent) {
            this.text = parent;
        }

        public final void action(@Nonnull HoverAction action) {
            this.action = action;
        }

        @Nonnull
        public final HoverAction getAction() {
            return this.action;
        }

        @Nonnull
        public final TextSection getHover() {
            return this.text;
        }
    }

    public static enum ClickAction {
        OPEN_URL,
        RUN_COMMAND,
        SUGGEST_COMMAND,
        CHANGE_PAGE;

    }

    public static enum HoverAction {
        SHOW_TEXT,
        SHOW_ITEM,
        SHOW_ENTITY;

    }
}

