/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CompatUtils {
    @Nonnull
    public static Object getOpenInventory(@Nonnull Object object) {
        try {
            Method getOpenInventory = object.getClass().getMethod("getOpenInventory", new Class[0]);
            getOpenInventory.setAccessible(true);
            return getOpenInventory.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with Player#getOpenInventory!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    @Nonnull
    public static Inventory getTopInventory(@Nonnull Object object) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method getTopInventory = view.getClass().getMethod("getTopInventory", new Class[0]);
            getTopInventory.setAccessible(true);
            return (Inventory)getTopInventory.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#getTopInventory!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    @Nonnull
    public static Inventory getBottomInventory(@Nonnull Object object) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method getBottomInventory = view.getClass().getMethod("getBottomInventory", new Class[0]);
            getBottomInventory.setAccessible(true);
            return (Inventory)getBottomInventory.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#getBottomInventory!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    @Nonnull
    public static Player getPlayer(@Nonnull Object object) {
        try {
            Object view = object instanceof InventoryEvent ? object.getClass().getMethod("getView", new Class[0]).invoke(object, new Object[0]) : object;
            Method getPlayer = view.getClass().getMethod("getPlayer", new Class[0]);
            getPlayer.setAccessible(true);
            return (Player)getPlayer.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#getPlayer!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    @Nonnull
    public static String getInventoryTitle(@Nonnull Object object) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method getTitle = view.getClass().getMethod("getTitle", new Class[0]);
            getTitle.setAccessible(true);
            return (String)getTitle.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#getTitle!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    @Nonnull
    public static InventoryType getInventoryType(@Nonnull Object object) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method getType = view.getClass().getMethod("getType", new Class[0]);
            getType.setAccessible(true);
            return (InventoryType)getType.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#getType!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    @Nonnull
    public static ItemStack getCursor(@Nonnull Object object) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method getCursor = view.getClass().getMethod("getCursor", new Class[0]);
            getCursor.setAccessible(true);
            return (ItemStack)getCursor.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#getCursor!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    public static void setCursor(@Nonnull Object object, @Nonnull ItemStack itemStack) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method setCursor = view.getClass().getMethod("setCursor", ItemStack.class);
            setCursor.setAccessible(true);
            setCursor.invoke(view, itemStack);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#setCursor!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    @Nonnull
    public static ItemStack getItem(@Nonnull Object object, int slot) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method getCursor = view.getClass().getMethod("getItem", Integer.TYPE);
            getCursor.setAccessible(true);
            return (ItemStack)getCursor.invoke(view, slot);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#getItem!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    public static void setItem(@Nonnull Object object, @Nonnull ItemStack itemStack, int slot) {
        try {
            Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : (object instanceof InventoryEvent ? ((InventoryEvent)object).getView() : object);
            Method setItem = view.getClass().getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItem.setAccessible(true);
            setItem.invoke(view, slot, itemStack);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{CompatUtils} An error has occurred with InventoryView#setItem!");
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException(object.getClass().getName(), e);
        }
    }

    public static NamespacedKey getKey(@Nonnull Object object) {
        return (NamespacedKey)CompatUtils.resolveByVersion("1_21_4", () -> {
            try {
                return object.getClass().getMethod("getKeyOrThrow", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception e) {
                try {
                    return object.getClass().getMethod("getKey", new Class[0]).invoke(object, new Object[0]);
                }
                catch (Exception ex) {
                    throw new RuntimeException("{CompatUtils} Unable to #getKeyOrThrow for class: " + object.getClass().getName());
                }
            }
        }, () -> {
            try {
                return object.getClass().getMethod("getKey", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("{CompatUtils} Unable to #getKey for class: " + object.getClass().getName());
            }
        });
    }

    public static String getName(@Nonnull Object object) {
        if (ServerUtils.hasSpecificUpdate("1_9") && object instanceof Attribute) {
            return ((String)CompatUtils.resolveByVersion("1_21", () -> CompatUtils.getKey(object).getKey(), () -> LegacyAPI.getAttributeName(object))).toUpperCase();
        }
        if (object instanceof Sound) {
            return ((String)CompatUtils.resolveByVersion("1_21", () -> CompatUtils.getKey(object).getKey(), () -> LegacyAPI.getSoundName(object))).toUpperCase();
        }
        if (object instanceof Pattern) {
            return ((String)CompatUtils.resolveByVersion("1_21", () -> CompatUtils.getKey(((Pattern)object).getPattern()).getKey(), () -> LegacyAPI.getPatternName(((Pattern)object).getPattern()))).toUpperCase();
        }
        if (object instanceof PatternType) {
            return ((String)CompatUtils.resolveByVersion("1_21", () -> CompatUtils.getKey(object).getKey(), () -> LegacyAPI.getPatternName(object))).toUpperCase();
        }
        if (object instanceof PotionEffect) {
            return ((String)CompatUtils.resolveByVersion("1_20_3", () -> CompatUtils.getKey(((PotionEffect)object).getType()).getKey(), () -> LegacyAPI.getEffectName(((PotionEffect)object).getType()))).toUpperCase();
        }
        if (object instanceof PotionEffectType) {
            return ((String)CompatUtils.resolveByVersion("1_20_3", () -> CompatUtils.getKey(object).getKey(), () -> LegacyAPI.getEffectName(object))).toUpperCase();
        }
        throw new RuntimeException("{CompatUtils} Unable to get name of an unknown class: " + object.getClass().getName());
    }

    public static <T> List<T> values(@Nonnull Class<T> clazz) {
        if (ServerUtils.hasSpecificUpdate("1_9") && clazz.equals(Attribute.class)) {
            return (List)CompatUtils.resolveByVersion("1_21_3", () -> ImmutableList.copyOf((Iterator)Registry.ATTRIBUTE.iterator()), LegacyAPI::getAttributes);
        }
        if (clazz.equals(Sound.class)) {
            return (List)CompatUtils.resolveByVersion("1_21_3", () -> ImmutableList.copyOf((Iterator)Registry.SOUNDS.iterator()), LegacyAPI::getSounds);
        }
        if (clazz.equals(PatternType.class)) {
            return (List)CompatUtils.resolveByVersion("1_21", () -> ImmutableList.copyOf((Iterator)Registry.BANNER_PATTERN.iterator()), LegacyAPI::getPatterns);
        }
        if (clazz.equals(PotionEffectType.class)) {
            return (List)CompatUtils.resolveByVersion("1_20_3", () -> ImmutableList.copyOf((Iterator)Registry.EFFECT.iterator()), LegacyAPI::getEffects);
        }
        if (clazz.equals(Enchantment.class)) {
            return (List)CompatUtils.resolveByVersion("1_20_3", () -> ImmutableList.copyOf((Iterator)Registry.ENCHANTMENT.iterator()), LegacyAPI::getEnchants);
        }
        throw new RuntimeException("{CompatUtils} Unable to get values of an unknown class: " + clazz.getName());
    }

    public static <T> Object valueOf(@Nonnull Class<T> clazz, @Nonnull String clazzName) {
        if (ServerUtils.hasSpecificUpdate("1_9") && clazz.equals(Attribute.class)) {
            return CompatUtils.resolveByVersion("1_21_3", () -> Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)clazzName.toLowerCase().replace("generic_", ""))), () -> LegacyAPI.getAttribute(clazzName));
        }
        if (clazz.equals(Sound.class)) {
            return CompatUtils.resolveByVersion("1_21_3", () -> Registry.SOUNDS.get(NamespacedKey.minecraft((String)clazzName.toLowerCase())), () -> LegacyAPI.getSound(clazzName));
        }
        throw new RuntimeException("{CompatUtils} Unable to get values of an unknown class: " + clazz.getName() + " with the value: " + clazzName);
    }

    public static boolean isInventoryEmpty(@Nonnull Inventory inventory) {
        try {
            Method isEmpty = inventory.getClass().getMethod("isEmpty", new Class[0]);
            if (isEmpty != null) {
                return (Boolean)isEmpty.invoke((Object)inventory, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public static void setDummyAttributes(ItemMeta itemMeta) {
        if (ServerUtils.hasPreciseUpdate("1_20_5") && ServerUtils.isPaper() && itemMeta.getAttributeModifiers() == null) {
            itemMeta.setAttributeModifiers((Multimap)HashMultimap.create());
        }
    }

    public static Object resolveByVersion(String updateVersion, Supplier<Object> modernGetter, Supplier<Object> legacyGetter) {
        try {
            return ServerUtils.hasPreciseUpdate(updateVersion) ? (modernGetter.get() != null ? modernGetter.get() : legacyGetter.get()) : legacyGetter.get();
        }
        catch (Throwable t) {
            return legacyGetter.get();
        }
    }
}

