/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class StringUtils {
    public static boolean conditionMet(@Nullable String condition, @Nullable String operand, @Nullable String value) {
        if (operand == null) {
            return false;
        }
        if (operand.equalsIgnoreCase("EQUAL") && (condition != null && condition.equalsIgnoreCase(value) || condition == null && value == null)) {
            return true;
        }
        if (operand.equalsIgnoreCase("NOTEQUAL") && (condition != null && value != null && !condition.equalsIgnoreCase(value) || condition == null && value != null || condition != null && value == null)) {
            return true;
        }
        if (operand.equalsIgnoreCase("OVER") && StringUtils.isInt(condition) && StringUtils.isInt(value) && Integer.parseInt(condition) > Integer.parseInt(value)) {
            return true;
        }
        return operand.equalsIgnoreCase("UNDER") && StringUtils.isInt(condition) && StringUtils.isInt(value) && Integer.parseInt(condition) < Integer.parseInt(value);
    }

    public static boolean containsIgnoreCase(@Nullable String string1, String ... string2) {
        if (string1 == null || string2 == null) {
            return false;
        }
        for (String argument : string2) {
            if (argument == null || !string1.toLowerCase().contains(argument.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean splitIgnoreCase(@Nullable String string1, @Nullable String string2, @Nullable String argument) {
        if (string1 == null || string2 == null || argument == null) {
            return false;
        }
        String[] parts = string1.split(argument);
        boolean splitParts = string1.contains(argument);
        for (int i = 0; i < (splitParts ? parts.length : 1); ++i) {
            if ((!splitParts || parts[i] == null || !parts[i].toLowerCase().replace(" ", "").equalsIgnoreCase(string2.replace(" ", "").toLowerCase())) && (splitParts || !string1.toLowerCase().replace(" ", "").equalsIgnoreCase(string2.toLowerCase().replace(" ", "")))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsValue(@Nonnull List<?> list, @Nonnull String str) {
        boolean bool = false;
        for (Object l : list) {
            if (!l.toString().equalsIgnoreCase(str)) continue;
            bool = true;
            break;
        }
        return bool;
    }

    @Nonnull
    public static String[] softSplit(@Nonnull String str) {
        if (str.split(", ").length < 3) {
            return str.split("` ");
        }
        StringBuilder splitTest = new StringBuilder();
        int index = 1;
        for (String sd : str.split(", ")) {
            if (index == 3) {
                splitTest.append(sd).append("` ");
                index = 1;
                continue;
            }
            splitTest.append(sd).append(", ");
            ++index;
        }
        if (splitTest.toString().endsWith(", ")) {
            splitTest = new StringBuilder(splitTest.substring(0, splitTest.length() - 2));
        }
        return splitTest.toString().split("` ");
    }

    @Nonnull
    public static List<String> split(@Nonnull String str) {
        return new ArrayList<String>(Arrays.asList(str.split(", ")));
    }

    public static boolean isEmpty(@Nonnull StringBuilder stringBuilder) {
        return stringBuilder.toString().isEmpty();
    }

    @Nonnull
    public static String locationToString(@Nonnull Location location) {
        return location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getYaw() + "," + location.getPitch();
    }

    @Nonnull
    public static String replaceLast(@Nonnull String str, @Nonnull String sub1, @Nonnull String sub2) {
        int pos = str.lastIndexOf(sub1);
        if (pos > -1) {
            return str.substring(0, pos) + sub2 + str.substring(pos + sub1.length());
        }
        return str;
    }

    @Nonnull
    public static ItemStack colorEncode(@Nonnull ItemStack itemStack, @Nonnull String endData) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (ServerUtils.hasSpecificUpdate("1_14") && itemMeta != null) {
            NamespacedKey key = new NamespacedKey((Plugin)Core.getCore().getPlugin(), "Item_Data");
            itemMeta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)endData);
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        if (itemMeta != null) {
            String encodedData = LegacyAPI.colorEncode(Core.getCore().getPlugin().getName() + endData);
            itemMeta.setDisplayName(encodedData);
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        return itemStack;
    }

    @Nonnull
    public static String colorDecode(@Nonnull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (ServerUtils.hasSpecificUpdate("1_14") && itemMeta != null) {
            NamespacedKey key = new NamespacedKey((Plugin)Core.getCore().getPlugin(), "Item_Data");
            PersistentDataContainer container = itemMeta.getPersistentDataContainer();
            if (container.has(key, PersistentDataType.STRING)) {
                String decoded = (String)container.get(key, PersistentDataType.STRING);
                if (decoded != null) {
                    return decoded;
                }
                return "";
            }
        } else if (itemMeta != null && itemMeta.hasDisplayName()) {
            return LegacyAPI.colorDecode(itemMeta.getDisplayName());
        }
        return "";
    }

    @Nonnull
    public static Color getColorFromHexColor(@Nonnull String hexString) {
        int hex = Integer.decode("#" + hexString.replace("#", ""));
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return Color.fromRGB((int)r, (int)g, (int)b);
    }

    public static int countCharacters(@Nullable String str) {
        int count = 0;
        if (str == null) {
            return count;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    public static int countCharacters(@Nullable String str, @Nonnull String character) {
        return str != null ? str.length() - str.replace(character, "").length() : 0;
    }

    public static long ticksToMillis(long ticks) {
        return TimeUnit.MILLISECONDS.convert(ticks * 50L, TimeUnit.MILLISECONDS);
    }

    public static boolean isInt(@Nullable String str) {
        if (str == null) {
            return false;
        }
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(@Nullable String str) {
        if (str == null) {
            return false;
        }
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Integer returnInteger(@Nullable String str) {
        if (str == null) {
            return null;
        }
        char[] characters = str.toCharArray();
        Integer value = null;
        boolean isPrevDigit = false;
        for (char character : characters) {
            if (!isPrevDigit) {
                if (!Character.isDigit(character)) continue;
                isPrevDigit = true;
                value = Character.getNumericValue(character);
                continue;
            }
            if (!Character.isDigit(character)) break;
            value = value * 10 + Character.getNumericValue(character);
        }
        return value;
    }

    @Nullable
    public static UUID UUIDConversion(@Nonnull String uuidString) {
        UUID uuid = null;
        if (!uuidString.isEmpty()) {
            uuidString = uuidString.replace("-", "");
            uuid = new UUID(new BigInteger(uuidString.substring(0, 16), 16).longValue(), new BigInteger(uuidString.substring(16), 16).longValue());
        }
        return uuid;
    }

    @Nonnull
    public static String toString(@Nonnull BufferedReader reader) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    @Nonnull
    public static String toTexture64(@Nonnull String url) {
        if (!(StringUtils.containsIgnoreCase(url = ItemHandler.cutDelay(url.replace("url-", "")), "minecraft.net") || StringUtils.containsIgnoreCase(url, "http") || StringUtils.containsIgnoreCase(url, "https"))) {
            url = "https://textures.minecraft.net/texture/" + url;
        }
        URI actualUrl = null;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            ServerUtils.logSevere("{StringUtils} Unable to reach the url " + url + " for a skull-texture.");
            ServerUtils.logSevere("{StringUtils} " + e.getReason());
        }
        if (actualUrl != null) {
            url = "{\"textures\":{\"SKIN\":{\"url\":\"" + actualUrl + "\"}}}";
        }
        return Base64.getEncoder().encodeToString(url.getBytes());
    }

    public static URI toTextureURI(@Nonnull String texture) {
        try {
            if (!(StringUtils.containsIgnoreCase(texture, "minecraft.net") || StringUtils.containsIgnoreCase(texture, "http") || StringUtils.containsIgnoreCase(texture, "https"))) {
                String decoded = new String(Base64.getDecoder().decode(texture));
                JSONObject textureObject = (JSONObject)JSONValue.parseWithException((String)decoded);
                return new URI(((JSONObject)((JSONObject)textureObject.get((Object)"textures")).get((Object)"SKIN")).get((Object)"url").toString());
            }
            return new URI(texture);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return null;
        }
    }

    @Nonnull
    public static String toTextureUUID(@Nonnull Player player, @Nonnull String configName, @Nonnull String skullTexture) {
        if (StringUtils.containsIgnoreCase(skullTexture, "uuid")) {
            String https = "https://sessionserver.mojang.com/session/minecraft/profile/" + StringUtils.translateLayout(skullTexture, player, new PlaceHolder[0]).replace("uuid-", "").replace("uuid", "");
            try {
                String valueResult;
                URL url = new URL(https);
                BufferedReader read = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuffer stringBuilder = new StringBuffer();
                while ((valueResult = read.readLine()) != null) {
                    if (!StringUtils.containsIgnoreCase(valueResult, "value")) continue;
                    stringBuilder.append(valueResult);
                }
                Matcher m = Pattern.compile("\"([^\"]*)\"").matcher(stringBuilder);
                while (m.find()) {
                    String stringValue = m.group(1);
                    if (StringUtils.containsIgnoreCase(stringValue, "value")) continue;
                    valueResult = stringValue;
                }
                return valueResult != null ? valueResult : skullTexture.replace("uuid-", "").replace("uuid", "");
            }
            catch (IOException e) {
                ServerUtils.logSevere("{StringUtils} Unable to connect to " + https);
                ServerUtils.logSevere("{StringUtils} " + e.getMessage());
                ServerUtils.logSevere("{StringUtils} The item " + configName + " will NOT have its skull-texture set!");
            }
        }
        return skullTexture.replace("uuid-", "").replace("uuid", "");
    }

    @Nonnull
    public static String encrypt(@Nonnull String str) {
        return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    @Nonnull
    public static String decrypt(@Nonnull String str) {
        return new String(Base64.getDecoder().decode(str), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static Map<StringBuilder, Integer> getSpacers(int lower, int upper, int comparator) {
        StringBuilder spaces = new StringBuilder();
        int sNum = StringUtils.getRandom(0, 5);
        while (comparator == sNum) {
            sNum = StringUtils.getRandom(0, 5);
        }
        for (int s = 0; s <= sNum; ++s) {
            spaces.append(" ");
        }
        return Collections.singletonMap(spaces, sNum);
    }

    public static int getRandom(int lower, int upper) {
        return new Random().nextInt(upper - lower + 1) + lower;
    }

    @Nonnull
    public static Object randomEntry(ArrayList<?> list) {
        Random rand = new Random();
        return list.get(rand.nextInt(list.size()));
    }

    public static boolean containsLocation(@Nonnull String location, @Nonnull String str) {
        if (str.equalsIgnoreCase("ALL") || str.equalsIgnoreCase("GLOBAL") || str.equalsIgnoreCase("ENABLED") || str.equalsIgnoreCase("TRUE")) {
            return true;
        }
        for (String eventLoc : str.split(",")) {
            if (!eventLoc.equalsIgnoreCase(location)) continue;
            return true;
        }
        return false;
    }

    public static int getSlotConversion(@Nonnull String str) {
        if (str.equalsIgnoreCase("CRAFTING[0]") || str.equalsIgnoreCase("C[0]") || str.equalsIgnoreCase("CRAFTING(0)") || str.equalsIgnoreCase("C(0)")) {
            return 0;
        }
        if (str.equalsIgnoreCase("CRAFTING[1]") || str.equalsIgnoreCase("C[1]") || str.equalsIgnoreCase("CRAFTING(1)") || str.equalsIgnoreCase("C(1)")) {
            return 1;
        }
        if (str.equalsIgnoreCase("CRAFTING[2]") || str.equalsIgnoreCase("C[2]") || str.equalsIgnoreCase("CRAFTING(2)") || str.equalsIgnoreCase("C(2)")) {
            return 2;
        }
        if (str.equalsIgnoreCase("CRAFTING[3]") || str.equalsIgnoreCase("C[3]") || str.equalsIgnoreCase("CRAFTING(3)") || str.equalsIgnoreCase("C(3)")) {
            return 3;
        }
        if (str.equalsIgnoreCase("CRAFTING[4]") || str.equalsIgnoreCase("C[4]") || str.equalsIgnoreCase("CRAFTING(4)") || str.equalsIgnoreCase("C(4)")) {
            return 4;
        }
        return -1;
    }

    @Nonnull
    public static String getArmorSlot(@Nonnull String slot, boolean integer) {
        if (!integer) {
            if (slot.equalsIgnoreCase("39")) {
                return "HELMET";
            }
            if (slot.equalsIgnoreCase("38")) {
                return "CHESTPLATE";
            }
            if (slot.equalsIgnoreCase("37")) {
                return "LEGGINGS";
            }
            if (slot.equalsIgnoreCase("36")) {
                return "BOOTS";
            }
        } else {
            if (slot.equalsIgnoreCase("HELMET") || slot.equalsIgnoreCase("HEAD")) {
                return "39";
            }
            if (slot.equalsIgnoreCase("CHESTPLATE")) {
                return "38";
            }
            if (slot.equalsIgnoreCase("LEGGINGS")) {
                return "37";
            }
            if (slot.equalsIgnoreCase("BOOTS")) {
                return "36";
            }
        }
        return slot;
    }

    public static boolean isRegistered(@Nonnull String listener) {
        boolean returnValue = false;
        ArrayList rls = HandlerList.getRegisteredListeners((Plugin)Core.getCore().getPlugin());
        for (RegisteredListener rl : rls) {
            if (!rl.getListener().getClass().getSimpleName().equalsIgnoreCase(listener)) continue;
            returnValue = true;
            break;
        }
        return !returnValue;
    }

    @Nonnull
    public static String nullCheck(@Nullable String input) {
        if (input == null || input.equalsIgnoreCase("NULL") || input.equalsIgnoreCase("NULL&7") || input.contains("[]") || input.contains("{}") || input.equals("0&7") || input.equals("-1&a%") || input.isEmpty() || input.equals(" ")) {
            return "NONE";
        }
        if (input.startsWith("[") && input.endsWith("]")) {
            input = input.substring(0, input.length() - 1).substring(1);
        }
        if (input.startsWith("{") && input.endsWith("}")) {
            input = input.replace("{", "").replace("}", "").replace("=", ":");
        }
        return input;
    }

    public static boolean invalidASCII(@Nonnull String string) {
        for (char c : string.toCharArray()) {
            if (c <= '\u008f') continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static String translateHexColorCodes(@Nonnull String str) {
        int COLOR_CHAR = 167;
        Matcher matcher = Pattern.compile("&#([A-Fa-f0-9]{6})").matcher(str);
        StringBuffer buffer = new StringBuffer(str.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    @Nonnull
    public static String restoreColor(@Nonnull String str) {
        return str.replace('\u00a7', '&');
    }

    @Nonnull
    public static String colorFormat(@Nonnull String str) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.translateHexColorCodes(str));
    }

    @Nonnull
    public static String translateLayout(@Nullable String str, @Nullable Player player, PlaceHolder ... placeHolder) {
        if (str != null && !str.isEmpty()) {
            PlaceHolder ph;
            String playerName;
            String string = playerName = player == null ? null : PlayerHandler.getPlayerName(player);
            if (playerName == null || playerName.isEmpty()) {
                playerName = "EXEMPT";
            }
            PlaceHolder placeHolder2 = ph = placeHolder.length > 0 ? placeHolder[0] : new PlaceHolder();
            if (player != null && !(player instanceof ConsoleCommandSender)) {
                try {
                    ph.with(PlaceHolder.Holder.PLAYER, playerName).with(PlaceHolder.Holder.PLAYER_UUID, player.getUniqueId().toString()).with(PlaceHolder.Holder.MOB_KILLS, String.valueOf(player.getStatistic(Statistic.MOB_KILLS))).with(PlaceHolder.Holder.PLAYER_KILLS, String.valueOf(player.getStatistic(Statistic.PLAYER_KILLS))).with(PlaceHolder.Holder.PLAYER_DEATHS, String.valueOf(player.getStatistic(Statistic.DEATHS))).with(PlaceHolder.Holder.PLAYER_FOOD, String.valueOf(player.getFoodLevel())).with(PlaceHolder.Holder.PLAYER_HEALTH, String.valueOf(player.getHealth())).with(PlaceHolder.Holder.PLAYER_LEVEL, String.valueOf(player.getLevel())).with(PlaceHolder.Holder.PLAYER_LOCATION, player.getLocation().getBlockX() + ", " + player.getLocation().getBlockY() + ", " + player.getLocation().getBlockZ()).with(PlaceHolder.Holder.PLAYER_INTERACT, PlayerHandler.getNearbyPlayer(player, 5));
                }
                catch (Exception e) {
                    ServerUtils.sendDebugTrace(e);
                }
            }
            if (player == null) {
                ph.with(PlaceHolder.Holder.PLAYER, "CONSOLE");
            }
            str = ph.setPlaceholders(str);
            if (Core.getCore().getDependencies().placeHolderEnabled()) {
                try {
                    str = PlaceholderAPI.setPlaceholders((Player)player, (String)str);
                }
                catch (Exception e) {
                    ServerUtils.logWarn("An error has occurred when setting the Placeholder " + e.getMessage() + ", if this issue persists contact the developer of PlaceholderAPI.");
                    ServerUtils.sendSevereTrace(e);
                }
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.translateHexColorCodes(str));
        }
        return str == null ? "" : str;
    }
}

