/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.RockinChaos.itemjoin.core.utils.StringUtils;

public class TimerUtils {
    private static final Map<String, Map<Object, Long>> timedMap = new ConcurrentHashMap<String, Map<Object, Long>>();
    private static final ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor();

    public static void setExpiry(String uniqueId, Object object, int duration, TimeUnit ... timeUnit) {
        long future = timeUnit == null || timeUnit.length == 0 ? StringUtils.ticksToMillis(duration) : timeUnit[0].toMillis(duration);
        long expiryTime = System.currentTimeMillis() + future;
        timedMap.computeIfAbsent(uniqueId, k -> new ConcurrentHashMap()).put(object, expiryTime);
    }

    public static boolean isExpired(String uniqueId, Object object) {
        Map<Object, Long> objectMap = timedMap.get(uniqueId);
        if (objectMap == null) {
            return true;
        }
        Long expiryTime = objectMap.get(object);
        return expiryTime == null || expiryTime <= System.currentTimeMillis();
    }

    public static Object getAlive(String uniqueId, Object object) {
        if (!TimerUtils.isExpired(uniqueId, object)) {
            Map<Object, Long> objectMap = timedMap.get(uniqueId);
            for (Map.Entry<Object, Long> entry : objectMap.entrySet()) {
                Object storedObject = entry.getKey();
                if (!storedObject.equals(object)) continue;
                return storedObject;
            }
        }
        return null;
    }

    public static void removeExpiry(String uniqueId, Object object, boolean force) {
        Map<Object, Long> objectMap = timedMap.get(uniqueId);
        if (objectMap != null && (force || TimerUtils.isExpired(uniqueId, object))) {
            objectMap.remove(object);
            if (objectMap.isEmpty()) {
                timedMap.remove(uniqueId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearExpired() {
        Map<String, Map<Object, Long>> map = timedMap;
        synchronized (map) {
            long currentTime = System.currentTimeMillis();
            timedMap.forEach((id, objectMap) -> objectMap.values().removeIf(expiryTime -> expiryTime <= currentTime));
            timedMap.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        }
    }

    static {
        cleaner.scheduleAtFixedRate(TimerUtils::clearExpired, 1L, 1L, TimeUnit.MINUTES);
    }
}

