/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.SkullType;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class LegacyAPI {
    private static boolean legacyMaterial = false;

    public static void updateInventory(@Nonnull Player player) {
        player.updateInventory();
    }

    @Nonnull
    public static ItemStack getInHandItem(@Nonnull Player player) {
        return player.getInventory().getItemInHand();
    }

    public static void setInHandItem(@Nonnull Player player, @Nonnull ItemStack item) {
        player.setItemInHand(item);
    }

    @Nonnull
    public static ItemStack newItemStack(@Nonnull Material material, int count, short dataValue) {
        return new ItemStack(material, count, dataValue);
    }

    public static boolean hasGameRule(@Nonnull World world, @Nonnull String gamerule) {
        String value = world.getGameRuleValue(gamerule);
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    @Nonnull
    public static ShapedRecipe newShapedRecipe(@Nonnull ItemStack item) {
        return new ShapedRecipe(item);
    }

    public static void setIngredient(@Nonnull ShapedRecipe shapedRecipe, char character, @Nonnull Material material, byte itemData) {
        shapedRecipe.setIngredient(character, material, (int)itemData);
    }

    @Nonnull
    public static Material getMaterial(int typeID, byte dataValue) {
        LegacyAPI.initializeLegacy();
        return Core.getCore().getPlugin().getServer().getUnsafe().fromLegacy(new MaterialData(LegacyAPI.findMaterial(typeID), dataValue));
    }

    @Nonnull
    public static Material getMaterial(@Nullable Material material, byte dataValue) {
        if (material == null) {
            return Material.AIR;
        }
        LegacyAPI.initializeLegacy();
        return Core.getCore().getPlugin().getServer().getUnsafe().fromLegacy(new MaterialData(material, dataValue));
    }

    @Nonnull
    public static Material findMaterial(int typeID) {
        Material[] foundMaterial = new Material[1];
        EnumSet.allOf(Material.class).forEach(material -> {
            block4: {
                try {
                    if ((!StringUtils.containsIgnoreCase(material.toString(), "LEGACY_") || material.getId() != typeID) && (ServerUtils.hasSpecificUpdate("1_13") || material.getId() != typeID)) break block4;
                    try {
                        LegacyAPI.initializeLegacy();
                    }
                    catch (Exception e) {
                        ServerUtils.sendSevereTrace(e);
                    }
                    foundMaterial[0] = material;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return foundMaterial[0];
    }

    private static void initializeLegacy() {
        if (ServerUtils.hasSpecificUpdate("1_13") && !legacyMaterial) {
            legacyMaterial = true;
            ServerUtils.logInfo("Initializing Legacy Material Support ...");
            ServerUtils.logDebug("Your items.yml has one or more item(s) containing a numerical id and/or data values.");
            ServerUtils.logDebug("Minecraft 1.13 removed the use of these values, please change your items ids to reflect this change.");
            ServerUtils.logDebug("Your custom items will continue to function but the id set may not appear as expected.");
            ServerUtils.logDebug("If you believe this is a bug, please report it to the developer!");
            try {
                throw new Exception("Invalid usage of item id, this is not a bug!");
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    public static int getMaterialID(@Nonnull Material material) {
        return material.getId();
    }

    public static short getDurability(@Nonnull ItemStack item) {
        return item.getDurability();
    }

    @Nonnull
    public static ItemStack setDurability(@Nonnull ItemStack item, short durability) {
        item.setDurability(durability);
        return item;
    }

    @Nonnull
    public static String getEnchantName(@Nonnull Object enchant) {
        try {
            return (String)enchant.getClass().getMethod("getName", new Class[0]).invoke(enchant, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the Enchantment Name", e);
        }
    }

    @Nonnull
    public static List<Enchantment> getEnchants() {
        try {
            return Arrays.asList((Enchantment[])ReflectionUtils.getCanonicalClass("org.bukkit.enchantments.Enchantment").getMethod("values", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting Enchantment#values", e);
        }
    }

    @Nullable
    public static PotionEffectType getEffectByName(@Nonnull String effect) {
        if (ServerUtils.hasPreciseUpdate("1_20_3")) {
            PotionEffectType type = null;
            try {
                type = (PotionEffectType)Registry.EFFECT.get(Objects.requireNonNull(NamespacedKey.fromString((String)effect.toLowerCase())));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (type != null) {
                return type;
            }
            return PotionEffectType.getByName((String)effect.toUpperCase());
        }
        return PotionEffectType.getByName((String)effect.toUpperCase());
    }

    @Nonnull
    public static List<PotionEffectType> getEffects() {
        try {
            return Arrays.asList((PotionEffectType[])ReflectionUtils.getCanonicalClass("org.bukkit.potion.PotionEffectType").getMethod("values", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting PotionEffectType#values", e);
        }
    }

    @Nonnull
    public static List<Attribute> getAttributes() {
        try {
            return Arrays.asList((Attribute[])ReflectionUtils.getCanonicalClass("org.bukkit.attribute.Attribute").getMethod("values", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting Attribute#values", e);
        }
    }

    @Nonnull
    public static List<Sound> getSounds() {
        try {
            return Arrays.asList((Sound[])ReflectionUtils.getCanonicalClass("org.bukkit.Sound").getMethod("values", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting Sound#values", e);
        }
    }

    @Nullable
    public static Enchantment getEnchant(@Nonnull String name) {
        return Enchantment.getByName((String)name.toUpperCase());
    }

    @Nullable
    public static String getSkullOwner(@Nonnull SkullMeta skullMeta) {
        return skullMeta.getOwner();
    }

    @Nonnull
    public static ItemMeta setSkullOwner(@Nonnull Player player, @Nonnull SkullMeta skullMeta, @Nonnull String owner) {
        skullMeta.setOwner(owner);
        SchedulerUtils.run(() -> {
            if (!ServerUtils.hasSpecificUpdate("1_13")) {
                Location loc = new Location((World)Bukkit.getWorlds().get(0), 200.0, 1.0, 200.0);
                BlockState blockState = loc.getBlock().getState();
                try {
                    loc.getBlock().setType(Material.valueOf((String)"SKULL"));
                    Skull skull = (Skull)loc.getBlock().getState();
                    skull.setSkullType(SkullType.PLAYER);
                    skull.setOwner(owner);
                    skull.update();
                    String texture = ItemHandler.getSkullTexture(skull);
                    if (texture != null && !texture.isEmpty()) {
                        ItemHandler.setSkullTexture(player, (ItemMeta)skullMeta, texture);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                blockState.update(true);
            }
        });
        return skullMeta;
    }

    public static boolean setTargetExists(@Nonnull Entity current) {
        try {
            current.getClass().getMethod("setTarget", LivingEntity.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static void setMaxHealth(@Nonnull Player player, double maxHealth) {
        player.setMaxHealth(maxHealth);
    }

    public static void setHealth(@Nonnull Player player, int health) {
        player.setHealth((double)health);
    }

    public static byte getBlockData(@Nonnull Block block) {
        return block.getData();
    }

    @Nullable
    public static Player getPlayer(@Nonnull String playerName) {
        return Bukkit.getPlayer((String)playerName);
    }

    @Nonnull
    public static OfflinePlayer getOfflinePlayer(@Nonnull String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName);
    }

    public static void setMapID(@Nonnull MapMeta meta, int mapId) {
        meta.setMapId(mapId);
    }

    public static short getMapID(@Nonnull MapView view) {
        try {
            return (short)view.getId();
        }
        catch (Exception | NoSuchMethodError e) {
            try {
                return (Short)ReflectionUtils.getBukkitClass("map.MapView").getMethod("getId", new Class[0]).invoke((Object)view, new Object[0]);
            }
            catch (Exception | NoSuchMethodError e2) {
                return 1;
            }
        }
    }

    @Nullable
    public static MapView getMapView(int id) {
        try {
            return Core.getCore().getPlugin().getServer().getMap((int)((short)id));
        }
        catch (Exception | NoSuchMethodError e) {
            try {
                return (MapView)ReflectionUtils.getBukkitClass("Bukkit").getMethod("getMap", Short.TYPE).invoke(ReflectionUtils.getBukkitClass("map.MapView"), (short)id);
            }
            catch (Exception | NoSuchMethodError e2) {
                return null;
            }
        }
    }

    @Nonnull
    public static MapView createMapView() {
        return Core.getCore().getPlugin().getServer().createMap((World)Core.getCore().getPlugin().getServer().getWorlds().get(0));
    }

    @Nonnull
    public static ItemStack setAttributes(@Nonnull ItemStack tempItem, @Nonnull String attribIdentifier, @Nonnull Map<String, Double> attributes) {
        if (!ServerUtils.hasSpecificUpdate("1_13") && !attributes.isEmpty()) {
            try {
                String slot = ItemHandler.getDesignatedSlot(tempItem.getType()).equalsIgnoreCase("noslot") ? "HAND" : ItemHandler.getDesignatedSlot(tempItem.getType()).toUpperCase();
                Class<?> craftItemStack = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack");
                Class<?> itemClass = ReflectionUtils.getMinecraftClass("ItemStack");
                Class<?> baseClass = ReflectionUtils.getMinecraftClass("NBTBase");
                Object nms = craftItemStack.getMethod("asNMSCopy", ItemStack.class).invoke(null, tempItem);
                Object tag = itemClass.getMethod(ReflectionUtils.MinecraftMethod.getTag.getMethod(), new Class[0]).invoke(nms, new Object[0]);
                Object modifiers = ReflectionUtils.getMinecraftClass("NBTTagList").getConstructor(new Class[0]).newInstance(new Object[0]);
                if (tag == null) {
                    tag = ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                for (String attribute : attributes.keySet()) {
                    int uuid = new BigInteger((attribIdentifier + attribute).getBytes()).intValue();
                    Object attrib = ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                    double value = attributes.get(attribute);
                    StringBuilder name = new StringBuilder(attribute.toLowerCase().replaceFirst("_", "."));
                    if (name.toString().contains("_")) {
                        String[] nameSplit = name.toString().split("_");
                        name = new StringBuilder(nameSplit[0]);
                        nameSplit[0] = "";
                        for (String rename : nameSplit) {
                            name.append(org.apache.commons.lang.StringUtils.capitalize((String)rename));
                        }
                    }
                    attrib.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(attrib, "AttributeName", name.toString());
                    attrib.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(attrib, "Name", name.toString());
                    attrib.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(attrib, "Slot", slot);
                    attrib.getClass().getMethod(ReflectionUtils.MinecraftMethod.setDouble.getMethod(), String.class, Double.TYPE).invoke(attrib, "Amount", value);
                    attrib.getClass().getMethod(ReflectionUtils.MinecraftMethod.setInt.getMethod(), String.class, Integer.TYPE).invoke(attrib, "Operation", 0);
                    attrib.getClass().getMethod(ReflectionUtils.MinecraftMethod.setInt.getMethod(), String.class, Integer.TYPE).invoke(attrib, "UUIDLeast", uuid);
                    attrib.getClass().getMethod(ReflectionUtils.MinecraftMethod.setInt.getMethod(), String.class, Integer.TYPE).invoke(attrib, "UUIDMost", uuid / 2);
                    modifiers.getClass().getMethod(ReflectionUtils.MinecraftMethod.add.getMethod(), baseClass).invoke(modifiers, attrib);
                }
                tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.set.getMethod(), String.class, baseClass).invoke(tag, "AttributeModifiers", modifiers);
                return (ItemStack)craftItemStack.getMethod("asCraftMirror", nms.getClass()).invoke(null, nms);
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
        return tempItem;
    }

    @Nonnull
    public static AttributeModifier getAttribute(@Nonnull String uuid, @Nonnull String attrib, double value, @Nonnull EquipmentSlot slot) {
        try {
            Constructor constructor = AttributeModifier.class.getConstructor(UUID.class, String.class, Double.TYPE, AttributeModifier.Operation.class, EquipmentSlot.class);
            return (AttributeModifier)constructor.newInstance(UUID.nameUUIDFromBytes(uuid.getBytes()), attrib.toLowerCase().replace("_", "."), value, AttributeModifier.Operation.ADD_NUMBER, slot);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            throw new RuntimeException("{LegacyAPI} An error has occurred getting the attribute: " + attrib, e);
        }
    }

    public static void setRepairCost(AnvilInventory inventory, int cost) {
        try {
            inventory.getClass().getDeclaredMethod("setRepairCost", Integer.TYPE).invoke((Object)inventory, cost);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{LegacyAPI} An error has occurred while setting the repair cost!");
            ServerUtils.sendSevereTrace(e);
        }
    }

    @Nonnull
    public static String colorEncode(@Nonnull String str) {
        StringBuilder hiddenData = new StringBuilder();
        for (char c : str.toCharArray()) {
            hiddenData.append('\u00a7').append(c);
        }
        return hiddenData.toString();
    }

    @Nonnull
    public static String colorDecode(@Nonnull String str) {
        String[] hiddenData = str.split("(?:\\w{2,}|\\d[0-9A-Fa-f])+");
        StringBuilder returnData = new StringBuilder();
        String[] d = hiddenData[hiddenData.length - 1].split(String.valueOf('\u00a7'));
        for (int i = 1; i < d.length; ++i) {
            returnData.append(d[i]);
        }
        return returnData.toString();
    }

    public static boolean legacySk89q() {
        try {
            ReflectionUtils.getCanonicalClass("com.sk89q.worldedit.Vector");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setPotionData(@Nonnull PotionMeta tempMeta, @Nonnull PotionType potionType) {
        ReflectionUtils.setBasePotionData(tempMeta, potionType);
    }

    public static void setPotionData(@Nonnull PotionMeta tempMeta, @Nonnull PotionType potionType, boolean extended, boolean upgraded) {
        ReflectionUtils.setBasePotionData(tempMeta, potionType, extended, upgraded);
    }

    @Nonnull
    public static PatternType getPattern(@Nonnull String patternName) {
        try {
            return (PatternType)PatternType.class.getDeclaredMethod("valueOf", String.class).invoke(null, patternName.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the PatternType: " + patternName, e);
        }
    }

    @Nonnull
    public static String getPatternName(@Nonnull Object pattern) {
        try {
            return (String)pattern.getClass().getMethod("name", new Class[0]).invoke(pattern, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the Pattern Name", e);
        }
    }

    @Nonnull
    public static List<PatternType> getPatterns() {
        try {
            return Arrays.asList((PatternType[])ReflectionUtils.getCanonicalClass("org.bukkit.block.banner.PatternType").getMethod("values", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting Pattern#values", e);
        }
    }

    @Nonnull
    public static String getEffectName(@Nonnull Object type) {
        try {
            return (String)type.getClass().getMethod("getName", new Class[0]).invoke(type, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the PotionEffectType Name", e);
        }
    }

    @Nonnull
    public static String getAttributeName(@Nonnull Object attribute) {
        try {
            return (String)attribute.getClass().getMethod("name", new Class[0]).invoke(attribute, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the Attribute Name", e);
        }
    }

    @Nonnull
    public static Attribute getAttribute(@Nonnull String attributeName) {
        try {
            return (Attribute)Attribute.class.getDeclaredMethod("valueOf", String.class).invoke(null, attributeName.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the Attribute: " + attributeName, e);
        }
    }

    @Nonnull
    public static String getSoundName(@Nonnull Object sound) {
        try {
            return (String)sound.getClass().getMethod("name", new Class[0]).invoke(sound, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the Sound Name", e);
        }
    }

    @Nonnull
    public static Sound getSound(@Nonnull String soundName) {
        try {
            return (Sound)Sound.class.getDeclaredMethod("valueOf", String.class).invoke(null, soundName.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("{LegacyAPI} An error has occurred while getting the Sound: " + soundName, e);
        }
    }

    @Nullable
    public static Enchantment getEnchantByKey(@Nonnull String name) {
        if (ServerUtils.hasPreciseUpdate("1_20_3")) {
            Enchantment enchant = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)name.toLowerCase()));
            if (enchant != null) {
                return enchant;
            }
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name.toLowerCase()));
        }
        return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name.toLowerCase()));
    }

    @Nonnull
    public static String getRenameText(@Nonnull Object event) {
        try {
            Object inventory = event.getClass().getMethod("getInventory", new Class[0]).invoke(event, new Object[0]);
            return (String)inventory.getClass().getMethod("getRenameText", new Class[0]).invoke(inventory, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{LegacyAPI} An error has occurred with InventoryEvent#getRenameText!");
            return "";
        }
    }

    public static int getDataValue(@Nonnull ItemStack item) {
        return Objects.requireNonNull(item.getData()).getData();
    }

    public static int getDataValue(@Nonnull Material material) {
        if (material == Material.STONE) {
            return 6;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "DIRT")) {
            return 2;
        }
        if (material.toString().equalsIgnoreCase("WOOD")) {
            return 5;
        }
        if (material.toString().equalsIgnoreCase("LOG")) {
            return 3;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "SAPLING")) {
            return 5;
        }
        if (material.toString().equalsIgnoreCase("SAND")) {
            return 1;
        }
        if (material.toString().equalsIgnoreCase("LEAVES")) {
            return 3;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "SPONGE")) {
            return 1;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "SANDSTONE") && !StringUtils.containsIgnoreCase(material.toString(), "STAIRS")) {
            return 2;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "LONG_GRASS")) {
            return 2;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "RED_ROSE")) {
            return 8;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "WOOD_STEP")) {
            return 5;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "STEP")) {
            return 7;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "STAINED_GLASS")) {
            return 15;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "MONSTER_EGGS")) {
            return 5;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "SMOOTH_BRICK")) {
            return 3;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "COBBLE_WALL")) {
            return 1;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "QUARTZ_BLOCK")) {
            return 2;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "STAINED_CLAY")) {
            return 15;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "LOG_2")) {
            return 1;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "LEAVES_2")) {
            return 1;
        }
        if (material.toString().equalsIgnoreCase("PRISMARINE")) {
            return 2;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "CARPET")) {
            return 15;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "DOUBLE_PLANT")) {
            return 5;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "RED_SANDSTONE")) {
            return 2;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "GOLDEN_APPLE")) {
            return 1;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "RAW_FISH")) {
            return 3;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "COOKED_FISHED")) {
            return 1;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "INK_SAC")) {
            return 15;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "SKULL_ITEM") && ServerUtils.hasSpecificUpdate("1_9")) {
            return 5;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "SKULL_ITEM")) {
            return 4;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "CONCRETE")) {
            return 15;
        }
        if (StringUtils.containsIgnoreCase(material.toString(), "WOOL")) {
            return 15;
        }
        return 0;
    }
}

