/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class PasteAPI {
    private final String pasteData;

    public PasteAPI(@Nonnull CommandSender console, @Nullable List<String> warnPlugins, @Nullable Map<String, String> files) {
        Player sender = console instanceof Player ? (Player)console : null;
        JsonObject dump = new JsonObject();
        JsonObject meta = new JsonObject();
        meta.addProperty("timestamp", (Number)Instant.now().toEpochMilli());
        meta.addProperty("sender", sender != null ? sender.getName() : null);
        meta.addProperty("senderUuid", sender != null ? sender.getUniqueId().toString() : null);
        dump.add("meta", (JsonElement)meta);
        JsonObject pluginData = new JsonObject();
        pluginData.addProperty("name", Core.getCore().getPlugin().getName());
        pluginData.addProperty("version", Core.getCore().getPlugin().getDescription().getVersion());
        pluginData.addProperty("dev", Boolean.valueOf(Core.getCore().getUpdater().isDevVersion()));
        dump.add("plugin-data", (JsonElement)pluginData);
        JsonObject serverData = new JsonObject();
        serverData.addProperty("bukkit-version", Bukkit.getBukkitVersion());
        serverData.addProperty("server-version", Bukkit.getVersion());
        serverData.addProperty("server-brand", Bukkit.getName());
        serverData.addProperty("online-mode", Bukkit.getOnlineMode() ? "YES" : "NO");
        JsonObject supportStatus = new JsonObject();
        supportStatus.addProperty("supported", Boolean.valueOf(!Core.getCore().getUpdater().updateNeeded((CommandSender)console, (boolean)false).updateNeeded));
        serverData.add("support-status", (JsonElement)supportStatus);
        dump.add("server-data", (JsonElement)serverData);
        JsonObject environment = new JsonObject();
        environment.addProperty("java-version", System.getProperty("java.version"));
        environment.addProperty("operating-system", System.getProperty("os.name"));
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        environment.addProperty("uptime", String.format("%02d:%02d:%02d:%02d", TimeUnit.MILLISECONDS.toDays(uptime), TimeUnit.MILLISECONDS.toHours(uptime), TimeUnit.MILLISECONDS.toMinutes(uptime) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(uptime)), TimeUnit.MILLISECONDS.toSeconds(uptime) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(uptime))));
        environment.addProperty("allocated-memory", Runtime.getRuntime().totalMemory() / 1024L / 1024L + "MB");
        dump.add("environment", (JsonElement)environment);
        JsonArray plugins = new JsonArray();
        ArrayList<Plugin> alphabetical = new ArrayList<Plugin>();
        Collections.addAll(alphabetical, Bukkit.getPluginManager().getPlugins());
        alphabetical.sort(Comparator.comparing(o -> o.getName().toUpperCase(Locale.ENGLISH)));
        for (Plugin plugin : alphabetical) {
            JsonObject pluginInfo = new JsonObject();
            PluginDescriptionFile info = plugin.getDescription();
            String name = info.getName();
            pluginInfo.addProperty("name", name);
            pluginInfo.addProperty("version", info.getVersion());
            pluginInfo.addProperty("description", info.getDescription());
            pluginInfo.addProperty("main", info.getMain());
            pluginInfo.addProperty("enabled", Boolean.valueOf(plugin.isEnabled()));
            pluginInfo.addProperty("official", Boolean.valueOf(plugin == Core.getCore().getPlugin() || Core.getCore().getData().getOfficialPlugins().contains(name)));
            pluginInfo.addProperty("unsupported", Boolean.valueOf(warnPlugins != null && warnPlugins.contains(name)));
            JsonArray authors = new JsonArray();
            for (String author : info.getAuthors()) {
                authors.add((JsonElement)(author == null ? JsonNull.INSTANCE : new JsonPrimitive(author)));
            }
            pluginInfo.add("authors", (JsonElement)authors);
            plugins.add((JsonElement)pluginInfo);
        }
        dump.add("plugins", (JsonElement)plugins);
        JsonObject jsonFiles = new JsonObject();
        if (files != null) {
            for (String file : files.keySet()) {
                jsonFiles.addProperty(file, files.get(file));
            }
        }
        dump.add("files", (JsonElement)jsonFiles);
        this.pasteData = dump.toString();
    }

    @Nonnull
    private HttpURLConnection getHttpURLConnection(@Nonnull String postOptions) throws IOException {
        byte[] postBytes = postOptions.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection connection = (HttpURLConnection)new URL("https://paste.craftationgaming.com/documents").openConnection();
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(postBytes.length);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        connection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.connect();
        try (OutputStream os = connection.getOutputStream();){
            os.write(postBytes);
        }
        return connection;
    }

    public void getPaste(@Nonnull Consumer<String> callback) {
        SchedulerUtils.runAsync(() -> {
            try {
                String inputLine;
                HttpURLConnection connection = this.getHttpURLConnection(this.pasteData);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                connection.disconnect();
                JSONObject objectReader = (JSONObject)JSONValue.parseWithException((String)response.toString());
                String pasteKey = objectReader.get((Object)"key").toString();
                callback.accept("https://ci.craftationgaming.com/dump?id=" + pasteKey);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{PasteAPI} A severe error has occurred which has prevented the paste URL from generating.");
                ServerUtils.sendSevereTrace(e);
                callback.accept(null);
            }
        });
    }
}

