/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.interfaces;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.interfaces.types.Button;
import me.RockinChaos.itemjoin.core.utils.interfaces.types.Page;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class Interface
implements InventoryHolder {
    private final Inventory inventory;
    private final int pageSize;
    private final Player panePlayer;
    private final SortedMap<Integer, Page> pages = new TreeMap<Integer, Page>();
    private final boolean isPaged;
    private int activeButton = -1;
    private int currentIndex;
    private boolean canChat = false;
    private boolean pendingChat = false;
    private boolean pendingClick = false;
    private Button controlBack;
    private Button controlNext;
    private Button controlExit;
    private Button exitButton;

    public Interface(boolean isPaged, int rows, @Nonnull Button exitButton, @Nonnull String title, @Nonnull Player player) {
        this.panePlayer = player;
        this.isPaged = isPaged;
        if (this.isPaged) {
            this.pageSize = rows - 1;
            this.exitButton = exitButton;
        } else {
            this.pageSize = rows * 9;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)StringUtils.colorFormat(title));
        this.inventory.setMaxStackSize(128);
        this.pages.put(0, new Page(this.pageSize));
        this.createControls(this.inventory);
    }

    public void onClick(@Nonnull InventoryClickEvent event) {
        if (!(!this.panePlayer.equals(event.getWhoClicked()) || this.pendingClick && event.getSlot() <= event.getWhoClicked().getInventory().getSize() && event.getSlot() >= 0 && this.clickInventory(event))) {
            try {
                if (this.isPaged && event.getSlot() == this.inventory.getSize() - 8 && this.getCurrentPage() > 1) {
                    if (this.controlBack != null) {
                        this.controlBack.onClick(event);
                    }
                } else if (this.isPaged && event.getSlot() == this.inventory.getSize() - 2 && this.getCurrentPage() < this.getPageAmount()) {
                    if (this.controlNext != null) {
                        this.controlNext.onClick(event);
                    }
                } else if (this.isPaged && (event.getSlot() == this.inventory.getSize() - 1 || event.getSlot() == this.inventory.getSize() - 9)) {
                    if (this.controlExit != null) {
                        this.controlExit.onClick(event);
                    }
                } else if (event.getCurrentItem() != null) {
                    ((Page)this.pages.get(this.currentIndex)).handleClick(event);
                    this.activeButton = event.getSlot();
                    if (((Page)this.pages.get(this.currentIndex)).chatEvent(event.getSlot())) {
                        this.pendingChat = true;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            event.setCancelled(true);
        }
    }

    public void onChat(@Nonnull AsyncPlayerChatEvent event) {
        if (this.panePlayer.equals(event.getPlayer()) && this.activeButton != -1) {
            ((Page)this.pages.get(this.currentIndex)).handleChat(event, this.activeButton);
            this.pendingChat = false;
            event.setCancelled(true);
        } else if (!this.canChat) {
            this.pendingChat = false;
        }
    }

    public void onTyping(@Nonnull Player player) {
        if (this.panePlayer.equals(player) && this.activeButton != -1) {
            ((Page)this.pages.get(this.currentIndex)).handleTyping(player, this.activeButton);
            this.pendingChat = false;
        } else if (!this.canChat) {
            this.pendingChat = false;
        }
    }

    public void closeQuery(@Nonnull Player player) {
        if (this.panePlayer.equals(player) && this.activeButton != -1) {
            ((Page)this.pages.get(this.currentIndex)).closeQuery(player, this.activeButton);
        }
    }

    public void allowClick(boolean bool) {
        this.pendingClick = bool;
    }

    public void allowChat(boolean bool) {
        this.canChat = bool;
    }

    public void addButton(@Nonnull Button button) {
        for (Map.Entry<Integer, Page> entry : this.pages.entrySet()) {
            if (!entry.getValue().addButton(button)) continue;
            if (entry.getKey() == this.currentIndex) {
                this.renderPage();
            }
            return;
        }
        Page page = new Page(this.pageSize);
        page.addButton(button);
        this.pages.put(this.pages.lastKey() + 1, page);
        this.renderPage();
    }

    public void addButton(@Nonnull Button button, int amount) {
        if (amount == 0 || amount == 1) {
            this.addButton(button);
        } else {
            for (int i = 0; i < amount; ++i) {
                this.addButton(button);
            }
        }
    }

    public void removeButton(@Nonnull Button button) {
        Iterator<Map.Entry<Integer, Page>> iterator = this.pages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Page> entry = iterator.next();
            if (!entry.getValue().removeButton(button)) continue;
            if (entry.getValue().isEmpty()) {
                if (this.pages.size() > 1) {
                    iterator.remove();
                }
                if (this.currentIndex >= this.pages.size()) {
                    --this.currentIndex;
                }
            }
            if (entry.getKey() >= this.currentIndex) {
                this.renderPage();
            }
            return;
        }
    }

    public void setReturnButton(@Nonnull Button button) {
        if (this.isPaged) {
            this.controlExit = button;
            this.inventory.setItem(this.inventory.getSize() - 9, button.getItemStack());
            this.inventory.setItem(this.inventory.getSize() - 1, button.getItemStack());
        }
    }

    private void createControls(@Nonnull Inventory inventory) {
        if (this.isPaged) {
            ItemStack nextItem;
            ItemStack backItem;
            if (this.getCurrentPage() > 1) {
                backItem = ItemHandler.getItem("ARROW", 1, false, false, "&3" + (!Core.getCore().getLang().getString("menus.general.items.prevPage.name").isEmpty() ? Core.getCore().getLang().getString("menus.general.items.prevPage.name").replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount())) : "&n&lPrevious Page"), (String[])Stream.concat(Core.getCore().getLang().getStringList("menus.general.items.prevPage.lore").stream().filter(s -> !s.isEmpty()).map(lore -> lore.replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount()))), Stream.of(Core.getCore().getLang().getStringList("menus.general.items.prevPage.lore").isEmpty() || Core.getCore().getLang().getStringList("menus.general.items.prevPage.lore").stream().allMatch(String::isEmpty) ? "&7*Previous page &a&l" + (this.getCurrentPage() + 1) + "&7 / &c&l" + this.getPageAmount() : "")).toArray(String[]::new));
                this.controlBack = new Button(backItem, event -> this.selectPage(this.currentIndex - 1));
                inventory.setItem(inventory.getSize() - 8, backItem);
            } else {
                backItem = ItemHandler.getItem("LEVER", 1, false, false, "&c" + (!Core.getCore().getLang().getString("menus.general.items.prevPage.name").isEmpty() ? Core.getCore().getLang().getString("menus.general.items.prevPage.name").replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount())) : "&n&lPrevious Page"), (String[])Stream.concat(Core.getCore().getLang().getStringList("menus.general.items.prevPage.firstLore").stream().filter(s -> !s.isEmpty()).map(lore -> lore.replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount()))), Stream.of(Core.getCore().getLang().getStringList("menus.general.items.prevPage.firstLore").isEmpty() || Core.getCore().getLang().getStringList("menus.general.items.prevPage.firstLore").stream().allMatch(String::isEmpty) ? "&7*You are already at the first page." : "")).toArray(String[]::new));
                inventory.setItem(inventory.getSize() - 8, backItem);
            }
            if (this.getCurrentPage() < this.getPageAmount()) {
                nextItem = ItemHandler.getItem("ARROW", 1, false, false, "&3" + (!Core.getCore().getLang().getString("menus.general.items.nextPage.name").isEmpty() ? Core.getCore().getLang().getString("menus.general.items.nextPage.name").replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount())) : "&n&lNext Page"), (String[])Stream.concat(Core.getCore().getLang().getStringList("menus.general.items.nextPage.lore").stream().filter(s -> !s.isEmpty()).map(lore -> lore.replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount()))), Stream.of(Core.getCore().getLang().getStringList("menus.general.items.nextPage.lore").isEmpty() || Core.getCore().getLang().getStringList("menus.general.items.nextPage.lore").stream().allMatch(String::isEmpty) ? "&7*Next page &a&l" + (this.getCurrentPage() + 1) + "&7 / &c&l" + this.getPageAmount() : "")).toArray(String[]::new));
                this.controlNext = new Button(nextItem, event -> this.selectPage(this.getCurrentPage()));
                inventory.setItem(inventory.getSize() - 2, nextItem);
            } else {
                nextItem = ItemHandler.getItem("LEVER", 1, false, false, "&c" + (!Core.getCore().getLang().getString("menus.general.items.nextPage.name").isEmpty() ? Core.getCore().getLang().getString("menus.general.items.nextPage.name").replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount())) : "&n&lNext Page"), (String[])Stream.concat(Core.getCore().getLang().getStringList("menus.general.items.nextPage.lastLore").stream().filter(s -> !s.isEmpty()).map(lore -> lore.replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount()))), Stream.of(Core.getCore().getLang().getStringList("menus.general.items.nextPage.lastLore").isEmpty() || Core.getCore().getLang().getStringList("menus.general.items.nextPage.lastLore").stream().allMatch(String::isEmpty) ? "&7*You are already at the last page." : "")).toArray(String[]::new));
                inventory.setItem(inventory.getSize() - 2, nextItem);
            }
            inventory.setItem(inventory.getSize() - 5, ItemHandler.getItem("BOOK", 1, false, false, !Core.getCore().getLang().getString("menus.general.items.page.name").isEmpty() ? Core.getCore().getLang().getString("menus.general.items.page.name").replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount())) : "&3&lPage &a&l" + this.getCurrentPage() + "&7 / &c&l" + this.getPageAmount(), (String[])Stream.concat(Core.getCore().getLang().getStringList("menus.general.items.page.lore").stream().filter(s -> !s.isEmpty()).map(lore -> lore.replace("%page%", String.valueOf(this.getCurrentPage())).replace("%total_pages%", String.valueOf(this.getPageAmount()))), Stream.of(Core.getCore().getLang().getStringList("menus.general.items.page.lore").isEmpty() || Core.getCore().getLang().getStringList("menus.general.items.page.lore").stream().allMatch(String::isEmpty) ? "&7You are on page &a&l" + this.getCurrentPage() + "&7 / &c&l" + this.getPageAmount() : "")).toArray(String[]::new)));
            ItemStack exitItem = ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nMain Menu", "&7", "&7*Returns you to the main menu.");
            if (this.controlExit == null) {
                this.controlExit = this.exitButton;
            } else {
                exitItem = this.controlExit.getItemStack();
            }
            inventory.setItem(inventory.getSize() - 9, exitItem);
            inventory.setItem(inventory.getSize() - 1, exitItem);
            ItemStack blackPane = ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLACK_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:15", 1, false, false, "&f", "");
            inventory.setItem(inventory.getSize() - 3, blackPane);
            inventory.setItem(inventory.getSize() - 4, blackPane);
            inventory.setItem(inventory.getSize() - 6, blackPane);
            inventory.setItem(inventory.getSize() - 7, blackPane);
        }
    }

    private void renderPage() {
        this.inventory.clear();
        ((Page)this.pages.get(this.currentIndex)).render(this.inventory);
        this.createControls(this.inventory);
    }

    private int getPageAmount() {
        return this.pages.size();
    }

    private int getCurrentPage() {
        return this.currentIndex + 1;
    }

    private void selectPage(int index) {
        if (index == this.currentIndex) {
            return;
        }
        this.currentIndex = index;
        this.renderPage();
    }

    public boolean clickInventory(@Nonnull InventoryClickEvent event) {
        if (ServerUtils.hasSpecificUpdate("1_14")) {
            return event.getSlot() == -999 || event.getSlot() == -1 || event.getClickedInventory() == event.getWhoClicked().getInventory();
        }
        ItemStack clickItem = event.getCurrentItem();
        int slot = event.getSlot();
        return slot == -999 || slot == -1 || clickItem != null && (clickItem.equals((Object)event.getWhoClicked().getInventory().getItem(slot)) || clickItem.getType() == Material.AIR);
    }

    public boolean chatPending() {
        return this.pendingChat;
    }

    public void open(@Nonnull Player player) {
        SchedulerUtils.run(() -> {
            this.renderPage();
            player.openInventory(this.getInventory());
        });
    }

    @Nonnull
    public Inventory getInventory() {
        return this.inventory;
    }
}

