/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.interfaces.types;

import java.lang.reflect.Constructor;
import java.util.Map;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Container {
    private final Class<?> baseComponent = ReflectionUtils.getMinecraftClass("IChatBaseComponent");
    private final Class<?> dataComponent = ServerUtils.hasPreciseUpdate("1_20_5") ? ReflectionUtils.getMinecraftClass("DataComponents") : null;
    private final Class<?> humanEntity = ReflectionUtils.getMinecraftClass("EntityHuman");
    private final Class<?> mineContainer = ReflectionUtils.getMinecraftClass("Container");
    private final ReflectionUtils.FieldAccessor<?> activeContainer = ReflectionUtils.getField(this.humanEntity, ReflectionUtils.MinecraftField.ActiveContainer.getField());
    private final ReflectionUtils.FieldAccessor<?> defaultContainer = ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("EntityHuman"), ReflectionUtils.MinecraftField.DefaultContainer.getField());
    private final Class<?> playOpenWindow = ReflectionUtils.getMinecraftClass("PacketPlayOutOpenWindow");
    private final Class<?> playCloseWindow = ReflectionUtils.getMinecraftClass("PacketPlayOutCloseWindow");
    private ItemStack outItem;
    private String outText;
    private int outPreview = 0;
    private String leftText;
    private boolean isAction = false;
    private Object container = null;
    private int containerId = 0;

    public Container(@Nonnull Player player, @Nonnull Object inventoryTitle, @Nonnull ItemStack outItem) {
        try {
            Class<?> blockPosition = ReflectionUtils.getMinecraftClass("BlockPosition");
            Class<?> containerAnvil = ReflectionUtils.getMinecraftClass("ContainerAnvil");
            Object world = player.getWorld().getClass().getMethod("getHandle", new Class[0]).invoke((Object)player.getWorld(), new Object[0]);
            Object entityPlayer = ReflectionUtils.getEntity(player);
            Object playerInventory = null;
            if (ServerUtils.hasSpecificUpdate("1_17") && entityPlayer != null) {
                playerInventory = entityPlayer.getClass().getMethod(ReflectionUtils.MinecraftMethod.PlayerInventory.getMethod(), new Class[0]).invoke(entityPlayer, new Object[0]);
            } else if (entityPlayer != null) {
                playerInventory = entityPlayer.getClass().getField(ReflectionUtils.MinecraftMethod.PlayerInventory.getMethod()).get(entityPlayer);
            }
            this.outItem = outItem;
            this.containerId = this.getRealNextContainerId(player);
            if (ServerUtils.hasSpecificUpdate("1_14")) {
                Class<?> containerAccess = ReflectionUtils.getMinecraftClass("ContainerAccess");
                ReflectionUtils.MethodInvoker CAM = ReflectionUtils.getMethod(containerAccess, ReflectionUtils.MinecraftMethod.At.getMethod(), ReflectionUtils.getMinecraftClass("World"), blockPosition);
                Object accessContainer = CAM.invoke(containerAccess, world, blockPosition.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0));
                this.container = containerAnvil.getConstructor(Integer.TYPE, ReflectionUtils.getMinecraftClass("PlayerInventory"), containerAccess).newInstance(this.containerId, playerInventory, accessContainer);
            } else {
                this.container = containerAnvil.getConstructor(ReflectionUtils.getMinecraftClass("PlayerInventory"), ReflectionUtils.getMinecraftClass("World"), blockPosition, this.humanEntity).newInstance(playerInventory, world, blockPosition.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0), ReflectionUtils.getEntity(player));
            }
            ReflectionUtils.getField(this.mineContainer, "checkReachable").set(this.container, false);
            if (ServerUtils.hasSpecificUpdate("1_14")) {
                this.container.getClass().getMethod("setTitle", this.baseComponent).invoke(this.container, inventoryTitle);
            }
            ReflectionUtils.getField(containerAnvil, ServerUtils.hasSpecificUpdate("1_13") ? "maximumRepairCost" : (ServerUtils.hasSpecificUpdate("1_12") ? "levelCost" : "a"), Integer.TYPE).set(this.container, 0);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    private int getRealNextContainerId(@Nonnull Player player) {
        Object entityPlayer = ReflectionUtils.getEntity(player);
        return entityPlayer == null ? 0 : (Integer)ReflectionUtils.invokeMethod("nextContainerCounter", entityPlayer);
    }

    public void handleInventoryCloseEvent(@Nonnull Player player) {
        Object entityPlayer = ReflectionUtils.getEntity(player);
        try {
            ReflectionUtils.getCraftBukkitClass("event.CraftEventFactory").getMethod("handleInventoryCloseEvent", this.humanEntity).invoke(null, entityPlayer);
        }
        catch (Exception e1) {
            try {
                ReflectionUtils.getCraftBukkitClass("event.CraftEventFactory").getMethod("handleInventoryCloseEvent", this.humanEntity, Class.forName("org.bukkit.event.inventory.InventoryCloseEvent$Reason")).invoke(null, entityPlayer, null);
            }
            catch (Exception e2) {
                ServerUtils.sendSevereTrace(e1);
                ServerUtils.sendSevereTrace(e2);
            }
        }
    }

    public void sendPacketOpenWindow(@Nonnull Player player, @Nonnull Object inventoryTitle) {
        try {
            Object packets;
            if (ServerUtils.hasSpecificUpdate("1_14")) {
                Class<?> mineContainers = ReflectionUtils.getMinecraftClass("Containers");
                ReflectionUtils.FieldAccessor anvilContainers = ReflectionUtils.getField(mineContainers, ReflectionUtils.MinecraftField.Anvil.getField());
                Constructor<?> packetConstructor = this.playOpenWindow.getConstructor(Integer.TYPE, mineContainers, this.baseComponent);
                packets = packetConstructor.newInstance(this.containerId, anvilContainers.get(mineContainers), inventoryTitle);
            } else {
                Constructor<?> packetConstructor = this.playOpenWindow.getConstructor(Integer.TYPE, String.class, this.baseComponent);
                packets = packetConstructor.newInstance(this.containerId, "minecraft:anvil", inventoryTitle);
            }
            ReflectionUtils.sendPacket(player, packets);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    public void sendPacketCloseWindow(@Nonnull Player player) {
        try {
            Object packets = this.playCloseWindow.getConstructor(Integer.TYPE).newInstance(this.containerId);
            ReflectionUtils.sendPacket(player, packets);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    public void setActiveContainerDefault(@Nonnull Player player) {
        this.activeContainer.set(ReflectionUtils.getEntity(player), this.defaultContainer.get(ReflectionUtils.getEntity(player)));
    }

    public void setActiveContainer(@Nonnull Player player) {
        this.activeContainer.set(ReflectionUtils.getEntity(player), this.container);
    }

    public void setActiveContainerId() {
        if (!ServerUtils.hasSpecificUpdate("1_14")) {
            ReflectionUtils.getField(this.mineContainer, "windowId").set(this.container, this.containerId);
        }
    }

    public void addActiveContainerSlotListener(@Nonnull Player player) {
        try {
            Object entityPlayer = ReflectionUtils.getEntity(player);
            if (ServerUtils.hasSpecificUpdate("1_17") && entityPlayer != null) {
                entityPlayer.getClass().getMethod(ReflectionUtils.MinecraftMethod.AddSlotListener.getMethod(), this.mineContainer).invoke(entityPlayer, this.container);
            } else {
                this.mineContainer.getMethod(ReflectionUtils.MinecraftMethod.AddSlotListener.getMethod(), ReflectionUtils.getMinecraftClass("ICrafting")).invoke(this.container, entityPlayer);
            }
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    @Nonnull
    public String getRenameText() {
        try {
            return (String)this.mineContainer.getMethod(ReflectionUtils.MinecraftField.RenameText.getField(), new Class[0]).invoke(this.container, new Object[0]);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return "";
        }
    }

    public void setRenameText(@Nonnull String text) {
        try {
            Object inputLeft = this.mineContainer.getMethod(ReflectionUtils.MinecraftField.GetSlot.getField(), Integer.TYPE).invoke(this.container, 0);
            boolean inputLeftF = (Boolean)inputLeft.getClass().getMethod(ReflectionUtils.MinecraftField.HasItem.getField(), new Class[0]).invoke(inputLeft, new Object[0]);
            if (inputLeftF) {
                Object inputLeftE = inputLeft.getClass().getMethod(ReflectionUtils.MinecraftField.GetItem.getField(), new Class[0]).invoke(inputLeft, new Object[0]);
                if (ServerUtils.hasPreciseUpdate("1_20_5")) {
                    inputLeftE.getClass().getMethod("b", ReflectionUtils.getMinecraftClass("DataComponentType"), Object.class).invoke(inputLeftE, this.dataComponent.getField(ReflectionUtils.MinecraftField.CustomName.getField()).get(null), ReflectionUtils.literalChatComponent(text));
                } else if (ServerUtils.hasSpecificUpdate("1_13")) {
                    inputLeftE.getClass().getMethod("a", this.baseComponent).invoke(inputLeftE, ReflectionUtils.literalChatComponent(text));
                } else {
                    inputLeftE.getClass().getMethod(ServerUtils.hasSpecificUpdate("1_11") ? "g" : "c", String.class).invoke(inputLeftE, text);
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    @Nonnull
    public ItemStack getResult(@Nonnull Player player, @Nonnull String entryText) {
        ItemStack item = this.outItem.clone();
        String renameText = entryText;
        try {
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta != null) {
                boolean isAction;
                boolean bl = isAction = renameText.startsWith("-->") || this.isAction;
                if ((renameText = renameText.substring(renameText.startsWith("--> ") ? 4 : (renameText.startsWith("-->") ? 3 : (renameText.startsWith("-> ") ? 3 : (renameText.startsWith("->") ? 2 : (renameText.startsWith("--") ? 2 : (renameText.startsWith("-") ? 1 : 0))))))).isEmpty() && isAction && this.outText != null && !this.outText.isEmpty()) {
                    renameText = this.outText + this.getSpacers();
                } else if (renameText.isEmpty()) {
                    renameText = itemMeta.getDisplayName() + this.getSpacers();
                }
                itemMeta.setDisplayName(StringUtils.translateLayout(renameText, player, new PlaceHolder[0]));
                item.setItemMeta(itemMeta);
                if (!ServerUtils.hasSpecificUpdate("1_12")) {
                    LegacyAPI.updateInventory(player);
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
        return item;
    }

    public void handleTyping(@Nonnull String entryText) {
        String renameText = entryText;
        try {
            boolean isAction;
            boolean bl = isAction = renameText.startsWith("-->") || this.isAction;
            renameText = renameText.substring(renameText.startsWith("-->") ? 3 : (renameText.startsWith("--> ") ? 4 : (renameText.startsWith("->") ? 2 : (renameText.startsWith("-> ") ? 3 : 0))));
            renameText = renameText.trim();
            if (!renameText.isEmpty() && !this.isAction) {
                this.setRenameText(renameText);
            } else if (isAction && this.leftText != null && !this.leftText.isEmpty()) {
                this.setRenameText("-->" + this.leftText);
            }
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    public void removeCost(@Nonnull PrepareAnvilEvent event) {
        CompatUtils.resolveByVersion("1_21", () -> {
            event.getView().setRepairCost(0);
            return null;
        }, () -> {
            if (ServerUtils.hasSpecificUpdate("1_11")) {
                LegacyAPI.setRepairCost(event.getInventory(), 0);
            }
            return null;
        });
    }

    public void setAction(boolean action) {
        this.isAction = action;
    }

    public void setLeftText(@Nonnull String leftText) {
        this.leftText = leftText;
    }

    public void setOutText(@Nonnull String outText) {
        this.outText = outText;
    }

    @Nonnull
    public String getSpacers() {
        Map.Entry<StringBuilder, Integer> rSpaces = StringUtils.getSpacers(0, 5, this.outPreview).entrySet().iterator().next();
        this.outPreview = rSpaces.getValue();
        return "" + rSpaces.getKey();
    }

    @Nonnull
    public Inventory getBukkitInventory() {
        return (Inventory)ReflectionUtils.invokeMethod("getTopInventory", ReflectionUtils.invokeMethod("getBukkitView", this.container));
    }
}

