/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.interfaces.types;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.utils.interfaces.types.Button;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;

public class Page {
    private final List<Button> buttons = new ArrayList<Button>();
    private final int maxSize;

    public Page(int maxSize) {
        this.maxSize = maxSize;
    }

    public void handleClick(@Nonnull InventoryClickEvent event) {
        if (event.getRawSlot() > event.getInventory().getSize()) {
            return;
        }
        if (event.getSlot() >= this.buttons.size()) {
            return;
        }
        Button button = this.buttons.get(event.getSlot());
        button.onClick(event);
    }

    public void handleChat(@Nonnull AsyncPlayerChatEvent event, int slot) {
        Button button = this.buttons.get(slot);
        button.onChat(event);
    }

    public void handleTyping(@Nonnull Player player, int slot) {
        Button button = this.buttons.get(slot);
        button.onTyping(player);
    }

    public void closeQuery(@Nonnull Player player, int slot) {
        Button button = this.buttons.get(slot);
        button.closeQuery();
    }

    public boolean addButton(@Nonnull Button button) {
        if (!this.hasSpace()) {
            return false;
        }
        this.buttons.add(button);
        return true;
    }

    public boolean removeButton(@Nonnull Button button) {
        return this.buttons.remove(button);
    }

    public void render(@Nonnull Inventory inventory) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            inventory.setItem(i, button.getItemStack());
        }
    }

    private boolean hasSpace() {
        return this.buttons.size() < this.maxSize * 9;
    }

    public boolean isEmpty() {
        return this.buttons.isEmpty();
    }

    public boolean chatEvent(int slot) {
        if (slot <= this.buttons.size()) {
            return this.buttons.get(slot).chatEvent();
        }
        return false;
    }
}

