/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.protocol;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.protocol.TinyProtocol;
import me.RockinChaos.itemjoin.core.utils.protocol.events.InventoryCloseEvent;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PermissionChangedEvent;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PlayerAutoCraftEvent;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PlayerCloneItemEvent;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PlayerPickItemEvent;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PrepareAnvilEvent;
import me.RockinChaos.itemjoin.core.utils.protocol.packet.PacketContainer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class ProtocolManager {
    private static TinyProtocol protocol;
    private static int permissionTask;

    public static void handleProtocols() {
        if (protocol != null) {
            ProtocolManager.closeProtocol();
        }
        protocol = new TinyProtocol((Plugin)Core.getCore().getPlugin()){

            @Override
            public Object onPacketInAsync(Player player, Channel channel, Object packet) {
                if (packet != null && player != null && ProtocolManager.manageEvents(player, packet.getClass().getSimpleName(), protocol.getContainer(packet))) {
                    return null;
                }
                return super.onPacketInAsync(player, channel, packet);
            }

            @Override
            public Object onPacketOutAsync(Player player, Channel channel, Object packet) {
                return packet;
            }
        };
    }

    public static void handlePermissions() {
        if (permissionTask == 0) {
            HashMap playerPermissions = new HashMap();
            permissionTask = SchedulerUtils.runAsyncAtInterval(5L, 0L, () -> PlayerHandler.forOnlinePlayers(player -> {
                List previousPermissions;
                List currentPermissions = player.getEffectivePermissions().stream().map(p -> p.getPermission() + ":" + p.getValue()).sorted().collect(Collectors.toList());
                if (!currentPermissions.equals(previousPermissions = (List)playerPermissions.get(player))) {
                    ArrayList<String> changedPermissions = new ArrayList<String>();
                    if (previousPermissions != null) {
                        ArrayList addedPermissions = new ArrayList(currentPermissions);
                        addedPermissions.removeAll(previousPermissions);
                        List<Object> removedPermissions = new ArrayList(previousPermissions);
                        removedPermissions.removeAll(currentPermissions);
                        removedPermissions = removedPermissions.stream().map(r -> {
                            int idx = r.indexOf(58);
                            return (idx > -1 ? r.substring(0, idx) : r) + ":false";
                        }).collect(Collectors.toList());
                        Set toggledNames = removedPermissions.stream().map(r -> r.substring(0, r.indexOf(58))).filter(name -> addedPermissions.stream().anyMatch(a -> a.startsWith(name + ":"))).collect(Collectors.toSet());
                        ArrayList changes = new ArrayList(addedPermissions);
                        removedPermissions.stream().filter(r -> !toggledNames.contains(r.substring(0, r.indexOf(58)))).forEach(changes::add);
                        changedPermissions.addAll(changes);
                    }
                    playerPermissions.put(player, currentPermissions);
                    if (!changedPermissions.isEmpty()) {
                        ProtocolManager.callEvent((Event)new PermissionChangedEvent((Player)player, (List<String>)changedPermissions));
                    }
                }
            }));
        }
    }

    public static boolean manageEvents(@Nonnull Player player, @Nonnull String packetName, @Nonnull PacketContainer packetContainer) {
        try {
            if (packetName.equalsIgnoreCase("PacketPlayInPickItem") || packetName.contains("PickItemFromBlockPacket")) {
                PlayerPickItemEvent PickItem = new PlayerPickItemEvent(player, (Inventory)player.getInventory());
                ProtocolManager.callEvent((Event)PickItem);
                return PickItem.isCancelled();
            }
            if (packetName.equalsIgnoreCase("PacketPlayInAutoRecipe") || packetName.contains("PlaceRecipePacket")) {
                PlayerAutoCraftEvent AutoCraft = new PlayerAutoCraftEvent(player, CompatUtils.getTopInventory(player), (Boolean)(ServerUtils.hasPreciseUpdate("1_20_5") && packetContainer.read(3).getData() instanceof Boolean ? packetContainer.read(3) : packetContainer.read(2)).getData());
                ProtocolManager.callEvent((Event)AutoCraft);
                return AutoCraft.isCancelled();
            }
            if (packetName.equalsIgnoreCase("PacketPlayInCloseWindow") || packetName.contains("ContainerClosePacket")) {
                InventoryCloseEvent CloseInventory = new InventoryCloseEvent(CompatUtils.getOpenInventory(player));
                ProtocolManager.callEvent(CloseInventory);
                return CloseInventory.isCancelled();
            }
            if (packetName.equalsIgnoreCase("PacketPlayInCustomPayload") || packetName.contains("RenameItemPacket")) {
                if (packetContainer.read(0).getData().toString().equalsIgnoreCase("MC|ItemName") && CompatUtils.getInventoryType(player).name().equalsIgnoreCase("ANVIL")) {
                    Object UnbufferedPayload = packetContainer.read(1).getData();
                    String renameText = (String)UnbufferedPayload.getClass().getMethod(ServerUtils.hasSpecificUpdate("1_9") ? "e" : "c", Integer.TYPE).invoke(UnbufferedPayload, 31);
                    PrepareAnvilEvent PrepareAnvil2 = new PrepareAnvilEvent(CompatUtils.getOpenInventory(player), renameText);
                    ProtocolManager.callEvent(PrepareAnvil2);
                    return PrepareAnvil2.isCancelled();
                }
            } else if ((packetName.equalsIgnoreCase("PacketPlayInWindowClick") || packetName.contains("ContainerClickPacket")) && packetContainer.read(5).getData().toString().equalsIgnoreCase("QUICK_CRAFT")) {
                int slot;
                int n = slot = ServerUtils.hasSpecificUpdate("1_17") ? ((Integer)packetContainer.read(3).getData()).intValue() : ((Integer)packetContainer.read(1).getData()).intValue();
                if (slot >= 0) {
                    PlayerCloneItemEvent CloneItem = new PlayerCloneItemEvent(player, slot, ClickType.MIDDLE);
                    ProtocolManager.callEvent((Event)CloneItem);
                    return CloneItem.isCancelled();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void callEvent(@Nonnull Event event) {
        RegisteredListener[] listeners;
        HandlerList handlers = event.getHandlers();
        for (RegisteredListener registration : listeners = handlers.getRegisteredListeners()) {
            if (!registration.getPlugin().isEnabled()) continue;
            try {
                registration.getPlugin();
                registration.callEvent(event);
            }
            catch (AuthorNagException e) {
                Plugin plugin = registration.getPlugin();
                if (!plugin.isNaggable()) continue;
                plugin.setNaggable(false);
                Core.getCore().getPlugin().getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), e.getMessage()));
            }
            catch (Throwable e) {
                Core.getCore().getPlugin().getLogger().log(Level.SEVERE, "Could not pass event " + event.getEventName() + " to " + registration.getPlugin().getDescription().getFullName(), e);
            }
        }
    }

    public static void closeProtocol() {
        if (protocol != null) {
            protocol.close();
        }
    }

    public static boolean isDead() {
        return protocol == null;
    }
}

