/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.protocol.events;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PlayerAutoCraftEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    protected final Inventory craftingInventory;
    protected final boolean isShift;
    private Event.Result useAutoCraft;

    public PlayerAutoCraftEvent(@Nonnull Player who, @Nullable Inventory craftingInventory, boolean isShift) {
        super(who);
        this.craftingInventory = craftingInventory;
        this.isShift = isShift;
        this.useAutoCraft = craftingInventory == null ? Event.Result.DENY : Event.Result.ALLOW;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.useAutoCraft() == Event.Result.DENY;
    }

    public void setCancelled(boolean cancel) {
        this.useAutoCraft(cancel ? Event.Result.DENY : (this.useAutoCraft() == Event.Result.DENY ? Event.Result.DEFAULT : this.useAutoCraft()));
    }

    public boolean isShift() {
        return this.isShift;
    }

    @Nullable
    public Inventory getCrafting() {
        return this.craftingInventory;
    }

    @Nullable
    public ItemStack[] getContents() {
        return this.craftingInventory == null ? null : this.craftingInventory.getContents();
    }

    @Nonnull
    public Event.Result useAutoCraft() {
        return this.useAutoCraft;
    }

    public void useAutoCraft(@Nonnull Event.Result useAutoCraft) {
        this.useAutoCraft = useAutoCraft;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return handlers;
    }
}

